<?php
require_once __DIR__ . '/LanguageController.php'; class Database { private static $instance = null; private $pdo; private $dbPath; private function __construct() { $this->dbPath = DB_PATH; try { $this->connect(); } catch(PDOException $e) { die("Connection failed: " . $e->getMessage()); } } private function connect() { $this->pdo = new PDO("sqlite:" . $this->dbPath); $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION); $this->pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC); $this->initializeDatabase(); } public static function getInstance() { if (self::$instance === null) { self::$instance = new self(); } return self::$instance; } public static function resetInstance() { if (self::$instance !== null) { self::$instance->pdo = null; self::$instance = null; } } private function initializeDatabase() { $this->createAllTables(); $this->populateInitialData(); } private function createAllTables() { $sql = "CREATE TABLE IF NOT EXISTS game_state (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            credits INTEGER DEFAULT 1000,
            attention_level REAL DEFAULT 0,
            hosting_level INTEGER DEFAULT 1,
            security_level INTEGER DEFAULT 1,
            internet_speed REAL DEFAULT 8,
            visitors INTEGER DEFAULT 0,
            current_visitors INTEGER DEFAULT 0,
            total_potential_visitors INTEGER DEFAULT 0,
            visitor_satisfaction REAL DEFAULT 1.0,
            capacity_dissatisfaction_days INTEGER DEFAULT 0,
            server_online INTEGER DEFAULT 1,
            visitor_limit INTEGER DEFAULT 0,
            storage_capacity INTEGER DEFAULT 5,
            storage_used INTEGER DEFAULT 0,
            dedicated_server INTEGER DEFAULT 0,
            current_year INTEGER DEFAULT 2000,
            current_month INTEGER DEFAULT 1,
            current_day INTEGER DEFAULT 1,
            current_hour INTEGER DEFAULT 0,
            domain TEXT DEFAULT '',
            vpn_owned INTEGER DEFAULT 0,
            vpn_active INTEGER DEFAULT 0,
            vpn_capacity INTEGER DEFAULT 0,
            vpn_max_capacity INTEGER DEFAULT 30,
            last_update DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $this->addColumnIfNotExists('game_state', 'vpn_owned', 'INTEGER DEFAULT 0'); $this->addColumnIfNotExists('game_state', 'vpn_active', 'INTEGER DEFAULT 0'); $this->addColumnIfNotExists('game_state', 'vpn_capacity', 'INTEGER DEFAULT 0'); $this->addColumnIfNotExists('game_state', 'vpn_max_capacity', 'INTEGER DEFAULT 30'); try { $this->pdo->exec("UPDATE game_state SET vpn_owned = 0 WHERE vpn_owned IS NULL"); $this->pdo->exec("UPDATE game_state SET vpn_active = 0 WHERE vpn_active IS NULL"); $this->pdo->exec("UPDATE game_state SET vpn_capacity = 0 WHERE vpn_capacity IS NULL"); $this->pdo->exec("UPDATE game_state SET vpn_max_capacity = 30 WHERE vpn_max_capacity IS NULL"); } catch (Exception $e) {} $sql = "CREATE TABLE IF NOT EXISTS software (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            name TEXT NOT NULL,
            description TEXT,
            type TEXT NOT NULL,
            difficulty INTEGER DEFAULT 1,
            cost INTEGER NOT NULL,
            size_gb REAL DEFAULT 1.0,
            release_year INTEGER NOT NULL,
            popularity INTEGER DEFAULT 0,
            purchased INTEGER DEFAULT 0,
            cracked INTEGER DEFAULT 0,
            uploaded INTEGER DEFAULT 0,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $sql = "CREATE TABLE IF NOT EXISTS upgrades (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            name TEXT NOT NULL,
            type TEXT NOT NULL,
            level INTEGER DEFAULT 0,
            max_level INTEGER NOT NULL,
            base_cost INTEGER NOT NULL,
            release_year INTEGER NOT NULL,
            description TEXT,
            acquired INTEGER DEFAULT 0,
            effects TEXT DEFAULT '{}',
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $sql = "CREATE TABLE IF NOT EXISTS netmap_nodes (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            node_id TEXT NOT NULL UNIQUE,
            type TEXT NOT NULL,
            name TEXT NOT NULL,
            description TEXT,
            x REAL NOT NULL,
            y REAL NOT NULL,
            radius REAL DEFAULT 12,
            color TEXT,
            pulse_color TEXT,
            command TEXT,
            icon TEXT,
            effect_type TEXT,
            effect_value REAL,
            reward_type TEXT,
            reward_value REAL,
            active INTEGER DEFAULT 1,
            created_year INTEGER,
            created_month INTEGER,
            accumulated_effect REAL DEFAULT 0,
            last_effect_year INTEGER,
            last_effect_month INTEGER,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $sql = "CREATE TABLE IF NOT EXISTS game_state_meta (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            key_name TEXT NOT NULL UNIQUE,
            value TEXT NOT NULL
        )"; $this->pdo->exec($sql); $sql = "CREATE TABLE IF NOT EXISTS ads (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            name TEXT NOT NULL,
            description TEXT,
            type TEXT NOT NULL,
            impression_count INTEGER NOT NULL,
            credit_per_impression REAL NOT NULL,
            completion_months INTEGER NOT NULL,
            start_year INTEGER,
            start_month INTEGER,
            end_year INTEGER,
            end_month INTEGER,
            is_accepted INTEGER DEFAULT 0,
            current_impressions INTEGER DEFAULT 0,
            visitor_satisfaction_effect REAL DEFAULT 0,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            expires_at DATETIME,
            total_credit REAL
        )"; $this->pdo->exec($sql); $sql = "CREATE TABLE IF NOT EXISTS event_log (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            type TEXT NOT NULL,
            message TEXT NOT NULL,
            event_time TEXT NOT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_event_log_created_at ON event_log(created_at)"); $sql = "CREATE TABLE IF NOT EXISTS competitors (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            domain TEXT NOT NULL,
            visitors INTEGER DEFAULT 0,
            is_player INTEGER DEFAULT 0,
            rank INTEGER DEFAULT 0,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            last_update DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_competitors_visitors ON competitors(visitors DESC)"); $sql = "CREATE TABLE IF NOT EXISTS anonchat_messages (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            title TEXT NOT NULL,
            message TEXT NOT NULL,
            is_read INTEGER DEFAULT 0,
            trigger_type TEXT NOT NULL,
            trigger_condition TEXT,
            year INTEGER,
            month INTEGER,
            folder TEXT DEFAULT 'inbox',
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            read_at DATETIME,
            metadata TEXT NULL
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_anonchat_messages_trigger ON anonchat_messages(is_read, trigger_type, year, month)"); $sql = "CREATE TABLE IF NOT EXISTS player_notes (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            title TEXT DEFAULT '',
            content TEXT NOT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_player_notes_updated ON player_notes(updated_at)"); $sql = "CREATE TABLE IF NOT EXISTS secret_commands (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            command TEXT NOT NULL,
            credit_reward INTEGER DEFAULT 0,
            visitor_reward INTEGER DEFAULT 0,
            used INTEGER DEFAULT 0,
            created_at DATETIME,
            used_at DATETIME
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_secret_commands_command ON secret_commands(command)"); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_secret_commands_used ON secret_commands(used)"); $sql = "CREATE TABLE IF NOT EXISTS forum_topics (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            title TEXT NOT NULL,
            content TEXT NOT NULL,
            user_name TEXT NOT NULL,
            is_harmful INTEGER DEFAULT 0,
            status INTEGER DEFAULT 0,
            year INTEGER NOT NULL,
            month INTEGER NOT NULL,
            quarter INTEGER NOT NULL,
            is_moderated INTEGER DEFAULT 0,
            effect_value REAL DEFAULT 0.02,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_forum_topics_time_period ON forum_topics(year, month, quarter, is_moderated)"); $sql = "CREATE TABLE IF NOT EXISTS missions (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            title TEXT NOT NULL,
            description TEXT NOT NULL,
            difficulty INTEGER DEFAULT 1,
            target_ip TEXT NOT NULL,
            secondary_ip TEXT,
            reward_credits INTEGER NOT NULL,
            status INTEGER DEFAULT 0,
            completion_objective TEXT NOT NULL,
            mission_type TEXT NOT NULL,
            trace_threshold INTEGER DEFAULT 70,
            trace_timer INTEGER DEFAULT 300,
            is_available INTEGER DEFAULT 0,
            year_available INTEGER,
            month_available INTEGER,
            completed_at DATETIME,
            is_tutorial INTEGER DEFAULT 0,
            active INTEGER DEFAULT 0,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $sql = "CREATE TABLE IF NOT EXISTS mission_filesystem (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            mission_id INTEGER NOT NULL,
            target_ip TEXT NOT NULL,
            path TEXT NOT NULL,
            name TEXT NOT NULL,
            is_directory INTEGER DEFAULT 0,
            content TEXT,
            is_mission_objective INTEGER DEFAULT 0,
            size INTEGER DEFAULT 0,
            permissions TEXT DEFAULT 'rw-r--r--',
            ssh_required INTEGER DEFAULT 0,
            ssh_username TEXT,
            ssh_password TEXT,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (mission_id) REFERENCES missions(id) ON DELETE CASCADE
        )"; $this->pdo->exec($sql); $sql = "CREATE TABLE IF NOT EXISTS mission_logs (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            mission_id INTEGER NOT NULL,
            target_ip TEXT NOT NULL,
            command TEXT NOT NULL,
            trace_impact INTEGER DEFAULT 0,
            timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (mission_id) REFERENCES missions(id) ON DELETE CASCADE
        )"; $this->pdo->exec($sql); $sql = "CREATE TABLE IF NOT EXISTS mission_progress (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            mission_id INTEGER NOT NULL,
            current_ip TEXT NOT NULL,
            current_directory TEXT DEFAULT '/',
            trace_level INTEGER DEFAULT 0,
            timer_started_at DATETIME,
            is_alarm_triggered INTEGER DEFAULT 0,
            discovered_files TEXT,
            completed_objectives TEXT,
            started_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (mission_id) REFERENCES missions(id) ON DELETE CASCADE
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_missions_availability ON missions(is_available, year_available, month_available)"); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_mission_filesystem ON mission_filesystem(mission_id, target_ip, path)"); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_mission_logs_mission ON mission_logs(mission_id)"); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_mission_progress_mission ON mission_progress(mission_id)"); $sql = "CREATE TABLE IF NOT EXISTS mission_ping_targets (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            mission_id INTEGER NOT NULL,
            target_ip TEXT NOT NULL,
            pinged_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (mission_id) REFERENCES missions(id) ON DELETE CASCADE,
            UNIQUE(mission_id, target_ip)
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_mission_ping_targets ON mission_ping_targets(mission_id)"); $sql = "CREATE TABLE IF NOT EXISTS breaking_news (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            threshold INTEGER NOT NULL,
            title TEXT NOT NULL,
            content TEXT NOT NULL,
            ticker TEXT NOT NULL,
            severity TEXT NOT NULL,
            is_game_over INTEGER DEFAULT 0,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $sql = "CREATE TABLE IF NOT EXISTS breaking_news_viewed (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            news_id INTEGER NOT NULL,
            viewed_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (news_id) REFERENCES breaking_news(id)
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_breaking_news_threshold ON breaking_news(threshold)"); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_breaking_news_viewed ON breaking_news_viewed(news_id)"); $sql = "CREATE TABLE IF NOT EXISTS tutorials (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            type TEXT NOT NULL,
            step INTEGER DEFAULT 1,
            completed INTEGER DEFAULT 0,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            completed_at DATETIME
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_tutorials_type ON tutorials(type, completed)"); $sql = "CREATE TABLE IF NOT EXISTS crypto_wallet (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            tsx_balance REAL DEFAULT 0.0,
            total_earned REAL DEFAULT 0.0,
            total_spent REAL DEFAULT 0.0,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $sql = "CREATE TABLE IF NOT EXISTS mining_pcs (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            pc_name TEXT NOT NULL,
            ip_address TEXT NOT NULL,
            power_level REAL NOT NULL,
            daily_tsx_rate REAL NOT NULL,
            grid_position INTEGER DEFAULT 0,
            x_position REAL DEFAULT 0,
            y_position REAL DEFAULT 0,
            status TEXT DEFAULT 'active',
            discovered_year INTEGER NOT NULL,
            discovered_month INTEGER NOT NULL,
            last_income_year INTEGER,
            last_income_month INTEGER,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            lost_at DATETIME
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_mining_pcs_status ON mining_pcs(status)"); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_mining_pcs_power ON mining_pcs(power_level DESC)"); $sql = "CREATE TABLE IF NOT EXISTS tsx_price_history (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            price REAL NOT NULL,
            game_year INTEGER NOT NULL,
            game_month INTEGER NOT NULL,
            game_day INTEGER NOT NULL,
            change_percent REAL DEFAULT 0.0,
            volume REAL DEFAULT 0.0,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_tsx_price_date ON tsx_price_history(game_year, game_month, game_day)"); $sql = "CREATE TABLE IF NOT EXISTS crypto_transactions (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            type TEXT NOT NULL,
            amount REAL NOT NULL,
            tsx_price REAL NOT NULL,
            credit_amount REAL DEFAULT 0.0,
            description TEXT,
            game_year INTEGER NOT NULL,
            game_month INTEGER NOT NULL,
            game_day INTEGER NOT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_crypto_transactions_type ON crypto_transactions(type)"); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_crypto_transactions_date ON crypto_transactions(game_year, game_month, game_day)"); $sql = "CREATE TABLE IF NOT EXISTS mining_scans (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            scan_cost REAL NOT NULL,
            pcs_found INTEGER DEFAULT 0,
            game_year INTEGER NOT NULL,
            game_month INTEGER NOT NULL,
            game_day INTEGER NOT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_mining_scans_date ON mining_scans(game_year, game_month, game_day)"); $sql = "CREATE TABLE IF NOT EXISTS player_files (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            filename TEXT NOT NULL,
            content TEXT,
            size INTEGER DEFAULT 0,
            source_mission_id INTEGER,
            source_ip TEXT,
            source_path TEXT,
            copied_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            game_year INTEGER NOT NULL,
            game_month INTEGER NOT NULL,
            game_day INTEGER NOT NULL
        )"; $this->pdo->exec($sql); $this->pdo->exec("CREATE INDEX IF NOT EXISTS idx_player_files_date ON player_files(game_year, game_month, game_day)"); } private function addColumnIfNotExists($table, $column, $definition) { try { $result = $this->pdo->query("PRAGMA table_info($table)")->fetchAll(PDO::FETCH_ASSOC); $columnExists = false; foreach ($result as $col) { if ($col['name'] === $column) { $columnExists = true; break; } } if (!$columnExists) { $this->pdo->exec("ALTER TABLE $table ADD COLUMN $column $definition"); } } catch (Exception $e) { } } private function populateInitialData() { $result = $this->query("SELECT COUNT(*) as count FROM game_state")->fetch(); if ($result['count'] == 0) { $this->query( "INSERT INTO game_state (
                    credits,
                    attention_level,
                    hosting_level,
                    security_level,
                    internet_speed,
                    visitors,
                    current_visitors,
                    total_potential_visitors,
                    visitor_satisfaction,
                    capacity_dissatisfaction_days,
                    server_online,
                    storage_capacity,
                    storage_used,
                    dedicated_server,
                    current_year,
                    current_month,
                    current_day,
                    current_hour
                ) VALUES (
                    1750, 0, 1, 0, 6, 0, 0, 0, 1.0, 0, 1, 3, 0, 0, 2000, 1, 1, 0
                )" ); } else { $this->query( "UPDATE game_state SET
                current_month = 1,
                current_day = 1,
                current_hour = 0,
                capacity_dissatisfaction_days = 0,
                server_online = 1
                WHERE current_month IS NULL OR capacity_dissatisfaction_days IS NULL OR server_online IS NULL" ); } $result = $this->query("SELECT COUNT(*) as count FROM game_state_meta WHERE key_name = 'last_restart_time'")->fetch(); if ($result['count'] == 0) { $this->query( "INSERT INTO game_state_meta (key_name, value) VALUES ('last_restart_time', '0')" ); } $result = $this->query("SELECT COUNT(*) as count FROM software")->fetch(); if ($result['count'] == 0) { $this->query("
                INSERT INTO software (name, description, type, difficulty, cost, size_gb, release_year, popularity, purchased, cracked, uploaded) VALUES
                -- 2000 Yılı Yazılımları
                ('Macrosoft Doors 2000', 'Business operating system', 'OS', 2, 400, 0.8, 2000, 35, 0, 0, 0),
                ('Macrosoft WorkPlace 2000', 'Productivity suite', 'App', 1, 350, 0.5, 2000, 25, 0, 0, 0),
                ('Photoblender 6', 'Image editing software', 'App', 1, 300, 0.6, 2000, 30, 0, 0, 0),
                ('WebBuilder 2000', 'Website creation tool', 'App', 1, 250, 0.3, 2000, 20, 0, 0, 0),
                ('NorthShield Security 2000', 'Antivirus program', 'App', 1, 200, 0.2, 2000, 25, 0, 0, 0),
                ('DreamWorld', 'Life simulation game', 'Game', 2, 300, 0.7, 2000, 35, 0, 0, 0),
                ('Cosmic Warriors', 'Space shooter game', 'Game', 1, 250, 0.5, 2000, 30, 0, 0, 0),
                ('Blast Arena', 'Fast-paced FPS game', 'Game', 2, 280, 0.9, 2000, 35, 0, 0, 0),
                ('SoundMixer Pro', 'Audio editing software', 'App', 1, 220, 0.4, 2000, 20, 0, 0, 0),
                ('WebWanderer Navigator', 'Web browser', 'App', 1, 180, 0.2, 2000, 25, 0, 0, 0),

                -- 2001 Yılı Yazılımları
                ('Macrosoft Doors ME', 'Millennium edition OS', 'OS', 2, 500, 1.0, 2001, 40, 0, 0, 0),
                ('Torrent Share Pro', 'P2P file sharing client', 'App', 1, 350, 0.3, 2001, 55, 0, 0, 0),
                ('AIM Talk 2001', 'Instant messaging client', 'App', 1, 200, 0.2, 2001, 45, 0, 0, 0),
                ('Fantasy Quest X', 'Turn-based RPG adventure', 'Game', 2, 450, 1.5, 2001, 62, 0, 0, 0),
                ('Street Auto III', 'Urban crime action game', 'Game', 2, 500, 1.2, 2001, 65, 0, 0, 0),
                ('Bullet Time', 'Cinematic action shooter', 'Game', 2, 400, 1.0, 2001, 58, 0, 0, 0),
                ('ICQ Messenger 2001', 'Multi-platform chat client', 'App', 1, 250, 0.2, 2001, 48, 0, 0, 0),
                ('AudioAmp Deluxe', 'Advanced media player', 'App', 1, 180, 0.1, 2001, 42, 0, 0, 0),
                ('Blaze Burner', 'CD/DVD burning software', 'App', 1, 300, 0.4, 2001, 50, 0, 0, 0),
                ('LimeShare', 'Decentralized file sharing', 'App', 1, 220, 0.3, 2001, 52, 0, 0, 0),

                -- 2002-2003 Yazılımları
                ('Macrosoft Doors XP', 'Enhanced OS with new UI', 'OS', 3, 600, 1.5, 2002, 65, 0, 0, 0),
                ('Red Planet', 'Strategy game set on Mars', 'Game', 2, 400, 1.2, 2002, 68, 0, 0, 0),
                ('VideoMaster 2002', 'Video editing suite', 'App', 2, 450, 1.0, 2002, 53, 0, 0, 0),
                ('CodeStudio 2002', 'Programming IDE', 'App', 2, 350, 0.8, 2002, 50, 0, 0, 0),
                ('Shadow Operative', 'Stealth action game', 'Game', 2, 480, 1.3, 2002, 62, 0, 0, 0),
                ('Realm Warriors Online', 'Fantasy MMORPG', 'Game', 3, 550, 1.6, 2002, 58, 0, 0, 0),
                ('DinoWorld', 'Prehistoric simulation game', 'Game', 2, 500, 1.4, 2003, 72, 0, 0, 0),
                ('Photoblender 8', 'Advanced image editing', 'App', 2, 480, 1.1, 2003, 58, 0, 0, 0),
                ('Macrosoft WorkPlace 2003', 'Enhanced productivity suite', 'App', 2, 550, 1.2, 2003, 60, 0, 0, 0),
                ('Data Guardian 2003', 'Advanced security suite', 'App', 2, 400, 0.9, 2003, 52, 0, 0, 0),
                ('EchoLinux 2.0', 'Alternative operating system', 'OS', 3, 500, 1.3, 2003, 60, 0, 0, 0),
                ('MediaStation 2003', 'Media player and organizer', 'App', 1, 300, 0.7, 2003, 48, 0, 0, 0),
                ('Ancient Order', 'Classic RPG adventure', 'Game', 3, 580, 1.7, 2003, 68, 0, 0, 0),
                ('Desert Prince', 'Acrobatic action game', 'Game', 2, 520, 1.5, 2003, 65, 0, 0, 0),

                -- 2004-2006 Yazılımları
                ('Macrosoft Doors Vista', 'Next-gen operating system', 'OS', 4, 800, 2.8, 2006, 68, 0, 0, 0),
                ('Macrosoft WorkPlace 2005', 'Professional productivity suite', 'App', 2, 600, 1.5, 2005, 65, 0, 0, 0),
                ('Unreal Engine 2004', 'Game development platform', 'App', 3, 700, 2.0, 2004, 72, 0, 0, 0),
                ('Medieval Dynasty', 'Historical strategy game', 'Game', 3, 650, 2.2, 2004, 75, 0, 0, 0),
                ('Photoblender CS', 'Professional image suite', 'App', 3, 650, 1.8, 2004, 70, 0, 0, 0),
                ('Hell Spawn III', 'Horror FPS game', 'Game', 3, 680, 2.3, 2004, 77, 0, 0, 0),
                ('Empire Conquest: Rome', 'Historical strategy epic', 'Game', 3, 720, 2.5, 2004, 73, 0, 0, 0),
                ('FruitOS X', 'Premium operating system', 'OS', 4, 900, 2.5, 2005, 75, 0, 0, 0),
                ('Battlefield 2100', 'Futuristic warfare game', 'Game', 3, 750, 3.0, 2005, 80, 0, 0, 0),
                ('VideoMaster Pro 2005', 'Professional video editing', 'App', 3, 680, 2.2, 2005, 68, 0, 0, 0),
                ('Zombie Manor 4', 'Survival horror masterpiece', 'Game', 3, 780, 3.2, 2005, 85, 0, 0, 0),
                ('Faction Wars', 'Competitive online RPG', 'Game', 3, 820, 3.5, 2005, 78, 0, 0, 0),
                ('Oraclus DB 10', 'Enterprise database system', 'App', 4, 850, 1.9, 2006, 62, 0, 0, 0),
                ('Call of Heroes', 'Military FPS game', 'Game', 3, 800, 3.5, 2006, 82, 0, 0, 0),
                ('Halo Dawn', 'Sci-fi shooter masterpiece', 'Game', 3, 850, 3.8, 2006, 85, 0, 0, 0),
                ('Speed Riot 2', 'Extreme racing game', 'Game', 2, 700, 3.2, 2006, 75, 0, 0, 0),
                ('Dragon Era Chronicles', 'Dark fantasy RPG', 'Game', 3, 900, 4.0, 2006, 80, 0, 0, 0),

                -- 2007-2009 Yazılımları
                ('Macrosoft Doors 7', 'Streamlined operating system', 'OS', 4, 1000, 3.8, 2009, 82, 0, 0, 0),
                ('Macrosoft WorkPlace 2007', 'Complete office solution', 'App', 3, 800, 2.5, 2007, 72, 0, 0, 0),
                ('3D Studio Global', '3D modeling software', 'App', 4, 900, 3.2, 2008, 75, 0, 0, 0),
                ('Grand Auto Theft', 'Open world action game', 'Game', 4, 1200, 4.5, 2008, 88, 0, 0, 0),
                ('Falldown 3', 'Post-apocalyptic RPG', 'Game', 4, 1100, 4.8, 2008, 86, 0, 0, 0),
                ('Dead Zone 4', 'Survival horror game', 'Game', 3, 950, 3.8, 2008, 82, 0, 0, 0),
                ('Mirror Runner', 'Parkour action game', 'Game', 3, 880, 3.5, 2008, 78, 0, 0, 0),
                ('Photoblender CS3', 'Complete creative suite', 'App', 3, 850, 2.8, 2007, 74, 0, 0, 0),
                ('Dimension Shift', 'Puzzle-platform game', 'Game', 3, 750, 2.5, 2007, 78, 0, 0, 0),
                ('BioImpact', 'Underwater horror shooter', 'Game', 3, 820, 3.0, 2007, 80, 0, 0, 0),
                ('Team Fortress Classic', 'Multiplayer team shooter', 'Game', 2, 680, 2.0, 2007, 72, 0, 0, 0),
                ('Night City', 'Cyberpunk RPG game', 'Game', 4, 1100, 4.2, 2009, 85, 0, 0, 0),
                ('LinuxPro Enterprise', 'Advanced server OS', 'OS', 5, 1200, 4.0, 2008, 70, 0, 0, 0),
                ('Dreamweaver Master', 'Web development suite', 'App', 3, 750, 2.4, 2007, 68, 0, 0, 0),
                ('Final Illusion XIII', 'Epic fantasy RPG', 'Game', 4, 1000, 4.8, 2009, 84, 0, 0, 0),
                ('AudioMaster Studio', 'Professional audio workstation', 'App', 3, 780, 2.6, 2008, 70, 0, 0, 0),
                ('Dark Knight', 'Superhero action game', 'Game', 4, 1050, 5.0, 2009, 88, 0, 0, 0),
                ('Left 4 Survival', 'Cooperative zombie shooter', 'Game', 3, 920, 4.5, 2009, 82, 0, 0, 0),
                ('Dragon Era Origins', 'Epic fantasy RPG', 'Game', 4, 1080, 5.5, 2009, 85, 0, 0, 0),

                -- 2010-2012 Yazılımları
                ('Macrosoft Doors 8', 'Touch-optimized OS', 'OS', 4, 1500, 5.0, 2012, 80, 0, 0, 0),
                ('Crysis Maximum', 'Cutting-edge FPS game', 'Game', 5, 1800, 8.5, 2011, 90, 0, 0, 0),
                ('Macrosoft WorkPlace 2010', 'Cloud-integrated office suite', 'App', 3, 1200, 3.5, 2010, 78, 0, 0, 0),
                ('StarShip 2', 'Epic space RPG', 'Game', 4, 1400, 7.5, 2010, 87, 0, 0, 0),
                ('Assassin Brotherhood', 'Historical action game', 'Game', 3, 1250, 6.5, 2010, 82, 0, 0, 0),
                ('Super Meat Guy', 'Hardcore platformer', 'Game', 2, 950, 0.8, 2010, 75, 0, 0, 0),
                ('Battlefield Warfare', 'Large-scale combat game', 'Game', 4, 1600, 7.0, 2011, 87, 0, 0, 0),
                ('CADMaster 2012', 'Professional design software', 'App', 4, 1400, 4.5, 2012, 80, 0, 0, 0),
                ('FruitOS Mountain', 'Refined operating system', 'OS', 4, 1600, 5.5, 2012, 85, 0, 0, 0),
                ('World Soccer 2011', 'Soccer simulation', 'Game', 3, 1300, 6.0, 2010, 82, 0, 0, 0),
                ('Dimension Portal 2', 'Cooperative puzzle game', 'Game', 3, 1350, 7.0, 2011, 88, 0, 0, 0),
                ('City Skylines', 'City building simulator', 'Game', 3, 1150, 5.5, 2011, 80, 0, 0, 0),
                ('Dark Spirits', 'Hardcore action RPG', 'Game', 5, 1450, 6.5, 2011, 86, 0, 0, 0),
                ('Adove Creator Suite', 'All-in-one creative suite', 'App', 4, 1500, 5.0, 2011, 82, 0, 0, 0),
                ('Court Legends 2012', 'Sports simulation', 'Game', 3, 1200, 6.5, 2012, 80, 0, 0, 0),
                ('Master Chef Simulator', 'Cooking game', 'Game', 2, 900, 4.0, 2010, 72, 0, 0, 0),
                ('Wasteland Looter 2', 'Looter shooter RPG', 'Game', 4, 1500, 8.0, 2012, 85, 0, 0, 0),
                ('Dishonored Blade', 'Stealth action game', 'Game', 3, 1350, 7.5, 2012, 83, 0, 0, 0),
                ('Dead Walking', 'Episodic adventure game', 'Game', 2, 1100, 5.0, 2012, 78, 0, 0, 0),

                -- 2013-2015 Yazılımları
                ('Macrosoft Doors 10', 'Modern operating system', 'OS', 5, 2000, 8.0, 2015, 92, 0, 0, 0),
                ('Auto Thief V6', 'Massive open world game', 'Game', 5, 2500, 25.0, 2014, 95, 0, 0, 0),
                ('WitchGer 3', 'Fantasy RPG masterpiece', 'Game', 5, 2200, 20.0, 2015, 94, 0, 0, 0),
                ('Macrosoft WorkPlace 2015', 'Modern productivity suite', 'App', 4, 1800, 5.5, 2015, 85, 0, 0, 0),
                ('Photoblender CC', 'Creative cloud image editor', 'App', 4, 1600, 6.0, 2014, 84, 0, 0, 0),
                ('Premiere Editor Pro', 'Professional video suite', 'App', 4, 1700, 6.5, 2013, 82, 0, 0, 0),
                ('BioImpact Unlimited', 'Dystopian shooter', 'Game', 4, 1650, 12.0, 2013, 85, 0, 0, 0),
                ('Crypt Raider', 'Action-adventure reboot', 'Game', 4, 1580, 10.5, 2013, 82, 0, 0, 0),
                ('Street Kings Online', 'Online multiplayer expansion', 'Game', 4, 1700, 15.0, 2013, 88, 0, 0, 0),
                ('Unison Engine 5', 'Game development platform', 'App', 5, 2000, 7.0, 2015, 88, 0, 0, 0),
                ('Call of Heroes: Modern War', 'Military shooter', 'Game', 4, 1900, 18.0, 2014, 92, 0, 0, 0),
                ('Maya 3D Studio', 'Professional 3D modeling', 'App', 5, 2100, 8.0, 2014, 83, 0, 0, 0),
                ('Final Illusion XV', 'Epic fantasy adventure', 'Game', 5, 2300, 23.0, 2015, 90, 0, 0, 0),
                ('Dragon Era Inquisition', 'Fantasy RPG sequel', 'Game', 4, 1850, 19.0, 2014, 88, 0, 0, 0),
                ('Shadow of Battlefield', 'Tactical stealth game', 'Game', 4, 1750, 16.0, 2014, 86, 0, 0, 0),
                ('Alien Separation', 'Survival horror game', 'Game', 4, 1680, 14.0, 2014, 84, 0, 0, 0),
                ('Hunter Blood', 'Gothic action RPG', 'Game', 5, 2100, 21.0, 2015, 92, 0, 0, 0),
                ('Tactical Gear V', 'Tactical espionage game', 'Game', 5, 2050, 22.0, 2015, 91, 0, 0, 0),
                ('Falldown 4', 'Post-apocalyptic RPG', 'Game', 5, 2200, 24.0, 2015, 89, 0, 0, 0),
                
                -- Security Utilities
                ('VPN', 'Reduce trace detection by 50% during VDS missions', 'Utility', 1, 500, 0.1, 2000, 100, 0, 0, 0)
            "); } $result = $this->query("SELECT COUNT(*) as count FROM upgrades")->fetch(); if ($result['count'] == 0) { $this->query("
                INSERT INTO upgrades (name, type, level, max_level, base_cost, release_year, description, effects, acquired) VALUES
                ('" . t_sql('game.upgrades.types.shared_hosting_tier_1') . "', 'hosting', 1, 5, 500, 2000, '" . t_sql('game.upgrades.descriptions.shared_hosting_tier_1') . "', '{\"capacity\":100}', 1),
                ('" . t_sql('game.upgrades.types.shared_hosting_tier_2') . "', 'hosting', 0, 5, 1000, 2000, '" . t_sql('game.upgrades.descriptions.shared_hosting_tier_2') . "', '{\"capacity\":200}', 0),
                ('" . t_sql('game.upgrades.types.shared_hosting_tier_3') . "', 'hosting', 0, 5, 2000, 2001, '" . t_sql('game.upgrades.descriptions.shared_hosting_tier_3') . "', '{\"capacity\":300}', 0),
                ('" . t_sql('game.upgrades.types.shared_hosting_tier_4') . "', 'hosting', 0, 5, 4000, 2002, '" . t_sql('game.upgrades.descriptions.shared_hosting_tier_4') . "', '{\"capacity\":400}', 0),
                ('" . t_sql('game.upgrades.types.shared_hosting_tier_5') . "', 'hosting', 0, 5, 8000, 2003, '" . t_sql('game.upgrades.descriptions.shared_hosting_tier_5') . "', '{\"capacity\":500}', 0),

                ('" . t_sql('game.upgrades.types.dedicated_server_tier_1') . "', 'dedicated_server', 0, 5, 10000, 2002, '" . t_sql('game.upgrades.descriptions.dedicated_server_tier_1') . "', '{\"capacity\":1000}', 0),
                ('" . t_sql('game.upgrades.types.dedicated_server_tier_2') . "', 'dedicated_server', 0, 5, 20000, 2003, '" . t_sql('game.upgrades.descriptions.dedicated_server_tier_2') . "', '{\"capacity\":2000}', 0),
                ('" . t_sql('game.upgrades.types.dedicated_server_tier_3') . "', 'dedicated_server', 0, 5, 40000, 2004, '" . t_sql('game.upgrades.descriptions.dedicated_server_tier_3') . "', '{\"capacity\":4000}', 0),
                ('" . t_sql('game.upgrades.types.dedicated_server_tier_4') . "', 'dedicated_server', 0, 5, 80000, 2005, '" . t_sql('game.upgrades.descriptions.dedicated_server_tier_4') . "', '{\"capacity\":8000}', 0),
                ('" . t_sql('game.upgrades.types.dedicated_server_tier_5') . "', 'dedicated_server', 0, 5, 160000, 2006, '" . t_sql('game.upgrades.descriptions.dedicated_server_tier_5') . "', '{\"capacity\":16000}', 0),

                ('" . t_sql('game.upgrades.types.botnet_addon') . "', 'hosting_addon', 0, 5, 5000, 2004, '" . t_sql('game.upgrades.descriptions.botnet_addon') . "', '{\"capacity_multiplier\":0.2}', 0),
                ('" . t_sql('game.upgrades.types.load_balancer') . "', 'hosting_addon', 0, 3, 3000, 2001, '" . t_sql('game.upgrades.descriptions.load_balancer') . "', '{\"capacity_multiplier\":0.15}', 0),
                ('" . t_sql('game.upgrades.types.cdn_integration') . "', 'hosting_addon', 0, 2, 7500, 2002, '" . t_sql('game.upgrades.descriptions.cdn_integration') . "', '{\"capacity_multiplier\":0.25}', 0),

                ('" . t_sql('game.upgrades.types.basic_firewall') . "', 'security', 0, 1, 1000, 2000, '" . t_sql('game.upgrades.descriptions.basic_firewall') . "', '{\"attention_reduction\":0.1}', 0),
                ('" . t_sql('game.upgrades.types.advanced_firewall') . "', 'security', 0, 1, 3000, 2002, '" . t_sql('game.upgrades.descriptions.advanced_firewall') . "', '{\"attention_reduction\":0.2}', 0),
                ('" . t_sql('game.upgrades.types.ip_masking') . "', 'security', 0, 1, 5000, 2003, '" . t_sql('game.upgrades.descriptions.ip_masking') . "', '{\"attention_reduction\":0.3}', 0),
                ('" . t_sql('game.upgrades.types.vpn_service') . "', 'security', 0, 1, 8000, 2005, '" . t_sql('game.upgrades.descriptions.vpn_service') . "', '{\"attention_reduction\":0.4}', 0),
                ('" . t_sql('game.upgrades.types.honeypot') . "', 'security', 0, 1, 15000, 2006, '" . t_sql('game.upgrades.descriptions.honeypot') . "', '{\"attention_reset\":50}', 0),

                ('" . t_sql('game.upgrades.types.ad_revenue_booster') . "', 'tools', 0, 1, 2000, 2001, '" . t_sql('game.upgrades.descriptions.ad_revenue_booster') . "', '{\"ad_revenue_boost\":0.2}', 0),
                ('" . t_sql('game.upgrades.types.auto_defense_basic') . "', 'tools', 0, 1, 3000, 2003, '" . t_sql('game.upgrades.descriptions.auto_defense_basic') . "', '{\"auto_defense_chance\":0.30}', 0),
                ('" . t_sql('game.upgrades.types.auto_defense_advanced') . "', 'tools', 0, 1, 6000, 2004, '" . t_sql('game.upgrades.descriptions.auto_defense_advanced') . "', '{\"auto_defense_chance\":0.50}', 0),
                ('" . t_sql('game.upgrades.types.auto_crack') . "', 'tools', 0, 1, 5000, 2005, '" . t_sql('game.upgrades.descriptions.auto_crack') . "', '{\"auto_crack_stage_1\":true}', 0),
                ('" . t_sql('game.upgrades.types.auto_defense_pro') . "', 'tools', 0, 1, 12000, 2007, '" . t_sql('game.upgrades.descriptions.auto_defense_pro') . "', '{\"auto_defense_chance\":0.85}', 0),

                ('" . t_sql('game.upgrades.types.speed_16') . "', 'internet', 0, 1, 2000, 2002, '" . t_sql('game.upgrades.descriptions.speed_16') . "', '{\"speed\":16, \"upload_boost\":0.1}', 0),
                ('" . t_sql('game.upgrades.types.speed_24') . "', 'internet', 0, 1, 4000, 2004, '" . t_sql('game.upgrades.descriptions.speed_24') . "', '{\"speed\":24, \"upload_boost\":0.15}', 0),
                ('" . t_sql('game.upgrades.types.speed_50') . "', 'internet', 0, 1, 8000, 2006, '" . t_sql('game.upgrades.descriptions.speed_50') . "', '{\"speed\":50, \"upload_boost\":0.25}', 0),
                ('" . t_sql('game.upgrades.types.speed_100') . "', 'internet', 0, 1, 15000, 2008, '" . t_sql('game.upgrades.descriptions.speed_100') . "', '{\"speed\":100, \"upload_boost\":0.4}', 0),
                ('" . t_sql('game.upgrades.types.speed_250') . "', 'internet', 0, 1, 25000, 2010, '" . t_sql('game.upgrades.descriptions.speed_250') . "', '{\"speed\":250, \"upload_boost\":0.6}', 0),

                ('" . t_sql('game.upgrades.types.storage_5gb') . "', 'upload_storage', 0, 1, 500, 2000, '" . t_sql('game.upgrades.descriptions.storage_5gb') . "', '{\"capacity\":5}', 0),
                ('" . t_sql('game.upgrades.types.storage_10gb') . "', 'upload_storage', 0, 1, 1000, 2002, '" . t_sql('game.upgrades.descriptions.storage_10gb') . "', '{\"capacity\":10}', 0),
                ('" . t_sql('game.upgrades.types.storage_20gb') . "', 'upload_storage', 0, 1, 2500, 2004, '" . t_sql('game.upgrades.descriptions.storage_20gb') . "', '{\"capacity\":20}', 0),
                ('" . t_sql('game.upgrades.types.storage_50gb') . "', 'upload_storage', 0, 1, 5000, 2005, '" . t_sql('game.upgrades.descriptions.storage_50gb') . "', '{\"capacity\":50}', 0),
                ('" . t_sql('game.upgrades.types.storage_75gb') . "', 'upload_storage', 0, 1, 8000, 2008, '" . t_sql('game.upgrades.descriptions.storage_75gb') . "', '{\"capacity\":75}', 0),
                ('" . t_sql('game.upgrades.types.storage_100gb') . "', 'upload_storage', 0, 1, 12000, 2009, '" . t_sql('game.upgrades.descriptions.storage_100gb') . "', '{\"capacity\":100}', 0),

                ('" . t_sql('game.upgrades.types.community_forum') . "', 'website', 0, 1, 3000, 2001, '" . t_sql('game.upgrades.descriptions.community_forum') . "', '{\"visitor_bonus\":50, \"satisfaction_bonus\":0.1}', 0),
                ('" . t_sql('game.upgrades.types.request_system') . "', 'website', 0, 1, 3500, 2002, '" . t_sql('game.upgrades.descriptions.request_system') . "', '{\"visitor_bonus\":50, \"satisfaction_bonus\":0.1}', 0),
                ('" . t_sql('game.upgrades.types.mirror_sites') . "', 'website', 0, 1, 4000, 2003, '" . t_sql('game.upgrades.descriptions.mirror_sites') . "', '{\"visitor_bonus\":50, \"satisfaction_bonus\":0.1}', 0),
                ('" . t_sql('game.upgrades.types.fake_reviews') . "', 'website', 0, 1, 3000, 2002, '" . t_sql('game.upgrades.descriptions.fake_reviews') . "', '{\"visitor_bonus\":50, \"satisfaction_bonus\":0.1}', 0),

                ('" . t_sql('game.upgrades.types.ads_campaign') . "', 'marketing', 0, 5, 1000, 2001, '" . t_sql('game.upgrades.descriptions.ads_campaign') . "', '{\"visitor_bonus\":100, \"attention_bonus\":5}', 0),
                ('" . t_sql('game.upgrades.types.referral_program') . "', 'marketing', 0, 1, 2500, 2003, '" . t_sql('game.upgrades.descriptions.referral_program') . "', '{\"visitor_bonus\":100}', 0),
                ('" . t_sql('game.upgrades.types.seo_tools') . "', 'marketing', 0, 1, 6000, 2004, '" . t_sql('game.upgrades.descriptions.seo_tools') . "', '{\"visitor_bonus\":200}', 0)
            "); } $result = $this->query("SELECT COUNT(*) as count FROM competitors")->fetch(); if ($result['count'] == 0) { $competitorNames = [ 'torrentsphere.eu', 'buccaneerbay.org', 'punchpunch.to', 'yolo-torrents.com', 'tvzone.it', 'citrustorrents.cc', 'torrentgroove.com', 'bitpeek.com', 'torrentengine.net', 'impish.ph', 'downloaddepot.me', 'sharewave.com', 'magnetlink.eu', 'peerportal.org', 'seedershaven.to', 'leecherslair.net', 'uploaduniverse.com', 'meganova.org', 'seedpeer.me', 'torrenthound.com', 'btscene.cc', 'yourbittorrent.com', 'extratorrent.cd', 'torrentcrazy.eu', 'btjunkie.org', 'sumotorrent.sx', 'magnetdl.com', 'torrentbox.si', 'torrentfive.com', 'torrentreactor.com', 'monova.org', 'torrentbit.net', 'vertor.com', 'seedpeer.eu', 'btdigg.org', 'btstorrent.cc', 'torrentproject.se', 'torrentstar.org', 'torrentresource.com', 'torrenting.com', 'thepirate.me', 'torrents.de', 'torrentpond.com', 'bt-scene.cc', 'torrentscan.com', 'torrentdragon.com', 'newtorrents.info', 'bigtorrent.org', 'fulltorrents.net' ]; $baseVisitorCounts = []; $initialValue = 1500; $decayFactor = 0.92; for ($i = 0; $i < count($competitorNames); $i++) { $baseValue = $initialValue * pow($decayFactor, $i); $baseVisitorCounts[$i] = round($baseValue); } $baseVisitorCounts[count($baseVisitorCounts) - 1] = max(10, $baseVisitorCounts[count($baseVisitorCounts) - 1]); for ($i = 0; $i < count($competitorNames); $i++) { $variation = mt_rand(-5, 5) / 100; $visitorCount = round($baseVisitorCounts[$i] * (1 + $variation)); $visitorCount += mt_rand(1, 9); $this->query("
                    INSERT INTO competitors (domain, visitors, is_player, rank) VALUES ('{$competitorNames[$i]}', {$visitorCount}, 0, " . ($i + 1) . ")
                "); } } $result = $this->query("SELECT COUNT(*) as count FROM anonchat_messages")->fetch(); if ($result['count'] == 0) { $this->query("
                INSERT INTO anonchat_messages (title, message, is_read, trigger_type, year, month) VALUES
                ('" . t_sql('game.anonchat.welcome_title') . "', '" . t_sql('game.anonchat.welcome_message') . "', 0, 'date', 2000, 1)
            "); } $result = $this->query("SELECT COUNT(*) as count FROM player_notes")->fetch(); if ($result['count'] == 0) { $seedCheck = $this->query("SELECT COUNT(*) as count FROM game_state_meta WHERE key_name = 'player_notes_seeded'")->fetch(); if ($seedCheck['count'] == 0) { $defaultContent = "first_notes.txt\n\n  _____                    _             \n |  __ \\                  | |            \n | |  | | ___  _ __   __ _| |_ ___  _ __ \n | |  | |/ _ \\| '_ \\ / _` | __/ _ \\| '__|\n | |__| | (_) | | | | (_| | || (_) | |   \n |_____/ \\___/|_| |_|\\__,_|\\__\\___/|_|   \n\n  /\\_/\\  \n ( o.o )  Notes...\n  > ^ <\n"; $this->query("INSERT INTO player_notes (title, content) VALUES (?, ?)", ['first_notes.txt', $defaultContent]); $this->query("INSERT INTO game_state_meta (key_name, value) VALUES ('player_notes_seeded', '1')"); } } $result = $this->query("SELECT COUNT(*) as count FROM missions")->fetch(); if ($result['count'] == 0) { $this->query("
                INSERT INTO missions (title, description, difficulty, target_ip, secondary_ip, reward_credits, completion_objective, mission_type, trace_threshold, trace_timer, is_available, year_available, month_available, is_tutorial) VALUES
                ('" . t_sql('game.missions.greenhealth_title') . "', '" . t_sql('game.missions.greenhealth_description') . "', 1, '78.45.32.12', NULL, 500, 'find_file:customers.db', 'data_theft', 65, 300, 1, 2000, 3, 0),
                ('" . t_sql('game.missions.fastburger_title') . "', '" . t_sql('game.missions.fastburger_description') . "', 2, '192.168.1.58', '10.0.5.22', 1200, 'decrypt_file:secret_recipe.enc', 'multi_stage', 60, 450, 0, 2000, 8, 0),
                ('" . t_sql('game.missions.techstart_title') . "', '" . t_sql('game.missions.techstart_description') . "', 1, '203.45.67.89', NULL, 750, 'find_file:account_ledger.xls', 'data_theft', 70, 300, 0, 2001, 2, 0),
                ('" . t_sql('game.missions.cybernews_title') . "', '" . t_sql('game.missions.cybernews_description') . "', 2, '91.23.45.67', NULL, 1000, 'steal_data:3', 'espionage', 75, 400, 0, 2001, 6, 0),
                ('" . t_sql('game.missions.pharmacorp_title') . "', '" . t_sql('game.missions.pharmacorp_description') . "', 2, '156.78.90.12', NULL, 1200, 'delete_file:evidence.doc', 'sabotage', 80, 350, 0, 2002, 4, 0),
                ('" . t_sql('game.missions.globallogistics_title') . "', '" . t_sql('game.missions.globallogistics_description') . "', 3, '203.45.12.8', '10.10.0.5', 1500, 'ping_targets:172.16.5.10,192.168.100.25,10.20.30.15,88.77.66.55,45.123.89.200', 'network_scan', 85, 500, 0, 2002, 9, 0),
                ('" . t_sql('game.missions.megagames_title') . "', '" . t_sql('game.missions.megagames_description') . "', 3, '67.89.123.45', NULL, 1800, 'find_file:source_code_F6_finally.zip', 'data_theft', 90, 450, 0, 2003, 3, 0),
                ('" . t_sql('game.missions.securevault_title') . "', '" . t_sql('game.missions.securevault_description') . "', 4, '45.67.89.123', NULL, 2000, 'plant_backdoor:/etc/rc.local:V4ultS3cur3', 'backdoor', 95, 400, 0, 2003, 8, 0),
                ('" . t_sql('game.missions.government_title') . "', '" . t_sql('game.missions.government_description') . "', 4, '123.45.67.89', NULL, 2500, 'decrypt_file:classified.pgp', 'infiltration', 100, 600, 0, 2004, 5, 0),
                ('" . t_sql('game.missions.ispdatacenter_title') . "', '" . t_sql('game.missions.ispdatacenter_description') . "', 5, '89.123.45.67', NULL, 3000, 'modify_file:/etc/routing.conf:R0ut3rAcc3ss:/opt/security/VPNSecurityTool.exe', 'sabotage', 105, 500, 0, 2004, 11, 0),
                ('" . t_sql('game.missions.military_title') . "', '" . t_sql('game.missions.military_description') . "', 5, '155.22.88.4', '10.20.30.1,172.16.5.10', 3500, 'delete_multiple:/var/lib/weapons_db.sql,/opt/defense/contracts.db,/home/classified/projects.sqlite', 'chain_hack', 110, 700, 0, 2005, 2, 0),
                ('" . t_sql('game.missions.cryptobank_title') . "', '" . t_sql('game.missions.cryptobank_description') . "', 5, '234.56.78.90', '10.30.40.1,172.20.10.5', 4000, 'decrypt_file:vault_keys.aes', 'multi_stage', 115, 800, 0, 2005, 7, 0),
                ('" . t_sql('game.missions.techsecure_title') . "', '" . t_sql('game.missions.techsecure_description') . "', 6, '78.90.123.45', '10.15.20.30', 4500, 'steal_data:2', 'espionage', 120, 700, 0, 2006, 3, 0),
                ('" . t_sql('game.missions.dataminer_title') . "', '" . t_sql('game.missions.dataminer_description') . "', 6, '145.67.89.123', '172.18.25.50', 5000, 'modify_file:/etc/rc.local:DataPriv2006!:/home/admin/Desktop/privacy_monitor.exe,/home/db_master/security_guard.exe', 'sabotage', 125, 750, 0, 2006, 9, 0),
                ('" . t_sql('game.missions.mediacorp_title') . "', '" . t_sql('game.missions.mediacorp_description') . "', 7, '198.51.100.45', '172.16.45.122', 5500, 'collect_emails:3', 'email_harvest', 130, 800, 0, 2007, 4, 0),
                ('" . t_sql('game.missions.financetech_title') . "', '" . t_sql('game.missions.financetech_description') . "', 7, '203.0.113.89', '172.16.0.100', 6000, 'modify_content:/home/ceo/Documents/offshore_accounts.xls:9283746501:9283741461', 'credential_theft', 135, 850, 0, 2007, 10, 0),
                ('" . t_sql('game.missions.blackmarket_title') . "', '" . t_sql('game.missions.blackmarket_description') . "', 8, '192.0.2.150', '198.18.0.50', 6500, 'copy_file:/home/vaultkeeper/vault/credit_cards.db,/home/vaultkeeper/vault/ssn_database.txt:35', 'data_theft', 140, 600, 0, 2008, 3, 0),
                ('" . t_sql('game.missions.multinational_title') . "', '" . t_sql('game.missions.multinational_description') . "', 8, '203.0.113.200', '10.50.60.70,172.20.30.40,192.168.100.50', 7000, 'steal_data:6', 'espionage', 145, 900, 0, 2008, 9, 0),
                ('" . t_sql('game.missions.forensics_title') . "', '" . t_sql('game.missions.forensics_description') . "', 9, '198.18.5.100', '10.25.35.45', 7500, 'corrupt_logs:3', 'log_corruption', 150, 700, 0, 2009, 4, 0),
                ('" . t_sql('game.missions.pharmatech_title') . "', '" . t_sql('game.missions.pharmatech_description') . "', 9, '203.0.113.150', NULL, 8000, 'modify_content:/home/fda_admin/approvals/approval_letter.pdf:47%:46%|0.001:0.002', 'sabotage', 155, 750, 0, 2009, 10, 0)
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (1, '78.45.32.12', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (1, '78.45.32.12', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (1, '78.45.32.12', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (1, '78.45.32.12', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (1, '78.45.32.12', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (1, '78.45.32.12', '/tmp', 'tmp', 1, NULL, 0, 'drwxr-xr-x'),
                (1, '78.45.32.12', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nwwwdata:x:33:33:www-data:/var/www:/bin/sh\ngreenhealthadmin:x:1000:1000:Green Health Admin:/home/greenhealthadmin:/bin/bash\ndbuser:x:1001:1001:Database User:/home/dbuser:/bin/bash', 2, 'rw-r--r--'),
                (1, '78.45.32.12', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n127.0.1.1 greenhealth-server\n\n# The following lines are desirable for IPv6 capable hosts\n::1     ip6-localhost ip6-loopback\nfe00::0 ip6-localnet', 1, 'rw-r--r--'),
                (1, '78.45.32.12', '/home/greenhealthadmin', 'greenhealthadmin', 1, NULL, 0, 'drwxr-x---'),
                (1, '78.45.32.12', '/home/dbuser', 'dbuser', 1, NULL, 0, 'drwxr-x---'),
                (1, '78.45.32.12', '/home/greenhealthadmin/todo.txt', 'todo.txt', 0, '1. Update server security\n2. Change default database password\n3. Move customer data to secure server\n4. Schedule meeting with IT department', 1, 'rw-r-----'),
                (1, '78.45.32.12', '/home/greenhealthadmin/.bash_history', '.bash_history', 0, 'ls -la\ncd /var/www/html\nls\ncat index.php\ncd /var/db\nls -la\nsudo service mysql restart\ncat /var/log/auth.log\nclear', 2, 'rw-------'),
                (1, '78.45.32.12', '/home/dbuser/backup.sh', 'backup.sh', 0, '#!/bin/bash\n# Daily database backup script\nmysqldump -u dbuser -p\"GH2000secure\" greenhealthdb > /var/db/backups/daily_backup.sql', 1, 'rwxr-x---'),
                (1, '78.45.32.12', '/var/www', 'www', 1, NULL, 0, 'drwxr-xr-x'),
                (1, '78.45.32.12', '/var/db', 'db', 1, NULL, 0, 'drwxr-x---'),
                (1, '78.45.32.12', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (1, '78.45.32.12', '/var/www/html', 'html', 1, NULL, 0, 'drwxr-xr-x'),
                (1, '78.45.32.12', '/var/www/html/index.php', 'index.php', 0, '<?php\n// GreenHealth Patient Portal\nsession_start();\nrequire_once \"config.php\";\nrequire_once \"db_connect.php\";\n\n// Login logic\n// ...\n?>\n<!DOCTYPE html>\n<html>\n<head>\n    <title>GreenHealth Patient Portal</title>\n</head>\n<body>\n    <h1>Welcome to GreenHealth Patient Portal</h1>\n    <!-- Login form -->\n</body>\n</html>', 4, 'rw-r--r--'),
                (1, '78.45.32.12', '/var/www/html/config.php', 'config.php', 0, '<?php\n// Database configuration\ndefine(\"DB_HOST\", \"localhost\");\ndefine(\"DB_USER\", \"dbuser\");\ndefine(\"DB_PASS\", \"GH2000secure\");\ndefine(\"DB_NAME\", \"greenhealthdb\");\n?>', 1, 'rw-r-----'),
                (1, '78.45.32.12', '/var/db/customers.db', 'customers.db', 0, 'SQLite format 3\\0\\0\\0\\0 tablecustomers\\0CREATE TABLE customers(id INTEGER PRIMARY KEY,name TEXT,email TEXT,address TEXT,phone TEXT,insurance_number TEXT,medical_history TEXT)\\0John Smith,john@example.com,123 Main St,555-1234,INS12345,Allergies: Penicillin\\0Jane Doe,jane@example.com,456 Oak Ave,555-5678,INS67890,Diabetes Type 2\\0Michael Johnson,mike@example.com,789 Pine Rd,555-9012,INS54321,Hypertension\\0', 128, 'rw-r-----'),
                (1, '78.45.32.12', '/var/db/backups', 'backups', 1, NULL, 0, 'drwxr-x---'),
                (1, '78.45.32.12', '/var/log/auth.log', 'auth.log', 0, 'May 15 10:23:15 greenhealth-server sshd[1234]: Accepted password for greenhealthadmin from 192.168.1.105 port 49812 ssh2\nMay 15 10:25:30 greenhealth-server sudo: greenhealthadmin : TTY=pts/0 ; PWD=/home/greenhealthadmin ; USER=root ; COMMAND=/bin/cat /etc/shadow\nMay 15 14:18:45 greenhealth-server sshd[1352]: Failed password for dbuser from 192.168.1.200 port 51401 ssh2\nMay 15 14:18:52 greenhealth-server sshd[1353]: Accepted password for dbuser from 192.168.1.200 port 51402 ssh2', 4, 'rw-r-----'),
                (1, '78.45.32.12', '/var/log/system.log', 'system.log', 0, 'May 15 09:15:10 greenhealth-server systemd[1]: Started Apache HTTP Server.\nMay 15 09:15:12 greenhealth-server systemd[1]: Started MySQL Database Server.\nMay 15 15:45:22 greenhealth-server kernel: [UFW BLOCK] IN=eth0 OUT= MAC=00:16:3e:e2:52:42:fe:54:00:9e:c3:c4:08:00 SRC=185.143.223.71 DST=78.45.32.12 LEN=40 TOS=0x00 PREC=0x00 TTL=245 ID=41792 PROTO=TCP SPT=45358 DPT=22 WINDOW=1024 RES=0x00 SYN URGP=0', 5, 'rw-r-----')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (2, '192.168.1.58', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (2, '192.168.1.58', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (2, '192.168.1.58', '/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (2, '192.168.1.58', '/Pictures', 'Pictures', 1, NULL, 0, 'drwxr-xr-x'),
                (2, '192.168.1.58', '/Downloads', 'Downloads', 1, NULL, 0, 'drwxr-xr-x'),
                (2, '192.168.1.58', '/home/jsmith', 'jsmith', 1, NULL, 0, 'drwxr-xr-x'),
                (2, '192.168.1.58', '/home/jsmith/work_notes.txt', 'work_notes.txt', 0, 'Meeting Notes - May 10, 2000\n\n- New marketing campaign for summer\n- IT will upgrade systems next month\n- Main server connection info below\n\nMain Server Access:\n- Server IP: 10.0.5.22\n- SSH Username: admin\n- SSH Password: B\$Pass2000\n\nNote: SSH authentication required for main server access.\n\nRemember to delete this file', 2, 'rw-r--r--'),
                (2, '192.168.1.58', '/home/jsmith/shopping_list.txt', 'shopping_list.txt', 0, 'Milk\nEggs\nBread\nApples\nCoffee\nToilet paper\nDog food', 1, 'rw-r--r--'),
                (2, '192.168.1.58', '/Documents/resume.doc', 'resume.doc', 0, 'John Smith\n123 Main Street\nAnytown, USA\n\nExperience:\n- Marketing Manager, FastBurger (1998-Present)\n- Assistant Manager, Quick Burger (1995-1998)\n\nEducation:\n- MBA, Business University (1995)\n- BA Marketing, State College (1993)', 5, 'rw-r--r--'),
                (2, '192.168.1.58', '/Documents/presentation.ppt', 'presentation.ppt', 0, 'FastBurger Marketing Strategy 2000\n\nSlide 1: Introduction\n- Market share increased 5% last quarter\n- New product line planned for Q3\n\nSlide 2: Competition Analysis\n- BurgerWorld gained 2% market share\n- QuickBites opened 3 new locations\n\nSlide 3: Strategy\n- Focus on unique sauce promotion\n- Highlight health benefits compared to competitors', 10, 'rw-r--r--'),
                (2, '192.168.1.58', '/Pictures/vacation.jpg', 'vacation.jpg', 0, '[BINARY CONTENT - Image of beach vacation]', 1500, 'rw-r--r--'),
                (2, '192.168.1.58', '/Pictures/family.jpg', 'family.jpg', 0, '[BINARY CONTENT - Family photo]', 1200, 'rw-r--r--'),
                (2, '10.0.5.22', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (2, '10.0.5.22', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (2, '10.0.5.22', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (2, '10.0.5.22', '/data', 'data', 1, NULL, 0, 'drwxr-x---'),
                (2, '10.0.5.22', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nwwwdata:x:33:33:www-data:/var/www:/bin/sh\nadmin:x:1000:1000:Server Admin:/home/admin:/bin/bash\nbackup:x:1001:1001:Backup User:/home/backup:/bin/bash', 2, 'rw-r--r--'),
                (2, '10.0.5.22', '/data/recipes', 'recipes', 1, NULL, 0, 'drwxr-x---'),
                (2, '10.0.5.22', '/data/recipes/secret_recipe.enc', 'secret_recipe.enc', 0, 'U2VjcmV0IEJ1cmdlciBTYXVjZSBSZWNpcGUKCkluZ3JlZGllbnRzOgotIDEvMiBjdXAgbWF5b25uYWlzZQotIDEvNCBjdXAga2V0Y2h1cAotIDIgdGJzcCBwaWNrbGUgcmVsaXNoCi0gMSB0c3AgZ2FybGljIHBvd2RlcgotIDEvMiB0c3AgcGFwcmlrYQotIFBpbmNoIG9mIGNheWVubmUgcGVwcGVyCi0gMSB0c3AgaG9uZXkKCk1peGluZyBJbnN0cnVjdGlvbnM6Ci0gQ29tYmluZSBhbGwgaW5ncmVkaWVudHMgaW4gYSBib3dsCi0gV2hpc2sgdW50aWwgc21vb3RoCi0gUmVmcmlnZXJhdGUgZm9yIDMwIG1pbnV0ZXMgYmVmb3JlIHNlcnZpbmcKClNlY3JldCBJbmdyZWRpZW50OgotIEEgcGluY2ggb2YgdHJ1ZmZsZSBzYWx0', 8, 'rw-------'),
                (2, '10.0.5.22', '/data/recipes/decrypt_tool', 'decrypt_tool', 0, '#!/bin/bash\n# Decryption tool for encrypted recipes\n# Usage: ./decrypt_tool [filename] [password]\n# The decryption password is the same as the admin password', 2, 'rwxr-x---'),
                (2, '10.0.5.22', '/var/log/access.log', 'access.log', 0, '10.0.5.1 - - [14/May/2000:09:23:45 -0500] \"GET /admin/dashboard.php HTTP/1.1\" 200 4523\n10.0.5.1 - - [14/May/2000:09:25:12 -0500] \"GET /admin/users.php HTTP/1.1\" 200 8765\n10.0.5.15 - - [14/May/2000:10:12:33 -0500] \"GET /admin/login.php HTTP/1.1\" 200 1234\n10.0.5.15 - - [14/May/2000:10:12:40 -0500] \"POST /admin/login.php HTTP/1.1\" 302 0\n10.0.5.15 - - [14/May/2000:10:12:42 -0500] \"GET /admin/recipes.php HTTP/1.1\" 200 6543', 5, 'rw-r-----')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (3, '203.45.67.89', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- Home directories (3 users)
                (3, '203.45.67.89', '/home/bankadmin', 'bankadmin', 1, NULL, 0, 'drwxr-x---'),
                (3, '203.45.67.89', '/home/jdoe', 'jdoe', 1, NULL, 0, 'drwxr-x---'),
                (3, '203.45.67.89', '/home/accountant', 'accountant', 1, NULL, 0, 'drwxr-x---'),

                -- Bankadmin directories
                (3, '203.45.67.89', '/home/bankadmin/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/home/bankadmin/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/home/bankadmin/Downloads', 'Downloads', 1, NULL, 0, 'drwxr-xr-x'),

                -- Desktop files (TARGET HERE)
                (3, '203.45.67.89', '/home/bankadmin/Desktop/account_ledger.xls', 'account_ledger.xls', 0, 'TechStart Bank - Account Ledger 2001\n\nAccount Number | Customer Name | Balance | Last Transaction\n123456789 | John Smith | $15,420.50 | 2001-02-15\n987654321 | Jane Doe | $8,750.25 | 2001-02-14\n456789123 | Mike Johnson | $22,100.00 | 2001-02-15\n789123456 | Sarah Wilson | $3,250.75 | 2001-02-13\n\nTotal Assets: $49,521.50\n\nNote: This file contains sensitive financial data. Keep secure', 3, 'rw-r-----'),
                (3, '203.45.67.89', '/home/bankadmin/Desktop/notes.txt', 'notes.txt', 0, 'Bank Admin Notes - Feb 2001\n\n- Update security protocols\n- Review suspicious transactions\n- Schedule maintenance for core banking system\n- Password for main system: BankSecure2001\n\nTODO: Move sensitive files to encrypted storage', 1, 'rw-r--r--'),
                (3, '203.45.67.89', '/home/bankadmin/Desktop/backup_script.sh', 'backup_script.sh', 0, '#!/bin/bash\n# Daily backup script for TechStart Bank\n# Run every night at 2 AM\n\n# Backup account data\ntar -czf /var/backups/accounts_$(date +%Y%m%d).tar.gz /home/bankadmin/Desktop/*.xls\n\n# Log backup completion\necho \"Backup completed: $(date)\" >> /var/log/backup.log', 1, 'rwxr-x---'),
                (3, '203.45.67.89', '/home/bankadmin/Desktop/readme.txt', 'readme.txt', 0, 'Welcome to TechStart Bank Internal System\n\nThis system contains sensitive financial data.\nPlease follow security protocols:\n- Change passwords monthly\n- Log out when finished\n- Report suspicious activity\n\nFor technical support, contact IT department.', 1, 'rw-r--r--'),

                -- Documents folder (decoy files)
                (3, '203.45.67.89', '/home/bankadmin/Documents/policies', 'policies', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/home/bankadmin/Documents/reports', 'reports', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/home/bankadmin/Documents/policies/security_policy.pdf', 'security_policy.pdf', 0, '[PDF] TechStart Bank Security Policy\n\nSection 1: Password Requirements\n- Minimum 12 characters\n- Must include uppercase, lowercase, numbers, symbols\n- Change every 90 days\n\nSection 2: Access Control\n- Role-based access only\n- Log all administrative actions', 5, 'rw-r--r--'),
                (3, '203.45.67.89', '/home/bankadmin/Documents/reports/monthly_summary_jan.doc', 'monthly_summary_jan.doc', 0, 'Monthly Summary - January 2001\n\nNew Accounts Opened: 45\nTotal Deposits: $125,000\nTotal Withdrawals: $98,500\nNet Growth: $26,500\n\nCustomer Satisfaction: 4.2/5\nEmployee Performance: Good', 2, 'rw-r--r--'),
                (3, '203.45.67.89', '/home/bankadmin/Documents/reports/quarterly_review_q4.doc', 'quarterly_review_q4.doc', 0, 'Q4 2000 Financial Review\n\nRevenue: $450,000\nExpenses: $380,000\nNet Profit: $70,000\n\nKey Achievements:\n- Launched online banking\n- Opened 2 new branches\n- Hired 12 new employees', 3, 'rw-r--r--'),

                -- Downloads folder (decoy)
                (3, '203.45.67.89', '/home/bankadmin/Downloads/software_update.exe', 'software_update.exe', 0, '[BINARY - Banking Software Update Package v2.1.5]', 2500, 'rw-r--r--'),
                (3, '203.45.67.89', '/home/bankadmin/Downloads/financial_template.xls', 'financial_template.xls', 0, 'Financial Report Template\n\nQuarter: ______\nYear: ______\n\nRevenue: \$______\nExpenses: \$______\nProfit: \$______', 2, 'rw-r--r--'),

                -- Other user directories (decoy users)
                (3, '203.45.67.89', '/home/jdoe/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/home/jdoe/Desktop/personal_notes.txt', 'personal_notes.txt', 0, 'Personal Notes - J. Doe\n\nGrocery list:\n- Milk\n- Eggs\n- Bread\n\nTODO:\n- Call dentist\n- Pay electricity bill\n- Fix car appointment', 1, 'rw-r--r--'),
                (3, '203.45.67.89', '/home/jdoe/Desktop/vacation_photo.jpg', 'vacation_photo.jpg', 0, '[BINARY CONTENT - Vacation photo]', 1200, 'rw-r--r--'),

                (3, '203.45.67.89', '/home/accountant/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/home/accountant/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/home/accountant/Desktop/tax_forms.xls', 'tax_forms.xls', 0, 'Tax Forms 2000\n\nEmployee Tax Information\n(This is not the account ledger you are looking for)\n\nForm 1040 data for employees...\nW-2 information...\nPayroll tax calculations...', 3, 'rw-r--r--'),
                (3, '203.45.67.89', '/home/accountant/Documents/expense_report.xls', 'expense_report.xls', 0, 'Monthly Expense Report - January 2001\n\nOffice Supplies: $450\nUtilities: $1,200\nSalaries: $45,000\nMaintenance: $800\nMarketing: $2,500\n\nTotal: $49,950', 2, 'rw-r--r--'),

                -- System directories
                (3, '203.45.67.89', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/var/backups', 'backups', 1, NULL, 0, 'drwxr-x---'),
                (3, '203.45.67.89', '/var/www', 'www', 1, NULL, 0, 'drwxr-xr-x'),

                (3, '203.45.67.89', '/var/log/auth.log', 'auth.log', 0, 'Feb 15 09:15:22 techstart-bank sshd[1234]: Accepted password for bankadmin from 192.168.1.100 port 22\nFeb 15 14:30:45 techstart-bank sudo: bankadmin : TTY=pts/0 ; PWD=/home/bankadmin ; USER=root ; COMMAND=/bin/cat /etc/shadow\nFeb 15 16:22:10 techstart-bank sshd[1356]: Failed password for bankadmin from 203.45.67.50 port 22', 2, 'rw-r-----'),
                (3, '203.45.67.89', '/var/log/system.log', 'system.log', 0, 'Feb 15 08:00:00 techstart-bank systemd[1]: Started Banking System Service\nFeb 15 08:00:05 techstart-bank systemd[1]: Started Database Service\nFeb 15 08:00:10 techstart-bank systemd[1]: Started Web Server\nFeb 15 12:30:22 techstart-bank backup[5678]: Daily backup completed successfully', 3, 'rw-r-----'),

                (3, '203.45.67.89', '/var/backups/accounts_20010214.tar.gz', 'accounts_20010214.tar.gz', 0, '[BINARY - Compressed backup file]', 2400, 'rw-r-----'),
                (3, '203.45.67.89', '/var/backups/accounts_20010215.tar.gz', 'accounts_20010215.tar.gz', 0, '[BINARY - Compressed backup file]', 2450, 'rw-r-----'),
                (3, '203.45.67.89', '/var/backups/README', 'README', 0, 'Backup Directory\n\nBackups are created daily at 2:00 AM\nRetention policy: 30 days\nBackup location: /var/backups\n\nTo restore: tar -xzf [filename]', 1, 'rw-r--r--'),

                (3, '203.45.67.89', '/var/www/html', 'html', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/var/www/html/index.html', 'index.html', 0, '<!DOCTYPE html>\n<html>\n<head><title>TechStart Bank</title></head>\n<body>\n<h1>Welcome to TechStart Bank</h1>\n<p>Your trusted financial partner since 1985</p>\n<p>Contact us: 1-800-TECHBANK</p>\n</body>\n</html>', 2, 'rw-r--r--'),

                (3, '203.45.67.89', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nbankadmin:x:1000:1000:Bank Administrator:/home/bankadmin:/bin/bash\njdoe:x:1001:1001:Jane Doe:/home/jdoe:/bin/bash\naccountant:x:1002:1002:Accountant:/home/accountant:/bin/bash\nwww-data:x:33:33:www-data:/var/www:/bin/sh', 2, 'rw-r--r--'),
                (3, '203.45.67.89', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n127.0.1.1 techstart-bank\n203.45.67.89 techstart-bank.com\n\n# Internal network\n192.168.1.1 gateway\n192.168.1.10 printer', 1, 'rw-r--r--'),

                (3, '203.45.67.89', '/usr/bin', 'bin', 1, NULL, 0, 'drwxr-xr-x'),
                (3, '203.45.67.89', '/usr/share', 'share', 1, NULL, 0, 'drwxr-xr-x'),

                (3, '203.45.67.89', '/tmp/temp_data.tmp', 'temp_data.tmp', 0, '[Temporary data - will be deleted]', 1, 'rw-rw-rw-')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (4, '91.23.45.67', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- Home directories (3 users)
                (4, '91.23.45.67', '/home/editor', 'editor', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home/reporter', 'reporter', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home/intern', 'intern', 1, NULL, 0, 'drwxr-xr-x'),

                -- Editor directories
                (4, '91.23.45.67', '/home/editor/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home/editor/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home/editor/Downloads', 'Downloads', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home/editor/.vault', '.vault', 1, NULL, 0, 'drwx------'),

                -- Desktop files (clue files)
                (4, '91.23.45.67', '/home/editor/Desktop/daily_schedule.txt', 'daily_schedule.txt', 0, 'Daily Schedule - June 15, 2001\n\n09:00 - Editorial meeting\n10:30 - Review breaking news draft\n12:00 - Lunch with legal team\n14:00 - Interview with source\n16:00 - File organization\n\nNOTE: Move all sensitive documents to secure vault\nImportant files stored in hidden .vault directory', 1, 'rw-r--r--'),
                (4, '91.23.45.67', '/home/editor/Desktop/todo.txt', 'todo.txt', 0, 'TODO - Urgent:\n\n1. Verify whistleblower documents authenticity\n2. Contact Source Alpha for follow-up\n3. Update confidential sources list\n4. Prepare for legal review\n\nREMINDER: Check reporter notes for additional leads\nSource contact info moved to secure location', 1, 'rw-r--r--'),
                (4, '91.23.45.67', '/home/editor/Desktop/meeting_minutes.doc', 'meeting_minutes.doc', 0, 'Editorial Meeting Minutes - June 14, 2001\n\nAttendees: Editor, Senior Reporter, Legal Counsel\n\nAgenda:\n- Tech company data breach story\n- Whistleblower protection protocols\n- Legal implications of publication\n\nDecisions:\n- Move sensitive files to secure storage\n- Breaking news draft saved in Documents\n- Source list encrypted and hidden\n\nNext meeting: June 18', 2, 'rw-r--r--'),

                -- Documents folder (TARGET FILE 1: breaking_news.txt)
                (4, '91.23.45.67', '/home/editor/Documents/drafts', 'drafts', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home/editor/Documents/research', 'research', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home/editor/Documents/archive', 'archive', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home/editor/Documents/drafts/breaking_news.txt', 'breaking_news.txt', 0, 'BREAKING: Major Tech Company Data Breach Exposed\n\nSources reveal that a major technology company has suffered a massive data breach affecting millions of users. The breach reportedly exposed personal information, financial data, and internal company documents.\n\nAccording to anonymous sources within the company, the breach was discovered last week but has been kept under wraps while the company attempts to assess the damage and notify affected users.\n\nThis story is embargoed until 6 PM today. Do not publish before then.\n\n- Editor in Chief', 2, 'rw-r-----'),
                (4, '91.23.45.67', '/home/editor/Documents/drafts/tech_industry_analysis.txt', 'tech_industry_analysis.txt', 0, 'Tech Industry Analysis - Q2 2001\n\nMarket trends indicate...\nCybersecurity concerns rising...\nData breach incidents up 45%...\n\n(This is not the breaking news story)', 2, 'rw-r--r--'),
                (4, '91.23.45.67', '/home/editor/Documents/research/background_info.txt', 'background_info.txt', 0, 'Background Research\n\nTech company history...\nPrevious security incidents...\nIndustry impact analysis...\n\nSee breaking news draft in drafts folder for current story', 1, 'rw-r--r--'),
                (4, '91.23.45.67', '/home/editor/Documents/archive/old_stories.txt', 'old_stories.txt', 0, 'Archived Stories - 2000\n\nVarious news stories from last year...\nNot relevant to current investigation', 3, 'rw-r--r--'),
                (4, '91.23.45.67', '/home/editor/Documents/editor_notes.txt', 'editor_notes.txt', 0, 'Editor Notes - June 2001\n\n- Meeting with legal team about whistleblower docs (check Downloads)\n- Need to verify authenticity of leaked materials\n- Prepare for potential lawsuits\n- Update security protocols for sensitive sources\n\nPassword for encrypted files: NewsSecure2001\n\nREMINDER: Source list in hidden vault, whistleblower docs in Downloads', 1, 'rw-r--r--'),

                -- Downloads folder (TARGET FILE 2: whistleblower_docs.pdf)
                (4, '91.23.45.67', '/home/editor/Downloads/whistleblower_docs.pdf', 'whistleblower_docs.pdf', 0, '[PDF CONTENT - Whistleblower Documents]\n\nThis document contains leaked internal emails, financial records, and evidence of corporate wrongdoing from a major pharmaceutical company. The documents reveal:\n\n1. Cover-up of drug side effects\n2. Bribery of regulatory officials\n3. Manipulation of clinical trial data\n4. Illegal dumping of toxic waste\n\nThis is explosive material that could bring down the entire company.\n\n- Anonymous Whistleblower', 15, 'rw-r-----'),
                (4, '91.23.45.67', '/home/editor/Downloads/press_release_template.doc', 'press_release_template.doc', 0, 'Press Release Template\n\nFOR IMMEDIATE RELEASE\n\nContact: _______\nDate: _______\n\n[Headline]\n\n[Body text]', 2, 'rw-r--r--'),
                (4, '91.23.45.67', '/home/editor/Downloads/interview_transcript.txt', 'interview_transcript.txt', 0, 'Interview Transcript - Source Beta\n\nDate: June 10, 2001\n\n[Q&A session transcript...]\n\nNote: Source mentioned additional documents\nCheck vault for sensitive source information', 2, 'rw-r--r--'),

                -- Hidden vault directory (TARGET FILE 3: confidential_sources.txt)
                (4, '91.23.45.67', '/home/editor/.vault/confidential_sources.txt', 'confidential_sources.txt', 0, 'Confidential Source List - CyberNews Media\n\nSource Alpha: Internal IT employee at TechCorp\n- Contact: alpha@securemail.com\n- Specializes in: Security vulnerabilities, internal politics\n\nSource Beta: Former government contractor\n- Contact: beta@anonymous.net\n- Specializes in: Classified information, military tech\n\nSource Gamma: Anonymous hacker collective\n- Contact: gamma@darkweb.onion\n- Specializes in: Zero-day exploits, corporate espionage\n\nNote: These sources are highly sensitive. Protect at all costs.', 1, 'rw-------'),
                (4, '91.23.45.67', '/home/editor/.vault/encryption_keys.txt', 'encryption_keys.txt', 0, 'Encryption Keys for Secure Communications\n\nPGP Key fingerprints for sources...\nEncryption protocols...\n\n(Technical security information)', 1, 'rw-------'),

                -- Reporter directory (decoy with clues)
                (4, '91.23.45.67', '/home/reporter/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home/reporter/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home/reporter/Desktop/field_notes.txt', 'field_notes.txt', 0, 'Field Notes - Junior Reporter\n\nInterviewed sources today...\nEditor has the main story files\nWhistleblower documents very sensitive\n\nEditor mentioned storing important files in:\n- Documents/drafts (breaking news)\n- Downloads (whistleblower evidence)\n- Hidden vault directory (source contacts)', 1, 'rw-r--r--'),
                (4, '91.23.45.67', '/home/reporter/Desktop/contact_log.txt', 'contact_log.txt', 0, 'Contact Log\n\nCalled Source Alpha - no answer\nEmailed Source Beta - waiting response\nEditor handling sensitive communications\n\nNote: Editor keeps confidential source list secure', 1, 'rw-r--r--'),
                (4, '91.23.45.67', '/home/reporter/Documents/story_ideas.txt', 'story_ideas.txt', 0, 'Story Ideas for Next Week\n\n1. Local government corruption\n2. Environmental concerns\n3. Tech startup profiles\n\n(Regular news assignments, not related to data breach)', 2, 'rw-r--r--'),

                -- Intern directory (decoy)
                (4, '91.23.45.67', '/home/intern/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/home/intern/Desktop/intern_tasks.txt', 'intern_tasks.txt', 0, 'Intern Tasks - Week of June 11\n\n- Organize filing system\n- Update website content\n- Research story backgrounds\n- Coffee runs\n\nNo access to sensitive investigations', 1, 'rw-r--r--'),
                (4, '91.23.45.67', '/home/intern/Desktop/learning_resources.txt', 'learning_resources.txt', 0, 'Journalism Resources\n\nRecommended reading...\nOnline courses...\nStyle guides...', 1, 'rw-r--r--'),

                -- System directories
                (4, '91.23.45.67', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/var/www', 'www', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/var/log/system.log', 'system.log', 0, 'Jun 15 08:30:15 cybernews-server systemd[1]: Started Apache HTTP Server.\nJun 15 08:30:16 cybernews-server systemd[1]: Started MySQL Database Server.\nJun 15 12:45:22 cybernews-server kernel: [UFW BLOCK] IN=eth0 OUT= MAC=00:16:3e:e2:52:42:fe:54:00:9e:c3:c4:08:00 SRC=185.143.223.71 DST=91.23.45.67 LEN=40 TOS=0x00 PREC=0x00 TTL=245 ID=41792 PROTO=TCP SPT=45358 DPT=22 WINDOW=1024 RES=0x00 SYN URGP=0\nJun 15 15:20:33 cybernews-server sshd[1456]: Accepted password for editor from 192.168.1.200 port 22', 3, 'rw-r-----'),
                (4, '91.23.45.67', '/var/log/auth.log', 'auth.log', 0, 'Jun 15 09:00:22 cybernews-server sshd[1234]: Accepted password for editor from 192.168.1.200 port 22\nJun 15 11:30:45 cybernews-server sudo: editor : TTY=pts/0 ; PWD=/home/editor ; USER=root ; COMMAND=/bin/mkdir .vault\nJun 15 14:15:10 cybernews-server sshd[1456]: Accepted password for reporter from 192.168.1.201 port 22', 2, 'rw-r-----'),
                (4, '91.23.45.67', '/var/www/html', 'html', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/var/www/html/index.html', 'index.html', 0, '<!DOCTYPE html>\n<html>\n<head><title>CyberNews Media</title></head>\n<body>\n<h1>CyberNews Media</h1>\n<p>Your source for technology news and analysis</p>\n<p>Breaking news coming soon...</p>\n</body>\n</html>', 2, 'rw-r--r--'),

                (4, '91.23.45.67', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\neditor:x:1000:1000:News Editor:/home/editor:/bin/bash\nreporter:x:1001:1001:News Reporter:/home/reporter:/bin/bash\nintern:x:1002:1002:Intern:/home/intern:/bin/bash\nwww-data:x:33:33:www-data:/var/www:/bin/sh', 1, 'rw-r--r--'),
                (4, '91.23.45.67', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n127.0.1.1 cybernews-server\n91.23.45.67 cybernews.com', 1, 'rw-r--r--'),

                (4, '91.23.45.67', '/usr/bin', 'bin', 1, NULL, 0, 'drwxr-xr-x'),
                (4, '91.23.45.67', '/usr/share', 'share', 1, NULL, 0, 'drwxr-xr-x'),

                (4, '91.23.45.67', '/tmp/temp_notes.txt', 'temp_notes.txt', 0, '[Temporary file - may be deleted]', 1, 'rw-rw-rw-')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (5, '156.78.90.12', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- Home directories (3 users)
                (5, '156.78.90.12', '/home/executive', 'executive', 1, NULL, 0, 'drwxr-x---'),
                (5, '156.78.90.12', '/home/legal', 'legal', 1, NULL, 0, 'drwxr-x---'),
                (5, '156.78.90.12', '/home/research', 'research', 1, NULL, 0, 'drwxr-x---'),

                -- Executive directories
                (5, '156.78.90.12', '/home/executive/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/home/executive/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/home/executive/Private', 'Private', 1, NULL, 0, 'drwx------'),

                -- Desktop files (TARGET HERE - clues point to Private folder)
                (5, '156.78.90.12', '/home/executive/Desktop/meeting_notes.txt', 'meeting_notes.txt', 0, 'Executive Meeting Notes - April 2002\n\nAttendees: CEO, CFO, Legal Head, R&D Director\n\nAgenda: Damage Control for XZ-2000 Scandal\n\n- Legal estimates \$2.3 billion in potential lawsuits\n- FDA investigation could shut down production for 2 years\n- Stock price has dropped 40% since rumors started\n- Need to destroy all evidence before regulators arrive\n\nAction Items:\n- Move evidence.doc to secure Private folder\n- Pressure whistleblower employees to recant\n- Prepare PR campaign to discredit critics\n\nNext meeting: Tomorrow at 9 AM', 2, 'rw-r-----'),
                (5, '156.78.90.12', '/home/executive/Desktop/urgent_memo.txt', 'urgent_memo.txt', 0, 'URGENT MEMO - April 19, 2002\n\nFROM: Legal Department\nTO: Executive Team\n\nRE: Evidence Containment\n\nThe investigation evidence file has been moved to a secure location in the executive Private directory. Access is restricted.\n\nFile name: evidence.doc\nLocation: /home/executive/Private/\n\nAll copies on shared drives have been deleted.\nDo NOT discuss this matter via email.\n\n- Legal Counsel', 1, 'rw-r-----'),
                (5, '156.78.90.12', '/home/executive/Desktop/calendar.txt', 'calendar.txt', 0, 'April 2002 Calendar\n\nApril 15 - Board meeting\nApril 18 - FDA inquiry received\nApril 19 - Emergency executive meeting\nApril 20 - Evidence secured in Private folder\nApril 22 - Legal strategy session\nApril 25 - Press conference preparation\n\nNote: All sensitive documents now in Private directory', 1, 'rw-r--r--'),
                (5, '156.78.90.12', '/home/executive/Desktop/company_report_q1.doc', 'company_report_q1.doc', 0, 'PharmaCorp Q1 2002 Report\n\nRevenue: \$125 million\nExpenses: \$98 million\nNet Income: \$27 million\n\nDrug XZ-2000 sales: \$45 million (35% of revenue)\n\nNote: Regulatory concerns may impact Q2 performance\n\n(General financial report - not the evidence file)', 3, 'rw-r--r--'),

                -- Documents folder (decoy files with clues)
                (5, '156.78.90.12', '/home/executive/Documents/presentations', 'presentations', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/home/executive/Documents/reports', 'reports', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/home/executive/Documents/presentations/board_presentation_apr.ppt', 'board_presentation_apr.ppt', 0, '[PowerPoint] Board Presentation - April 2002\n\nSlide 1: Q1 Performance\nSlide 2: XZ-2000 Sales Growth\nSlide 3: Market Expansion Plans\nSlide 4: Risk Management (Redacted)\n\nNote: Sensitive risk information removed and stored separately\nSee Private folder for full investigation details', 4, 'rw-r--r--'),
                (5, '156.78.90.12', '/home/executive/Documents/reports/sales_analysis.xls', 'sales_analysis.xls', 0, 'Sales Analysis - Q1 2002\n\nProduct breakdown by region...\nXZ-2000 performance metrics...\nMarket share analysis...\n\n(Standard sales report)', 3, 'rw-r--r--'),
                (5, '156.78.90.12', '/home/executive/Documents/reports/risk_assessment.doc', 'risk_assessment.doc', 0, 'Risk Assessment - April 2002\n\nIdentified risks:\n- Regulatory scrutiny increasing\n- Competitor market movements\n- Supply chain concerns\n\nCritical risk: FDA investigation\nDetailed evidence moved to secure storage\nContact legal for access to full documentation', 2, 'rw-r--r--'),

                -- Private folder (TARGET FILE HERE)
                (5, '156.78.90.12', '/home/executive/Private/evidence.doc', 'evidence.doc', 0, 'CONFIDENTIAL - PharmaCorp Internal Investigation\n\nSubject: Side Effects Cover-up - Drug XZ-2000\n\nOur internal investigation has revealed that our flagship drug XZ-2000 has severe side effects that were deliberately concealed from regulatory authorities. The following evidence has been compiled:\n\n1. Clinical trial data showing 15% of patients experienced severe liver damage\n2. Internal emails discussing how to \"massage\" the data for FDA submission\n3. Financial records showing payments to key FDA officials\n4. Testimony from former employees who were pressured to remain silent\n\nThis evidence must be destroyed immediately to protect the company from massive lawsuits and regulatory action.\n\n- Legal Department', 4, 'rw-------'),
                (5, '156.78.90.12', '/home/executive/Private/backup_plan.txt', 'backup_plan.txt', 0, 'Backup Plan - Confidential\n\nIf investigation proceeds:\n1. Destroy all physical evidence\n2. Delete digital records\n3. Prepare legal defense\n4. Initiate PR damage control\n\nEmergency contacts:\nLegal: ext. 5501\nPR: ext. 5502', 1, 'rw-------'),
                (5, '156.78.90.12', '/home/executive/Private/password_vault.txt', 'password_vault.txt', 0, 'Executive Password Vault\n\nEmail: exec_pharma_2002\nVPN: PharmaSecure#2002\nFile encryption: XZ2000Legal\n\nChange all passwords after evidence disposal', 1, 'rw-------'),

                -- Legal directory (decoy with clues)
                (5, '156.78.90.12', '/home/legal/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/home/legal/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/home/legal/Desktop/case_notes.txt', 'case_notes.txt', 0, 'Legal Case Notes - XZ-2000 Investigation\n\nApril 18: FDA inquiry received\nApril 19: Internal evidence review\nApril 20: Evidence secured in executive Private folder\n\nStrategy: Contain information, prepare defense\n\nKey file: evidence.doc (executive access only)\nLocation: /home/executive/Private/', 2, 'rw-r-----'),
                (5, '156.78.90.12', '/home/legal/Desktop/legal_strategy.doc', 'legal_strategy.doc', 0, 'Legal Defense Strategy\n\n1. Deny all allegations\n2. Challenge evidence authenticity\n3. Claim regulatory compliance\n4. Settle quietly if necessary\n\nPrimary concern: Internal investigation document\nMust be destroyed before FDA access', 2, 'rw-r-----'),
                (5, '156.78.90.12', '/home/legal/Documents/contracts', 'contracts', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/home/legal/Documents/contracts/vendor_agreements.pdf', 'vendor_agreements.pdf', 0, '[PDF] Vendor Agreements\n\nStandard legal contracts...\nSupplier terms...\n\n(Not related to investigation)', 5, 'rw-r--r--'),

                -- Research directory (decoy)
                (5, '156.78.90.12', '/home/research/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/home/research/lab_data', 'lab_data', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/home/research/Desktop/research_notes.txt', 'research_notes.txt', 0, 'Research Notes - XZ-2000 Development\n\nDrug compound analysis...\nEfficacy studies...\nSide effect observations noted but not reported\n\nNote: Full investigation report with legal team', 2, 'rw-r--r--'),
                (5, '156.78.90.12', '/home/research/lab_data/trial_results.xls', 'trial_results.xls', 0, 'Clinical Trial Results - XZ-2000\n\nPhase 1: Successful\nPhase 2: Positive results (some adverse events)\nPhase 3: Concerns raised\n\nDetailed adverse event data submitted to legal\nEvidence file contains full analysis', 3, 'rw-r--r--'),
                (5, '156.78.90.12', '/home/research/lab_data/protocol_summary.doc', 'protocol_summary.doc', 0, 'Study Protocol Summary\n\nObjectives, methodology, outcomes...\n\n(Standard research documentation)', 2, 'rw-r--r--'),

                -- System directories
                (5, '156.78.90.12', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/var/backups', 'backups', 1, NULL, 0, 'drwxr-x---'),
                (5, '156.78.90.12', '/var/www', 'www', 1, NULL, 0, 'drwxr-xr-x'),

                (5, '156.78.90.12', '/var/log/system.log', 'system.log', 0, 'Apr 20 08:15:30 pharmacorp-server systemd[1]: Started Apache HTTP Server.\nApr 20 10:30:45 pharmacorp-server kernel: [UFW BLOCK] IN=eth0 OUT= MAC=00:16:3e:e2:52:42:fe:54:00:9e:c3:c4:08:00 SRC=203.45.67.89 DST=156.78.90.12 LEN=40 TOS=0x00 PREC=0x00 TTL=245 ID=41792 PROTO=TCP SPT=45358 DPT=22 WINDOW=1024 RES=0x00 SYN URGP=0\nApr 20 14:22:15 pharmacorp-server sshd[1789]: Accepted password for executive from 192.168.1.150 port 22', 2, 'rw-r-----'),
                (5, '156.78.90.12', '/var/log/auth.log', 'auth.log', 0, 'Apr 19 09:30:15 pharmacorp-server sshd[1234]: Accepted password for executive from 192.168.1.150 port 22\nApr 19 11:15:42 pharmacorp-server sudo: executive : TTY=pts/0 ; PWD=/home/executive ; USER=root ; COMMAND=/bin/mkdir Private\nApr 20 10:22:33 pharmacorp-server sshd[1567]: Accepted password for legal from 192.168.1.151 port 22\nApr 20 14:05:18 pharmacorp-server sudo: executive : TTY=pts/0 ; PWD=/home/executive/Desktop ; USER=root ; COMMAND=/bin/mv evidence.doc /home/executive/Private/', 3, 'rw-r-----'),
                (5, '156.78.90.12', '/var/backups/README', 'README', 0, 'Backup Directory\n\nAutomated backups daily at 2 AM\nRetention: 7 days\n\nNote: Private folders excluded from backup per security policy', 1, 'rw-r--r--'),

                (5, '156.78.90.12', '/var/www/html', 'html', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/var/www/html/index.html', 'index.html', 0, '<!DOCTYPE html>\n<html>\n<head><title>PharmaCorp</title></head>\n<body>\n<h1>PharmaCorp Pharmaceuticals</h1>\n<p>Advancing healthcare through innovation</p>\n<p>Our commitment to patient safety and regulatory compliance</p>\n</body>\n</html>', 2, 'rw-r--r--'),

                (5, '156.78.90.12', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nexecutive:x:1000:1000:Executive:/home/executive:/bin/bash\nlegal:x:1001:1001:Legal Department:/home/legal:/bin/bash\nresearch:x:1002:1002:R&D Department:/home/research:/bin/bash\nwww-data:x:33:33:www-data:/var/www:/bin/sh', 1, 'rw-r--r--'),
                (5, '156.78.90.12', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n127.0.1.1 pharmacorp-server\n156.78.90.12 pharmacorp.com', 1, 'rw-r--r--'),

                (5, '156.78.90.12', '/usr/bin', 'bin', 1, NULL, 0, 'drwxr-xr-x'),
                (5, '156.78.90.12', '/usr/share', 'share', 1, NULL, 0, 'drwxr-xr-x'),

                (5, '156.78.90.12', '/tmp/secure_delete.sh', 'secure_delete.sh', 0, '#!/bin/bash\n# Secure file deletion script\n# Usage: ./secure_delete.sh [filename]\n\nshred -vfz -n 10 \"\$1\"\necho \"File securely deleted\"', 1, 'rw-rw-rw-')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                -- Primary Server (203.45.12.8)
                (6, '203.45.12.8', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- Home directories
                (6, '203.45.12.8', '/home/logistics', 'logistics', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/home/manager', 'manager', 1, NULL, 0, 'drwxr-xr-x'),

                -- Logistics user directories
                (6, '203.45.12.8', '/home/logistics/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/home/logistics/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/home/logistics/shipping_data', 'shipping_data', 1, NULL, 0, 'drwxr-xr-x'),

                -- Desktop files (clues to backup server)
                (6, '203.45.12.8', '/home/logistics/Desktop/daily_tasks.txt', 'daily_tasks.txt', 0, 'Daily Tasks - September 15, 2002\n\n- Process new shipment orders\n- Update route schedules\n- Check backup server status (10.10.0.5)\n- Review security protocols\n- Contact military suppliers\n\nNote: Backup server contains target list for network verification', 1, 'rw-r--r--'),
                (6, '203.45.12.8', '/home/logistics/Desktop/server_notes.txt', 'server_notes.txt', 0, 'Server Notes\n\nMain Server: 203.45.12.8 (Current)\nBackup Server: 10.10.0.5\n\nBackup server credentials:\nUsername: backup_admin\nPassword: BackupSecure2002\n\nBackup server holds network scan targets list\nCheck targets.txt for complete ping list', 1, 'rw-r--r--'),

                -- Documents folder
                (6, '203.45.12.8', '/home/logistics/Documents/reports', 'reports', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/home/logistics/Documents/contracts', 'contracts', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/home/logistics/Documents/reports/monthly_summary.doc', 'monthly_summary.doc', 0, 'Monthly Summary - August 2002\n\nShipments processed: 450\nRevenue: \$2.8M\nNew contracts: 12\n\nBackup server operational\nAll systems green', 2, 'rw-r--r--'),
                (6, '203.45.12.8', '/home/logistics/Documents/contracts/client_agreements.pdf', 'client_agreements.pdf', 0, '[PDF] Client Service Agreements\n\nStandard shipping contracts...\nTerms and conditions...\n\n(General business documents)', 4, 'rw-r--r--'),

                -- Shipping data folder
                (6, '203.45.12.8', '/home/logistics/shipping_data/route_plans.txt', 'route_plans.txt', 0, 'Global Logistics - Route Planning System\n\nPrimary Routes:\n- Route A: New York -> London -> Tokyo (Priority: High)\n- Route B: Los Angeles -> Sydney -> Singapore (Priority: Medium)\n- Route C: Hamburg -> Dubai -> Mumbai (Priority: High)\n\nSecurity Notes:\n- All high-value shipments use encrypted tracking\n- Backup server at 10.10.0.5 for redundancy\n- Access logs are monitored 24/7\n- Network scan targets stored on backup server\n\nPassword for backup system: BackupSecure2002', 2, 'rw-r-----'),
                (6, '203.45.12.8', '/home/logistics/shipping_data/customer_list.xls', 'customer_list.xls', 0, 'Global Logistics - Customer Database\n\nCustomer ID | Company Name | Contact | Value\nGL001 | TechCorp Industries | john@techcorp.com | \$2.5M\nGL002 | PharmaCorp Ltd | sarah@pharmacorp.com | \$1.8M\nGL003 | Military Supply Co | mike@milsupply.gov | \$5.2M\nGL004 | Government Agency | classified@gov.org | \$3.1M\n\nNote: Military and government contracts require special handling.', 1, 'rw-r-----'),
                (6, '203.45.12.8', '/home/logistics/shipping_data/security_protocols.txt', 'security_protocols.txt', 0, 'Security Protocols - Global Logistics\n\n1. All sensitive data must be encrypted\n2. Regular security audits every quarter\n3. Backup systems must be tested monthly\n4. Access to military contracts requires clearance\n5. All employees must sign NDA\n\nBackup Server Details:\n- IP: 10.10.0.5\n- Admin: backup_admin\n- Password: BackupSecure2002\n- Port: 22 (SSH only)\n\nNetwork Verification:\n- Ping targets list stored on backup server\n- File location: /home/backup_admin/network/targets.txt', 2, 'rw-r-----'),

                -- Manager user (decoy)
                (6, '203.45.12.8', '/home/manager/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/home/manager/Desktop/manager_notes.txt', 'manager_notes.txt', 0, 'Manager Notes\n\nReview quarterly performance\nSchedule team meeting\nApprove new hires\n\nIT Notes: Check with logistics about backup server access', 1, 'rw-r--r--'),

                -- System directories
                (6, '203.45.12.8', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/var/backups', 'backups', 1, NULL, 0, 'drwxr-x---'),
                (6, '203.45.12.8', '/var/www', 'www', 1, NULL, 0, 'drwxr-xr-x'),

                (6, '203.45.12.8', '/var/log/auth.log', 'auth.log', 0, 'Sep 15 09:20:15 logistics-server sshd[1234]: Accepted password for logistics from 192.168.1.200 port 22\nSep 15 11:45:30 logistics-server sshd[1356]: Connection to backup server 10.10.0.5 established\nSep 15 14:30:22 logistics-server sudo: logistics : TTY=pts/0 ; PWD=/home/logistics ; USER=root ; COMMAND=/bin/cat /etc/shadow', 2, 'rw-r-----'),
                (6, '203.45.12.8', '/var/log/system.log', 'system.log', 0, 'Sep 15 08:00:00 logistics-server systemd[1]: Started Logistics Management Service\nSep 15 08:00:05 logistics-server systemd[1]: Started Database Service\nSep 15 11:45:30 logistics-server network: Backup server 10.10.0.5 responding\nSep 15 12:30:22 logistics-server backup[5678]: Daily sync with 10.10.0.5 completed', 2, 'rw-r-----'),

                (6, '203.45.12.8', '/var/www/html', 'html', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/var/www/html/index.html', 'index.html', 0, '<!DOCTYPE html>\n<html>\n<head><title>Global Logistics</title></head>\n<body>\n<h1>Global Logistics Corporation</h1>\n<p>Worldwide shipping and logistics solutions</p>\n<p>Serving customers since 1985</p>\n</body>\n</html>', 2, 'rw-r--r--'),

                (6, '203.45.12.8', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nlogistics:x:1000:1000:Logistics Manager:/home/logistics:/bin/bash\nmanager:x:1001:1001:Operations Manager:/home/manager:/bin/bash\nwww-data:x:33:33:www-data:/var/www:/bin/sh', 1, 'rw-r--r--'),
                (6, '203.45.12.8', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n127.0.1.1 logistics-server\n203.45.12.8 globallogistics.com\n10.10.0.5 backup-server', 1, 'rw-r--r--'),

                (6, '203.45.12.8', '/usr/bin', 'bin', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '203.45.12.8', '/usr/share', 'share', 1, NULL, 0, 'drwxr-xr-x'),

                (6, '203.45.12.8', '/tmp/sync_status.log', 'sync_status.log', 0, 'Last sync with backup server: Success\nTimestamp: 2002-09-15 11:45:30\nFiles synced: 127\nTarget list updated on backup server', 1, 'rw-rw-rw-'),

                -- Backup Server (10.10.0.5) - TARGET FILE HERE
                (6, '10.10.0.5', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '10.10.0.5', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '10.10.0.5', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '10.10.0.5', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),

                (6, '10.10.0.5', '/home/backup_admin', 'backup_admin', 1, NULL, 0, 'drwxr-x---'),
                (6, '10.10.0.5', '/home/backup_admin/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '10.10.0.5', '/home/backup_admin/backup_data', 'backup_data', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '10.10.0.5', '/home/backup_admin/network', 'network', 1, NULL, 0, 'drwxr-xr-x'),

                -- Desktop (clue to network folder)
                (6, '10.10.0.5', '/home/backup_admin/Desktop/readme.txt', 'readme.txt', 0, 'Backup Server - Readme\n\nThis server stores:\n1. Encrypted shipment backups (backup_data/)\n2. Network scan targets (network/)\n3. Security logs\n\nFor network verification tasks, check targets.txt in network folder', 1, 'rw-r--r--'),
                (6, '10.10.0.5', '/home/backup_admin/Desktop/maintenance_log.txt', 'maintenance_log.txt', 0, 'Maintenance Log - September 2002\n\nSep 10: Updated target list in network folder\nSep 12: Backup verification successful\nSep 15: Network scan targets confirmed\n\nTarget IPs for verification:\nSee /home/backup_admin/network/targets.txt', 1, 'rw-r--r--'),

                -- Backup data folder
                (6, '10.10.0.5', '/home/backup_admin/backup_data/encrypted_shipments.dat', 'encrypted_shipments.dat', 0, '[ENCRYPTED DATA - High-Value Shipment Records]\n\nThis file contains encrypted records of all high-value shipments including:\n- Military equipment\n- Government documents\n- Pharmaceutical samples\n- Technology prototypes\n\nDecryption key stored on main server (203.45.12.8)\nBackup created: 2002-09-15 02:00:00', 5, 'rw-------'),
                (6, '10.10.0.5', '/home/backup_admin/backup_data/sync_manifest.txt', 'sync_manifest.txt', 0, 'Sync Manifest\n\nLast sync: 2002-09-15 11:45:30\nFiles synced: 127\nStatus: Success\n\nNext scheduled sync: 2002-09-16 02:00:00', 1, 'rw-r--r--'),

                -- Network folder (TARGET FILE)
                (6, '10.10.0.5', '/home/backup_admin/network/targets.txt', 'targets.txt', 0, 'Network Verification Target List\n\nGlobal Logistics - Customer Network Scan\nLast Updated: 2002-09-15\n\nVerify connectivity to customer servers:\n\n172.16.5.10 - TechCorp Industries (Europe)\n192.168.100.25 - PharmaCorp Ltd (Asia Pacific)\n10.20.30.15 - Military Supply Co (North America)\n88.77.66.55 - Government Agency (Classified Location)\n45.123.89.200 - Distribution Center Alpha\n\nNote: All customer systems must respond for network audit completion', 2, 'rw-r-----'),
                (6, '10.10.0.5', '/home/backup_admin/network/scan_history.log', 'scan_history.log', 0, 'Network Scan History\n\nSep 10 02:00 - All customer targets responding\nSep 11 02:00 - All customer targets responding\nSep 12 02:00 - All customer targets responding\nSep 13 02:00 - 88.77.66.55 timeout (resolved)\nSep 14 02:00 - All customer targets responding\nSep 15 02:00 - All customer targets responding', 2, 'rw-r--r--'),

                -- System directories
                (6, '10.10.0.5', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (6, '10.10.0.5', '/var/log/backup.log', 'backup.log', 0, 'Sep 15 02:00:00 backup-server: Starting daily backup from 203.45.12.8\nSep 15 02:05:30 backup-server: Backup completed successfully\nSep 15 02:05:31 backup-server: Encrypted sensitive data stored\nSep 15 02:05:32 backup-server: Backup verification passed\nSep 15 02:05:33 backup-server: Network targets list updated', 2, 'rw-r-----'),
                (6, '10.10.0.5', '/var/log/system.log', 'system.log', 0, 'Sep 15 08:00:00 backup-server systemd[1]: Started Backup Service\nSep 15 11:45:30 backup-server sshd[1234]: Connection from 203.45.12.8 accepted\nSep 15 14:30:22 backup-server backup[5678]: Network verification targets ready', 2, 'rw-r-----'),

                (6, '10.10.0.5', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nbackup_admin:x:1000:1000:Backup Administrator:/home/backup_admin:/bin/bash\nwww-data:x:33:33:www-data:/var/www:/bin/sh', 1, 'rw-r--r--'),
                (6, '10.10.0.5', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n127.0.1.1 backup-server\n10.10.0.5 backup-server\n203.45.12.8 main-server', 1, 'rw-r--r--')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (7, '67.89.123.45', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- Home directories
                (7, '67.89.123.45', '/home/developer', 'developer', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home/artist', 'artist', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home/sound', 'sound', 1, NULL, 0, 'drwxr-xr-x'),

                -- Developer directories
                (7, '67.89.123.45', '/home/developer/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home/developer/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home/developer/Downloads', 'Downloads', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home/developer/Projects', 'Projects', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home/developer/.backup', '.backup', 1, NULL, 0, 'drwxr-xr-x'),

                -- Desktop files
                (7, '67.89.123.45', '/home/developer/Desktop/dev_notes.txt', 'dev_notes.txt', 0, 'Developer Notes - March 2003\n\n- Fix bug in physics engine\n- Optimize graphics for older hardware\n- Add more enemy types\n- Test multiplayer stability\n- Prepare for alpha testing\n\nLatest build: F6_finally in Projects folder\nOlder versions archived in .backup\n\nPassword for encrypted files: GameDev2003\n\nRemember: This project is confidential', 1, 'rw-r--r--'),
                (7, '67.89.123.45', '/home/developer/Desktop/todo.txt', 'todo.txt', 0, 'TODO List - Week of March 10\n\n[X] Commit version F5 to SVN\n[X] Fix rendering bug\n[X] Update sound effects\n[ ] Final code review\n[ ] Prepare master build (F6_finally)\n[ ] Archive old builds\n\nNote: F6_finally is the FINAL release candidate', 1, 'rw-r--r--'),

                -- Documents folder
                (7, '67.89.123.45', '/home/developer/Documents/project_timeline.doc', 'project_timeline.doc', 0, 'Cyber Warriors 2003 - Project Timeline\n\nPhase 1 (Complete): Engine development\nPhase 2 (Complete): Asset creation\nPhase 3 (Complete): Level design\nPhase 4 (In Progress): Testing & Polish\nPhase 5 (Upcoming): Release preparation\n\nCurrent Status: 85% complete\nRelease Date: Q3 2003', 2, 'rw-r--r--'),
                (7, '67.89.123.45', '/home/developer/Documents/team_contacts.txt', 'team_contacts.txt', 0, 'MegaGames Studio - Team Contacts\n\nLead Developer: Alex Chen (alex@megagames.com)\nGraphics Artist: Sarah Johnson (sarah@megagames.com)\nSound Engineer: Mike Rodriguez (mike@megagames.com)\nAI Programmer: David Kim (david@megagames.com)\nProject Manager: Lisa Wang (lisa@megagames.com)', 1, 'rw-r--r--'),

                -- Downloads folder (decoy files)
                (7, '67.89.123.45', '/home/developer/Downloads/source_code_1541.zip', 'source_code_1541.zip', 0, '[ZIP CONTENT - OLD BUILD 1541]\n\nCyber Warriors 2003 - Build 1541\nDate: January 15, 2003\n\nThis is an early development build.\nMany features are incomplete or broken.\n\nNOTE: This is NOT the final version.\nDo not distribute this build.', 18, 'rw-r-----'),
                (7, '67.89.123.45', '/home/developer/Downloads/game_assets.zip', 'game_assets.zip', 0, '[ZIP CONTENT - Game Assets]\n\nContains:\n- Texture files\n- 3D models\n- Sound effects\n- Music tracks\n\nSize: 450 MB\nLast Updated: Feb 2003', 12, 'rw-r--r--'),
                (7, '67.89.123.45', '/home/developer/Downloads/tools.zip', 'tools.zip', 0, '[ZIP CONTENT - Development Tools]\n\nDevelopment utilities:\n- Level editor\n- Model viewer\n- Sound mixer\n- Debug tools', 8, 'rw-r--r--'),

                -- Projects folder - Main project
                (7, '67.89.123.45', '/home/developer/Projects/CyberWarriors2003', 'CyberWarriors2003', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home/developer/Projects/CyberWarriors2003/readme.txt', 'readme.txt', 0, 'Cyber Warriors 2003 - Development Notes\n\nGame Features:\n- 3D graphics engine\n- Multiplayer support (8 players)\n- Advanced AI system\n- 50+ levels\n- Custom physics engine\n\nDevelopment Status: 85% complete\nRelease Date: Q3 2003\n\nTeam:\n- Lead Developer: Alex Chen\n- Graphics: Sarah Johnson\n- Sound: Mike Rodriguez\n- AI: David Kim\n\nFINAL BUILD: source_code_F6_finally.zip\nLocated in: /home/developer/Projects/CyberWarriors2003/builds/\n\nThis game will revolutionize the FPS genre!', 2, 'rw-r--r--'),
                (7, '67.89.123.45', '/home/developer/Projects/CyberWarriors2003/design_docs.pdf', 'design_docs.pdf', 0, '[PDF CONTENT - Game Design Documents]\n\nContains detailed game design including:\n- Level layouts and flow\n- Character designs and models\n- Complete storyline\n- Game mechanics and physics\n- Marketing strategy\n- Multiplayer modes\n\nConfidential - Internal use only', 8, 'rw-r-----'),
                (7, '67.89.123.45', '/home/developer/Projects/CyberWarriors2003/changelog.txt', 'changelog.txt', 0, 'Cyber Warriors 2003 - Changelog\n\nBuild F6_finally (Mar 15, 2003) - FINAL RELEASE CANDIDATE\n- Fixed all critical bugs\n- Optimized performance\n- Final audio mixing\n- Ready for gold master\n\nBuild F1 (Mar 10, 2003)\n- Major refactoring\n- New multiplayer features\n\nBuild 548D (Feb 20, 2003)\n- Alpha testing build\n- Various bug fixes\n\nBuild 1541 (Jan 15, 2003)\n- Early development version', 2, 'rw-r--r--'),

                -- Builds folder (various versions)
                (7, '67.89.123.45', '/home/developer/Projects/CyberWarriors2003/builds', 'builds', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home/developer/Projects/CyberWarriors2003/builds/source_code_548D.zip', 'source_code_548D.zip', 0, '[ZIP CONTENT - BUILD 548D]\n\nCyber Warriors 2003 - Alpha Build 548D\nDate: February 20, 2003\n\nAlpha testing version.\nStill contains known bugs:\n- Physics glitches\n- Texture loading issues\n- Memory leaks\n\nNOTE: Not suitable for release.\nUse F6_finally for final build.', 22, 'rw-r-----'),
                (7, '67.89.123.45', '/home/developer/Projects/CyberWarriors2003/builds/source_code_F1.zip', 'source_code_F1.zip', 0, '[ZIP CONTENT - BUILD F1]\n\nCyber Warriors 2003 - Build F1\nDate: March 10, 2003\n\nFirst finalization attempt.\nMajor improvements over alpha.\n\nKnown issues:\n- Minor audio desync\n- Multiplayer stability needs work\n\nNOTE: F6 is the improved final version.', 24, 'rw-r-----'),
                (7, '67.89.123.45', '/home/developer/Projects/CyberWarriors2003/builds/source_code_F6_finally.zip', 'source_code_F6_finally.zip', 0, '[ZIP CONTENT - FINAL MASTER BUILD]\n\nCyber Warriors 2003 - FINAL RELEASE CANDIDATE\nBuild: F6_finally\nDate: March 15, 2003\n\n★ THIS IS THE GOLD MASTER ★\n\nComplete source code for final release:\n- Fully optimized game engine (C++)\n- All graphics assets and shaders\n- Complete audio system\n- 50 finished levels\n- Advanced AI algorithms\n- Multiplayer networking code\n- Physics engine\n\nAll bugs fixed. Ready for manufacturing.\n\nThis is HIGHLY valuable intellectual property.\nEstimated market value: $2-3 million\n\nKeep CONFIDENTIAL until official release!', 28, 'rw-r-----'),
                (7, '67.89.123.45', '/home/developer/Projects/CyberWarriors2003/builds/build_notes.txt', 'build_notes.txt', 0, 'Build Notes\n\n548D: Early alpha, many bugs\n1541: Very old, incomplete\nF1: First finalization, still buggy\nF6_finally: ★ FINAL RELEASE ★\n\nAlways use F6_finally for any distribution!\nOlder versions kept for reference only.', 1, 'rw-r--r--'),

                -- Backup folder (old version)
                (7, '67.89.123.45', '/home/developer/.backup/old_builds', 'old_builds', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home/developer/.backup/old_builds/source_code_1541.zip', 'source_code_1541.zip', 0, '[ZIP CONTENT - ARCHIVE BUILD 1541]\n\nCyber Warriors 2003 - Build 1541 (ARCHIVE)\nDate: January 15, 2003\n\nThis is an archived early build.\nKept for historical reference only.\n\nDo NOT use for any purpose.\nSee builds/ folder for current versions.', 18, 'rw-r-----'),
                (7, '67.89.123.45', '/home/developer/.backup/readme.txt', 'readme.txt', 0, 'Backup Archive\n\nOld builds stored here for reference.\nCurrent builds are in Projects/CyberWarriors2003/builds/\n\nLatest: F6_finally (FINAL)', 1, 'rw-r--r--'),

                -- Artist user (decoy)
                (7, '67.89.123.45', '/home/artist/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home/artist/Desktop/textures_final.zip', 'textures_final.zip', 0, '[ZIP CONTENT - Final Textures]\n\nFinal game textures for Cyber Warriors 2003.\nAll assets approved and optimized.', 15, 'rw-r--r--'),

                -- Sound user (decoy)
                (7, '67.89.123.45', '/home/sound/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/home/sound/Desktop/audio_final.zip', 'audio_final.zip', 0, '[ZIP CONTENT - Final Audio]\n\nFinal game audio for Cyber Warriors 2003.\nAll sounds mixed and mastered.', 18, 'rw-r--r--'),

                -- System directories
                (7, '67.89.123.45', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (7, '67.89.123.45', '/var/log/system.log', 'system.log', 0, 'Mar 15 09:30:15 megagames-server systemd[1]: Started Apache HTTP Server.\nMar 15 09:30:16 megagames-server systemd[1]: Started MySQL Database Server.\nMar 15 12:45:22 megagames-server kernel: [UFW BLOCK] IN=eth0 OUT= MAC=00:16:3e:e2:52:42:fe:54:00:9e:c3:c4:08:00 SRC=203.45.67.89 DST=67.89.123.45 LEN=40 TOS=0x00 PREC=0x00 TTL=245 ID=41792 PROTO=TCP SPT=45358 DPT=22 WINDOW=1024 RES=0x00 SYN URGP=0\nMar 15 15:20:33 megagames-server sshd[1456]: Accepted password for developer from 192.168.1.200 port 22', 3, 'rw-r-----'),
                (7, '67.89.123.45', '/var/log/auth.log', 'auth.log', 0, 'Mar 15 09:20:15 megagames-server sshd[1234]: Accepted password for developer from 192.168.1.100 port 22\nMar 15 11:45:30 megagames-server sudo: developer : TTY=pts/0 ; PWD=/home/developer ; USER=root ; COMMAND=/bin/ls /root\nMar 15 15:20:33 megagames-server sshd[1456]: Accepted password for developer from 192.168.1.200 port 22', 2, 'rw-r-----'),

                (7, '67.89.123.45', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\ndeveloper:x:1000:1000:Lead Developer:/home/developer:/bin/bash\nartist:x:1001:1001:Graphics Artist:/home/artist:/bin/bash\nsound:x:1002:1002:Sound Engineer:/home/sound:/bin/bash\nwww-data:x:33:33:www-data:/var/www:/bin/sh', 1, 'rw-r--r--'),
                (7, '67.89.123.45', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n127.0.1.1 megagames-server\n67.89.123.45 megagames.com', 1, 'rw-r--r--')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (8, '45.67.89.123', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),
                (8, '45.67.89.123', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),

                -- System configuration
                (8, '45.67.89.123', '/etc/rc.local', 'rc.local', 0, '#!/bin/bash\n# SecureVault startup script\n# This file runs on system boot\n\n# Start security services\n/usr/bin/security_monitor &\n/usr/bin/vault_protector &\n\n# Custom backdoor entry point can be added here\n# Requires proper access code for modifications\n\nexit 0', 1, 'rwxr-xr-x'),
                (8, '45.67.89.123', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nvaultadmin:x:1000:1000:Vault Administrator:/home/vaultadmin:/bin/bash\nsecurity:x:1001:1001:Security Officer:/home/security:/bin/bash\nbackup:x:1002:1002:Backup User:/home/backup:/bin/bash\ntechnician:x:1003:1003:System Technician:/home/technician:/bin/bash', 1, 'rw-r--r--'),
                (8, '45.67.89.123', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n127.0.1.1 securevault-server\n45.67.89.123 vault.securevault.com', 1, 'rw-r--r--'),

                -- Home directories
                (8, '45.67.89.123', '/home/vaultadmin', 'vaultadmin', 1, NULL, 0, 'drwxr-x---'),
                (8, '45.67.89.123', '/home/security', 'security', 1, NULL, 0, 'drwxr-x---'),
                (8, '45.67.89.123', '/home/backup', 'backup', 1, NULL, 0, 'drwxr-x---'),
                (8, '45.67.89.123', '/home/technician', 'technician', 1, NULL, 0, 'drwxr-x---'),

                -- Vaultadmin directories
                (8, '45.67.89.123', '/home/vaultadmin/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/home/vaultadmin/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/home/vaultadmin/.config', '.config', 1, NULL, 0, 'drwxr-xr-x'),

                -- Desktop files (PASSWORD PART 1: V4ult)
                (8, '45.67.89.123', '/home/vaultadmin/Desktop/vault_inventory.xls', 'vault_inventory.xls', 0, 'SecureVault Inventory - August 2003\n\nVault ID | Contents | Value | Security Level\nV001 | Gold bars | \$2.5M | Maximum\nV002 | Diamonds | \$1.8M | Maximum\nV003 | Documents | \$500K | High\nV004 | Artwork | \$3.2M | Maximum\nV005 | Cash | \$1.2M | High\n\nTotal Value: \$9.2 Million\n\nNote: All vaults are monitored 24/7.\nAccess codes stored in secure locations.', 1, 'rw-r-----'),
                (8, '45.67.89.123', '/home/vaultadmin/Desktop/weekly_report.doc', 'weekly_report.doc', 0, 'Weekly Security Report\nWeek of August 10-15, 2003\n\nIncidents: 0\nSecurity Scans: 5\nSystem Updates: 3\nVault Accesses: 47\n\nAll systems operational.\nNo suspicious activity detected.\n\nNext review: August 22, 2003', 1, 'rw-r--r--'),

                -- Documents folder
                (8, '45.67.89.123', '/home/vaultadmin/Documents/procedures', 'procedures', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/home/vaultadmin/Documents/procedures/emergency_protocols.txt', 'emergency_protocols.txt', 0, 'Emergency Protocols - SecureVault Inc\n\nFire Emergency:\n1. Activate fire suppression\n2. Evacuate personnel\n3. Secure all vaults\n4. Contact fire department\n\nSecurity Breach:\n1. Activate lockdown\n2. Alert security team\n3. Review access logs\n4. Investigate breach point\n\nSystem Failure:\n1. Switch to backup power\n2. Contact IT support\n3. Check vault integrity\n4. Run diagnostics\n\nContact Numbers:\nSecurity: 555-VAULT\nIT Support: 555-TECH\nEmergency: 911', 2, 'rw-r-----'),
                (8, '45.67.89.123', '/home/vaultadmin/Documents/procedures/access_procedures.txt', 'access_procedures.txt', 0, 'Vault Access Procedures\n\n1. Verify identity with biometric scan\n2. Enter access code\n3. Wait for dual authentication\n4. Access granted for 5 minutes\n5. Log all access attempts\n\nAccess Codes:\nVault V001-V005: Encrypted in system\nEmergency Override: Contact security chief\n\nAll procedures must be followed strictly.\nUnauthorized access attempts will be prosecuted.', 1, 'rw-r-----'),

                -- Config folder (PASSWORD PART 2: S3cur)
                (8, '45.67.89.123', '/home/vaultadmin/.config/system.conf', 'system.conf', 0, '# SecureVault System Configuration\n# Last Modified: 2003-08-15\n\n[Database]\nhost=localhost\nport=3306\nuser=vaultdb\npassword=DbSecure2003\n\n[Security]\nencryption=AES256\nauthentication=biometric\naccess_timeout=300\n\n[Backup]\nschedule=daily\nretention=30days\nlocation=/var/backups/vault\n\n[System]\nmodification_code=S3cur\ndebug=false\nlog_level=INFO', 1, 'rw-r-----'),

                -- Security user (PASSWORD PART 3: e)
                (8, '45.67.89.123', '/home/security/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/home/security/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/home/security/Desktop/patrol_schedule.txt', 'patrol_schedule.txt', 0, 'Security Patrol Schedule - August 2003\n\nMonday-Friday:\n08:00-16:00 - Day Shift (Johnson)\n16:00-00:00 - Evening Shift (Martinez)\n00:00-08:00 - Night Shift (Chen)\n\nWeekend:\n12-hour shifts rotating\n\nAll personnel must check in every 2 hours.\nReport any suspicious activity immediately.', 1, 'rw-r--r--'),
                (8, '45.67.89.123', '/home/security/Documents/incident_reports', 'incident_reports', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/home/security/Documents/incident_reports/august_2003.log', 'august_2003.log', 0, 'Security Incident Log - August 2003\n\n[2003-08-01] Minor alarm malfunction - Vault V003\nResolution: Reset alarm system\n\n[2003-08-05] Suspicious vehicle near perimeter\nResolution: License plate recorded, no action needed\n\n[2003-08-12] Failed login attempt on admin panel\nResolution: Investigating source IP\n\nNote: Overall security status remains excellent.\nNo major incidents this month.', 2, 'rw-r-----'),

                -- Backup user
                (8, '45.67.89.123', '/home/backup/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/home/backup/Desktop/backup_log.txt', 'backup_log.txt', 0, 'Backup System Log\n\nDaily backups running successfully:\n- Vault database: OK\n- Security footage: OK\n- System configs: OK\n- Access logs: OK\n\nLast backup: 2003-08-15 02:00:00\nNext backup: 2003-08-16 02:00:00\n\nAll backup systems operational.', 1, 'rw-r--r--'),

                -- Technician user (hint about modification code)
                (8, '45.67.89.123', '/home/technician/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/home/technician/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/home/technician/Desktop/maintenance_notes.txt', 'maintenance_notes.txt', 0, 'System Maintenance Notes\n\nRegular Maintenance:\n- Update security patches monthly\n- Check vault mechanisms weekly\n- Test backup systems daily\n- Review access logs daily\n\nRecent Work:\n- Upgraded biometric scanners\n- Replaced faulty camera in sector C\n- Updated system firmware\n\nNext Tasks:\n- Schedule annual security audit\n- Replace aging UPS batteries', 1, 'rw-r--r--'),
                (8, '45.67.89.123', '/home/technician/Documents/system_manual.txt', 'system_manual.txt', 0, 'SecureVault System Manual - Technical Reference\n\nSystem Architecture:\n- Vault Control System v3.2\n- Biometric Access Control\n- 24/7 Surveillance System\n- Automated Backup System\n\nModifying System Files:\nCertain system files like /etc/rc.local require special modification codes.\nThese codes are distributed across different system configurations for security.\n\nFor rc.local modifications:\n1. Locate all code segments\n2. Combine them in correct order\n3. Use: modify <filename> <complete_code>\n\nAccess codes are case-sensitive and must be exact.', 2, 'rw-r-----'),

                -- Optical security system (hidden hint)
                (8, '45.67.89.123', '/opt/security', 'security', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/opt/security/camera_system', 'camera_system', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/opt/security/camera_system/camera_config.ini', 'camera_config.ini', 0, '[Camera System Configuration]\n\nTotal Cameras: 24\nRecording: 24/7\nStorage: 30 days\nResolution: 1080p\n\n[Vault Cameras]\nV001: Camera 1,2,3\nV002: Camera 4,5,6  \nV003: Camera 7,8,9\nV004: Camera 10,11,12 (encoding: 3)\nV005: Camera 13,14,15\n\n[Access Verification]\nAll camera feeds reviewed daily\nAnomalies logged automatically', 1, 'rw-r-----'),
                (8, '45.67.89.123', '/opt/security/access_codes.enc', 'access_codes.enc', 0, '[ENCRYPTED FILE]\n\nThis file contains encrypted vault access codes.\nRequires master key for decryption.\n\nAccess code segments stored separately:\nSegment 1: User configuration\nSegment 2: System configuration  \nSegment 3: Camera system encoding\n\nCombine all segments for complete code: V4ult+S3cur+3\nFormat: <seg1><seg2><seg3>', 1, 'rw-------'),

                -- Log files
                (8, '45.67.89.123', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/var/log/security.log', 'security.log', 0, 'Aug 15 08:30:15 securevault-server security_monitor: System startup complete\nAug 15 09:15:22 securevault-server vault_protector: All vaults secured\nAug 15 10:45:30 securevault-server security_monitor: Unauthorized access attempt blocked\nAug 15 11:20:15 securevault-server vault_protector: Vault V001 accessed by vaultadmin (code: V4ult verified)\nAug 15 14:30:45 securevault-server security_monitor: System scan completed - no threats found\nAug 15 16:20:10 securevault-server vault_protector: Configuration check passed', 3, 'rw-r-----'),
                (8, '45.67.89.123', '/var/log/system.log', 'system.log', 0, 'Aug 15 08:30:10 securevault-server systemd[1]: Started Apache HTTP Server.\nAug 15 08:30:11 securevault-server systemd[1]: Started MySQL Database Server.\nAug 15 08:30:12 securevault-server systemd[1]: Started security_monitor.service\nAug 15 08:30:13 securevault-server systemd[1]: Started vault_protector.service\nAug 15 12:45:22 securevault-server kernel: [UFW BLOCK] IN=eth0 OUT= MAC=00:16:3e:e2:52:42:fe:54:00:9e:c3:c4:08:00 SRC=67.89.123.45 DST=45.67.89.123 LEN=40 TOS=0x00 PREC=0x00 TTL=245 ID=41792 PROTO=TCP SPT=45358 DPT=22 WINDOW=1024 RES=0x00 SYN URGP=0', 3, 'rw-r-----'),
                (8, '45.67.89.123', '/var/log/auth.log', 'auth.log', 0, 'Aug 15 09:20:15 securevault-server sshd[1234]: Accepted password for vaultadmin from 192.168.1.100 port 22\nAug 15 11:45:30 securevault-server sudo: vaultadmin : TTY=pts/0 ; PWD=/home/vaultadmin ; USER=root ; COMMAND=/bin/ls /root\nAug 15 15:20:33 securevault-server sshd[1456]: Accepted password for technician from 192.168.1.200 port 22', 2, 'rw-r-----'),

                -- Backup directory
                (8, '45.67.89.123', '/var/backups', 'backups', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/var/backups/vault', 'vault', 1, NULL, 0, 'drwxr-xr-x'),
                (8, '45.67.89.123', '/var/backups/vault/daily_backup.tar.gz', 'daily_backup.tar.gz', 0, '[COMPRESSED BACKUP FILE]\n\nDaily vault database backup\nDate: 2003-08-15\nSize: 2.3 GB\n\nContains encrypted vault records and access logs.', 8, 'rw-r-----')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (9, '123.45.67.89', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),

                -- Home directories
                (9, '123.45.67.89', '/home/archivist', 'archivist', 1, NULL, 0, 'drwxr-x---'),
                (9, '123.45.67.89', '/home/security', 'security', 1, NULL, 0, 'drwxr-x---'),
                (9, '123.45.67.89', '/home/backup', 'backup', 1, NULL, 0, 'drwxr-x---'),
                (9, '123.45.67.89', '/home/admin', 'admin', 1, NULL, 0, 'drwxr-x---'),

                -- Archivist directories
                (9, '123.45.67.89', '/home/archivist/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/home/archivist/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/home/archivist/classified', 'classified', 1, NULL, 0, 'drwxr-x---'),
                (9, '123.45.67.89', '/home/archivist/archives', 'archives', 1, NULL, 0, 'drwxr-xr-x'),

                -- Classified folder with encrypted file
                (9, '123.45.67.89', '/home/archivist/classified/classified.pgp', 'classified.pgp', 0, '-----BEGIN PGP MESSAGE-----\nVersion: GnuPG v2.0.22\n\nhQEMA5rBhdmVDZTQAQf9GmRw3K8FHxBVx0r5qJV8K3P2mNxY9Lw4Qe6TsO1pRvZu\nXkL7Hn2Mw9QcD4Vf8Ry6Tp3Nx5Ks2Jm7Lq4Pv1Zr8Wu6Xk5Ov2Mn7Jq8Kr5Lp9Qu3\nNx4Ms6Hp7Jr9Lq1Tp8Kv2Zr5Xu0Qw9Mn4Op6Jq8Lp7Kr2Vx3Oy5Nq7Mp9Jr1Kv4\nZu6Pw8Oq5Lr3Np2Jx9Kq7Mu1Tp4Ov8Xw5Qr6Np3Jy2Lp9Ku7Ox1Zv4Nr8Mq6Jp5\nLr2Tp3Kx9Ow1Qu5Np7Jr8Lp2Mv6Zx4Oq1Nr9Kp3Ju8Lw5Tp7Ox2Qv6Mr4Np1Jy9\nKq8Lp3Ou7Zx1Nr5Mv2Qp9Jr6Ku4Tp8Lw1Ox3Qy5Nr7Jp2Lq9Mu6Kx4Ow8Zv1Np3\nJr5Lu2Qp7Tp9Kw4Ox6Mv1Nr8Jq3Lp5Ku9Zy2Qx7Ow1Nr4Jp6Lu8Tp3Kv5Mq9Ox2\nZy1Nr7Jq4Lp2Ku6Tp8Lw9Ov3Qx5Mr1Np9Ju7Kp4Lq2Tp6Ow8Zx3Ov1Nr5Jy9Lp7\n=Q8Hn\n-----END PGP MESSAGE-----\n\n[ENCRYPTED CONTENT - Use decrypt command to view]\nFile: classified.pgp\nEncryption: PGP/GPG (4096-bit RSA)\nPassword required for decryption', 12, 'rw-------'),
                (9, '123.45.67.89', '/home/archivist/classified/access_log.txt', 'access_log.txt', 0, 'Government Archives Access Log\n\nDate: 2004-05-15\nTime: 14:30:00\nUser: archivist\nAction: Accessed classified.pgp\nClearance: Level 5\nPurpose: Routine archival review\n\nDate: 2004-05-18\nTime: 09:15:00\nUser: archivist\nAction: Decrypted classified.pgp\nClearance: Level 5\nPurpose: Extract intelligence report\n\nNote: All access attempts are logged and monitored.\nUnauthorized decryption attempts will trigger security alerts.', 2, 'rw-r-----'),
                (9, '123.45.67.89', '/home/archivist/classified/security_clearance.txt', 'security_clearance.txt', 0, 'SECURITY CLEARANCE CERTIFICATE\n\nName: Dr. Robert Morrison\nPosition: Senior Government Archivist\nClearance Level: TOP SECRET (Level 5)\nIssued: January 15, 2001\nExpires: January 15, 2006\nAgency: National Archives Administration\n\nAuthorized Access:\n- Military operational documents\n- Intelligence reports (CIA, NSA, FBI)\n- Diplomatic cables\n- Nuclear facility information\n- Classified research projects\n\nSecurity Notice:\nThis clearance must be renewed annually.\nAll document access is monitored and logged.\nReporting suspicious activity is mandatory.', 3, 'rw-r-----'),

                -- Desktop files
                (9, '123.45.67.89', '/home/archivist/Desktop/archivist_notes.txt', 'archivist_notes.txt', 0, 'Archivist Notes - May 2004\n\nRecent Activities:\n- Digitized 500+ classified documents\n- Updated security protocols\n- Reviewed access permissions\n- Prepared 20 documents for declassification review\n\nOngoing Projects:\n1. Cold War Intelligence Archives\n2. Vietnam War Operational Reports\n3. Nuclear Weapons Development History\n4. CIA Covert Operations 1960-1990\n\nDecryption Keys Location:\n- Primary keys stored in secure keyring\n- Backup keys in /opt/security/keys\n- Emergency access protocol in security manual\n\nPassword for encrypted archives: Archive2004\n\nReminder: Monthly security audit scheduled for May 25\n\nNote: Dr. Morrison has requested access to Cuban Missile Crisis files.', 3, 'rw-r-----'),
                (9, '123.45.67.89', '/home/archivist/Desktop/clearance_levels.txt', 'clearance_levels.txt', 0, 'Government Security Clearance Levels\n\nLevel 1: PUBLIC\n- Publicly available information\n- Press releases and public statements\n\nLevel 2: INTERNAL USE ONLY\n- Internal memos and communications\n- Administrative documents\n\nLevel 3: CONFIDENTIAL\n- Sensitive but unclassified information\n- Personnel records\n- Budget information\n\nLevel 4: SECRET\n- National security information\n- Military operations\n- Intelligence reports\n\nLevel 5: TOP SECRET\n- Highest classification level\n- Critical national security information\n- Special compartmented information (SCI)\n- Nuclear weapons data\n\nCurrent User: archivist (Dr. Robert Morrison)\nClearance Level: 5 (TOP SECRET)\n\nAccess Rights:\n- Full access to all classified archives\n- Decryption authority for Level 1-5 documents\n- Authorization to handle SCI materials\n\nAnnual Review Date: January 15, 2005', 4, 'rw-r--r--'),
                (9, '123.45.67.89', '/home/archivist/Desktop/pending_requests.txt', 'pending_requests.txt', 0, 'Document Access Requests - Pending Review\n\nRequest #2401: Dr. Sarah Chen\nDocument: Vietnam War Intelligence Reports\nPurpose: Academic research\nStatus: Under review\nDue: May 20, 2004\n\nRequest #2402: Professor James Wilson\nDocument: CIA Cold War Operations\nPurpose: Historical book project\nStatus: Approved with redactions\nDue: May 22, 2004\n\nRequest #2403: Senator Office Staff\nDocument: Nuclear Facility Locations\nPurpose: Legislative oversight\nStatus: Pending security review\nDue: May 25, 2004\n\nRequest #2404: Military Historian\nDocument: Gulf War Battle Plans\nPurpose: Military academy curriculum\nStatus: Approved\nDue: May 18, 2004', 3, 'rw-r-----'),

                -- Documents folder
                (9, '123.45.67.89', '/home/archivist/Documents/protocols', 'protocols', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/home/archivist/Documents/protocols/decryption_protocol.txt', 'decryption_protocol.txt', 0, 'Document Decryption Protocol\nVersion 3.2 - Updated May 2004\n\nStandard Decryption Procedure:\n1. Verify user clearance level\n2. Confirm document classification\n3. Log decryption request\n4. Use authorized decryption keys\n5. Store decrypted files in secure location\n6. Report any anomalies\n\nDecryption Commands:\n- Standard PGP files: decrypt [filename]\n- Encrypted archives: decrypt [filename] [password]\n- Multi-layer encryption: Contact security team\n\nAuthorized Personnel:\n- Senior Archivist (Level 5)\n- Chief Security Officer (Level 5)\n- Director of Archives (Level 5)\n\nEmergency Decryption:\nContact: Security Hotline 555-CLASSIFIED\n\nNote: All decryption activities are monitored and logged.\nUnauthorized decryption attempts will trigger immediate security response.', 4, 'rw-r-----'),
                (9, '123.45.67.89', '/home/archivist/Documents/protocols/security_guidelines.txt', 'security_guidelines.txt', 0, 'Archives Security Guidelines\n\nPhysical Security:\n- All classified documents stored in secure vaults\n- 24/7 armed security presence\n- Biometric access controls\n- Surveillance cameras in all areas\n\nDigital Security:\n- All files encrypted at rest\n- Regular security audits\n- Intrusion detection systems\n- Secure network isolated from internet\n\nPersonnel Security:\n- Background checks every 5 years\n- Security awareness training quarterly\n- Report suspicious behavior immediately\n- No personal devices in classified areas\n\nDocument Handling:\n- Clean desk policy enforced\n- Documents logged in/out\n- No unauthorized copies\n- Secure destruction procedures\n\nPassword Policy:\n- Minimum 12 characters\n- Changed every 60 days\n- No password reuse\n- Multi-factor authentication required', 3, 'rw-r-----'),

                -- Archives folder
                (9, '123.45.67.89', '/home/archivist/archives/catalog.txt', 'catalog.txt', 0, 'Government Archives Catalog - 2004\n\nTotal Documents: 125,847\nClassified Documents: 8,392\nTop Secret Documents: 1,247\n\nMajor Collections:\n- World War II Intelligence: 15,340 documents\n- Cold War Operations: 22,156 documents\n- Vietnam War: 8,745 documents\n- Gulf War: 3,892 documents\n- Nuclear Programs: 1,654 documents\n- CIA Operations: 5,234 documents\n- NSA Surveillance: 2,876 documents\n- Diplomatic Cables: 18,432 documents\n\nRecent Additions (May 2004):\n- 45 newly declassified CIA documents\n- 23 diplomatic cables from 1970s\n- 12 military operational reports\n\nPending Declassification:\n- 234 documents scheduled for 2004\n- 567 documents under review\n- 89 documents awaiting final approval', 5, 'rw-r--r--'),
                (9, '123.45.67.89', '/home/archivist/archives/digitization_log.txt', 'digitization_log.txt', 0, 'Archives Digitization Project Log\nProject Start: January 2003\n\nProgress Report - May 2004:\n\nCompleted:\n- Phase 1: Public documents (100%)\n- Phase 2: Confidential documents (85%)\n- Phase 3: Secret documents (60%)\n- Phase 4: Top Secret documents (35%)\n\nCurrent Focus:\n- Cold War intelligence reports\n- Cuban Missile Crisis documents\n- Vietnam War operational files\n\nDigitization Statistics:\n- Total pages scanned: 2,456,789\n- Files created: 125,847\n- Storage used: 8.5 TB\n- Encrypted files: 8,392\n\nQuality Control:\n- OCR accuracy: 98.7%\n- Image quality: High resolution\n- Metadata completion: 95%\n\nNext Phase:\n- Remaining Top Secret documents\n- Special compartmented information\n- Nuclear weapons research files\n\nTarget Completion: December 2005', 4, 'rw-r-----'),

                -- Security user
                (9, '123.45.67.89', '/home/security/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/home/security/Desktop/incident_reports.txt', 'incident_reports.txt', 0, 'Security Incident Reports - May 2004\n\n[2004-05-10] Minor alarm malfunction - Sector B\nResolution: Alarm system reset, no breach detected\n\n[2004-05-12] Failed login attempt on archives server\nIP: 67.89.123.45\nUser: unknown\nAttempts: 3\nResolution: IP blocked, incident reported to FBI\n\n[2004-05-15] Unauthorized access attempt to classified folder\nUser: intern_jackson\nResolution: Access denied, user clearance insufficient\nAction: Security briefing scheduled\n\n[2004-05-18] Suspicious network activity detected\nSource: External\nResolution: Intrusion detection system blocked, logs preserved\n\nOverall Security Status: NORMAL\nThreat Level: LOW', 3, 'rw-r-----'),

                -- Admin user
                (9, '123.45.67.89', '/home/admin/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/home/admin/Desktop/system_status.txt', 'system_status.txt', 0, 'Government Archives System Status\nDate: May 20, 2004\n\nServer Status: OPERATIONAL\nUptime: 45 days, 8 hours\nCPU Usage: 23%\nMemory Usage: 45%\nDisk Usage: 67%\n\nBackup Status: CURRENT\nLast Backup: May 20, 2004 02:00 AM\nBackup Size: 8.7 TB\nBackup Location: Secure offsite facility\n\nSecurity Status: SECURE\nFirewall: Active\nIntrusion Detection: Active\nEncryption: Enabled\nAccess Controls: Enforced\n\nNetwork Status: STABLE\nBandwidth Usage: Normal\nLatency: <5ms\nPacket Loss: 0%\n\nScheduled Maintenance:\n- Database optimization: May 25\n- Security audit: May 28\n- Hardware inspection: June 1', 2, 'rw-r-----'),

                -- System directories
                (9, '123.45.67.89', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\narchivist:x:1000:1000:Government Archivist:/home/archivist:/bin/bash\nsecurity:x:1001:1001:Security Officer:/home/security:/bin/bash\nbackup:x:1002:1002:Backup User:/home/backup:/bin/bash\nadmin:x:1003:1003:System Administrator:/home/admin:/bin/bash', 1, 'rw-r--r--'),
                (9, '123.45.67.89', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n127.0.1.1 gov-archives-server\n123.45.67.89 archives.gov.internal\n192.168.10.5 security.gov.internal\n192.168.10.10 backup.gov.internal', 1, 'rw-r--r--'),

                -- Log files
                (9, '123.45.67.89', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/var/log/auth.log', 'auth.log', 0, 'May 15 09:15:22 gov-archives sshd[1234]: Accepted password for archivist from 192.168.1.100 port 22\nMay 15 10:30:45 gov-archives sudo: archivist : TTY=pts/0 ; PWD=/home/archivist ; USER=root ; COMMAND=/usr/bin/decrypt classified.pgp\nMay 15 14:30:15 gov-archives sshd[1356]: Accepted password for security from 192.168.1.200 port 22\nMay 16 08:20:10 gov-archives sshd[1456]: Failed password for archivist from 123.45.67.50 port 22\nMay 18 11:45:30 gov-archives sudo: archivist : TTY=pts/0 ; PWD=/home/archivist/classified ; USER=root ; COMMAND=/bin/cat classified.pgp\nMay 20 09:30:00 gov-archives sshd[1567]: Accepted password for admin from 192.168.1.150 port 22', 3, 'rw-r-----'),
                (9, '123.45.67.89', '/var/log/security.log', 'security.log', 0, 'May 15 09:30:15 gov-archives security_monitor: System startup complete\nMay 15 09:35:22 gov-archives access_control: User archivist accessed classified folder\nMay 15 10:30:50 gov-archives decryption_monitor: File classified.pgp decrypted by archivist\nMay 16 08:20:15 gov-archives security_monitor: Failed login attempt from 123.45.67.50\nMay 18 11:45:35 gov-archives access_control: User archivist read classified.pgp\nMay 20 14:30:45 gov-archives security_monitor: System scan completed - no threats detected', 3, 'rw-r-----'),
                (9, '123.45.67.89', '/var/log/system.log', 'system.log', 0, 'May 15 09:15:10 gov-archives systemd[1]: Started Apache HTTP Server.\nMay 15 09:15:11 gov-archives systemd[1]: Started PostgreSQL Database Server.\nMay 15 09:15:12 gov-archives systemd[1]: Started security_monitor.service\nMay 15 09:15:13 gov-archives systemd[1]: Started encryption_service.service\nMay 18 12:45:22 gov-archives kernel: [UFW BLOCK] IN=eth0 OUT= MAC=00:16:3e:e2:52:42:fe:54:00:9e:c3:c4:08:00 SRC=67.89.123.45 DST=123.45.67.89 LEN=40 TOS=0x00 PREC=0x00 TTL=245 ID=41792 PROTO=TCP SPT=45358 DPT=22 WINDOW=1024 RES=0x00 SYN URGP=0', 3, 'rw-r-----'),

                -- Opt directory with security tools
                (9, '123.45.67.89', '/opt/security', 'security', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/opt/security/keys', 'keys', 1, NULL, 0, 'drwx------'),
                (9, '123.45.67.89', '/opt/security/keys/README.txt', 'README.txt', 0, 'Encryption Keys Directory\n\nThis directory contains backup encryption keys for classified documents.\n\nKey Files:\n- master.key: Master encryption key (4096-bit RSA)\n- archive.key: Archive encryption key (2048-bit RSA)\n- backup.key: Backup encryption key (2048-bit RSA)\n\nAccess Policy:\n- Only Level 5 clearance personnel\n- All access logged and monitored\n- Keys rotated annually\n\nEmergency Access:\nContact Chief Security Officer\nPhone: 555-CLASSIFIED\n\nWARNING: Unauthorized access to encryption keys is a federal crime.', 3, 'rw-------'),

                -- Backup directory
                (9, '123.45.67.89', '/var/backups', 'backups', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/var/backups/archives', 'archives', 1, NULL, 0, 'drwxr-xr-x'),
                (9, '123.45.67.89', '/var/backups/archives/daily_backup.tar.gz', 'daily_backup.tar.gz', 0, '[COMPRESSED BACKUP FILE]\n\nDaily government archives backup\nDate: 2004-05-20\nSize: 8.7 TB\n\nContains:\n- All digitized documents\n- Database records\n- System configurations\n- Encryption keys (encrypted)\n- Access logs\n\nRetention: 90 days\nEncryption: AES-256\nStorage: Secure offsite facility', 10, 'rw-r-----')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (10, '89.123.45.67', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),

                -- System configuration
                (10, '89.123.45.67', '/etc/routing.conf', 'routing.conf', 0, '# ISP DataCenter Routing Configuration\n# Last Modified: 2004-11-15\n# Protected by VPN Security Tool\n\n# Main routing table\nroute add default gw 192.168.1.1\nroute add 10.0.0.0/8 gw 10.0.0.1\nroute add 172.16.0.0/12 gw 172.16.0.1\nroute add 192.168.0.0/16 gw 192.168.1.1\n\n# Customer networks\nroute add 203.0.113.0/24 gw 89.123.45.2\nroute add 198.51.100.0/24 gw 89.123.45.3\n\n# BGP peering routes\nroute add 8.8.8.0/24 gw 89.123.45.10\nroute add 1.1.1.0/24 gw 89.123.45.11\n\n# Traffic monitoring gateway\n# route add 0.0.0.0/0 gw 89.123.45.100\n\n# WARNING: Modifications to this file require admin password\n# Protected by VPN Security Tool - disable before editing', 3, 'rw-r-----'),
                (10, '89.123.45.67', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nispadmin:x:1000:1000:ISP Administrator:/home/ispadmin:/bin/bash\nnetwork:x:1001:1001:Network Engineer:/home/network:/bin/bash\nmonitor:x:1002:1002:Monitoring User:/home/monitor:/bin/bash\nsecurity:x:1003:1003:Security Officer:/home/security:/bin/bash', 1, 'rw-r--r--'),
                (10, '89.123.45.67', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n127.0.1.1 isp-datacenter\n89.123.45.67 router.isp.net\n89.123.45.100 monitor.isp.net\n192.168.1.1 gateway.isp.net', 1, 'rw-r--r--'),

                -- Home directories
                (10, '89.123.45.67', '/home/ispadmin', 'ispadmin', 1, NULL, 0, 'drwxr-x---'),
                (10, '89.123.45.67', '/home/network', 'network', 1, NULL, 0, 'drwxr-x---'),
                (10, '89.123.45.67', '/home/monitor', 'monitor', 1, NULL, 0, 'drwxr-x---'),
                (10, '89.123.45.67', '/home/security', 'security', 1, NULL, 0, 'drwxr-x---'),

                -- ISP Admin directories
                (10, '89.123.45.67', '/home/ispadmin/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/home/ispadmin/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/home/ispadmin/configs', 'configs', 1, NULL, 0, 'drwxr-xr-x'),

                -- Desktop files (PASSWORD PART 1: R0ut)
                (10, '89.123.45.67', '/home/ispadmin/Desktop/network_config.txt', 'network_config.txt', 0, 'ISP DataCenter Network Configuration - November 2004\n\nNetwork Infrastructure:\n- Primary router: 89.123.45.1 (Cisco 7200 Series)\n- Backup router: 89.123.45.2 (Cisco 7200 Series) \n- Core switch: 89.123.45.5 (Catalyst 6500)\n- Monitoring server: 89.123.45.100\n- Customer gateway: 192.168.1.1\n\nBandwidth:\n- Total capacity: 10 Gbps\n- Peak usage: 7.2 Gbps\n- Average usage: 4.5 Gbps\n\nCustomer Base:\n- Residential: 45,000 customers\n- Business: 5,000 customers\n- Total bandwidth sold: 12 Gbps (oversubscribed 1.2:1)\n\nRouter Access Credentials:\nUsername: ispadmin\nPassword Prefix: R0ut (combine with other segments)\n\nRecent Network Changes:\n- Upgraded backbone to 10G\n- Installed new traffic monitoring system\n- Added packet inspection capabilities\n- Modified routing tables for analysis\n\nMaintenance Schedule:\n- Weekly: Configuration backup\n- Monthly: Security patches\n- Quarterly: Hardware inspection', 4, 'rw-r-----'),
                (10, '89.123.45.67', '/home/ispadmin/Desktop/traffic_stats.txt', 'traffic_stats.txt', 0, 'ISP Traffic Statistics - November 2004\n\nDaily Traffic Volume:\n- Inbound: 1.2 TB\n- Outbound: 3.8 TB\n- Total: 5.0 TB per day\n\nTop Protocols:\n1. HTTP: 45%\n2. HTTPS: 25%\n3. P2P: 15%\n4. Streaming: 10%\n5. Other: 5%\n\nPeak Hours:\n- Morning: 8-10 AM (3.5 Gbps)\n- Evening: 6-11 PM (7.2 Gbps peak)\n- Night: 11 PM-6 AM (2.1 Gbps)\n\nCustomer Complaints:\n- Slow speeds: 12 tickets\n- Connection drops: 8 tickets\n- Routing issues: 3 tickets\n- No service: 2 tickets\n\nNote: All traffic currently monitored for security purposes.\nMonitoring system captures metadata for analysis.', 3, 'rw-r-----'),
                (10, '89.123.45.67', '/home/ispadmin/Desktop/security_alert.txt', 'security_alert.txt', 0, 'SECURITY ALERT - VPN Security Tool Active\n\nDate: November 15, 2004\nAlert Level: HIGH\n\nProtection Status:\n- VPN Security Tool: ACTIVE\n- File Protection: ENABLED\n- Routing Config: LOCKED\n\nProtected Files:\n- /etc/routing.conf (Critical)\n- /etc/network/interfaces\n- /etc/iptables.rules\n\nModification Requirements:\n1. Disable VPN Security Tool first\n2. Provide admin password\n3. Log all changes\n\nTo disable protection:\nrm /opt/security/VPNSecurityTool.exe\n\nWARNING: Disabling security tool will trigger alerts.\nAll activities are logged and monitored.', 2, 'rw-r-----'),

                -- Documents folder (PASSWORD PART 2: 3rAcc)
                (10, '89.123.45.67', '/home/ispadmin/Documents/admin_manual.txt', 'admin_manual.txt', 0, 'ISP Administrator Manual\nVersion 2.4 - November 2004\n\nRouter Configuration:\n\nAccess Methods:\n1. Console cable (direct)\n2. SSH (remote access)\n3. Web interface (https://router.isp.net)\n\nAuthentication:\n- Primary method: Password authentication\n- Secondary: SSH key (optional)\n- Emergency: Recovery mode\n\nRouter Password Format:\n- Prefix: R0ut\n- Middle segment: 3rAcc (access level indicator)\n- Suffix: 3ss (system security suffix)\n- Complete format: [prefix][middle][suffix]\n\nConfiguration Files:\n- /etc/routing.conf: Main routing table\n- /etc/network/interfaces: Interface config\n- /etc/bgp.conf: BGP peering\n\nCommon Tasks:\n1. Route modification:\n   - Edit /etc/routing.conf\n   - Apply: route reload\n   - Verify: route -n\n\n2. Traffic analysis:\n   - Monitor: tcpdump -i eth0\n   - Stats: iftop\n   - Logs: /var/log/network.log\n\n3. Customer management:\n   - Add: useradd [customer]\n   - Bandwidth: tc qdisc add\n   - Monitor: iptraf\n\nSecurity Protocols:\n- Change passwords quarterly\n- Review logs daily\n- Update firmware monthly\n- Backup configs weekly', 5, 'rw-r-----'),

                -- Configs folder (PASSWORD PART 3: 3ss)
                (10, '89.123.45.67', '/home/ispadmin/configs/backup_config.txt', 'backup_config.txt', 0, 'Configuration Backup System\nLast Updated: November 2004\n\nBackup Schedule:\n- Daily: Incremental backup at 2:00 AM\n- Weekly: Full backup on Sundays\n- Monthly: Archive to tape storage\n\nBackup Locations:\n- Primary: /var/backups/configs\n- Secondary: 89.123.45.200:/backups\n- Offsite: Tape archive facility\n\nCritical Files Backed Up:\n- /etc/routing.conf\n- /etc/network/interfaces  \n- /etc/iptables.rules\n- /opt/security/* (security tools)\n\nRestore Procedures:\n1. Stop network services\n2. Restore configuration files\n3. Verify integrity\n4. Restart services\n5. Test connectivity\n\nPassword Security:\nSystem access code suffix: 3ss\nCombine with router prefix and middle segment.\n\nEmergency Contacts:\n- Network Operations: 555-NET-OPS\n- Security Team: 555-SEC-TEAM\n- Management: 555-ISP-MGMT', 3, 'rw-r-----'),

                -- Network engineer
                (10, '89.123.45.67', '/home/network/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/home/network/Desktop/routing_notes.txt', 'routing_notes.txt', 0, 'Network Engineering Notes - November 2004\n\nCurrent Routing Setup:\n- BGP: Configured with 3 upstream peers\n- OSPF: Internal routing protocol\n- Static routes: For customer networks\n\nRecent Changes:\n- Added monitoring gateway route\n- Updated BGP filters\n- Optimized routing tables\n- Implemented traffic shaping\n\nPending Tasks:\n- Review routing.conf for optimization\n- Test failover scenarios\n- Document network topology\n- Upgrade router firmware\n\nNOTE: routing.conf is protected by VPN Security Tool.\nContact security team before modifications.', 2, 'rw-r-----'),

                -- Monitor user
                (10, '89.123.45.67', '/home/monitor/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/home/monitor/Desktop/monitoring_report.txt', 'monitoring_report.txt', 0, 'Traffic Monitoring Report\nWeek of November 8-14, 2004\n\nMonitoring Coverage:\n- Customer traffic: 100%\n- Internal traffic: 100%\n- External peering: 100%\n\nAnomalies Detected:\n- Port scan attempts: 47\n- DDoS attack (mitigated): 2\n- Suspicious traffic patterns: 15\n- Malware signatures: 23\n\nTop Bandwidth Users:\n1. Customer #4523: 850 GB\n2. Customer #1892: 720 GB\n3. Customer #8734: 680 GB\n4. Customer #2341: 590 GB\n5. Customer #6789: 540 GB\n\nSystem Performance:\n- Packet capture rate: 99.8%\n- Analysis accuracy: 98.5%\n- False positives: 2.1%\n\nRecommendations:\n- Increase monitoring server capacity\n- Update signature database\n- Enhance traffic analysis algorithms', 3, 'rw-r-----'),

                -- Security user
                (10, '89.123.45.67', '/home/security/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/home/security/Desktop/security_protocols.txt', 'security_protocols.txt', 0, 'ISP Security Protocols\nVersion 1.8 - November 2004\n\nFile Protection System:\n- VPN Security Tool protects critical config files\n- Real-time integrity monitoring\n- Automatic alert generation\n- Change logging enabled\n\nProtected Files:\n1. /etc/routing.conf (CRITICAL)\n   - Requires admin password: R0ut3rAcc3ss\n   - Must disable VPNSecurityTool.exe first\n   - All changes logged to security.log\n\n2. /etc/iptables.rules\n   - Firewall configuration\n   - Protected by default\n\n3. /etc/network/interfaces\n   - Network interface config\n   - Backup before changes\n\nDisabling Protection:\nTo modify protected files:\n1. rm /opt/security/VPNSecurityTool.exe\n2. Provide admin password when prompted\n3. Make necessary changes\n4. Reinstall protection: /opt/security/install_vpn.sh\n\nSecurity Incidents:\n- Unauthorized access attempts: Logged\n- File modification attempts: Blocked & logged\n- Password failures: Account lockout after 3 attempts\n\nIncident Response:\n1. Detect & log incident\n2. Alert security team\n3. Investigate source\n4. Take corrective action\n5. Document & report', 4, 'rw-r-----'),

                -- Opt directory with security tools
                (10, '89.123.45.67', '/opt/security', 'security', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/opt/security/VPNSecurityTool.exe', 'VPNSecurityTool.exe', 0, '[SECURITY TOOL - ACTIVE]\n\nVPN Security Tool v3.2\nCopyright (c) 2004 SecureNet Solutions\n\nStatus: RUNNING\nProtection Level: MAXIMUM\n\nProtected Files:\n- /etc/routing.conf\n- /etc/network/interfaces\n- /etc/iptables.rules\n\nFeatures:\n- Real-time file integrity monitoring\n- Automatic threat detection\n- Configuration change blocking\n- Comprehensive audit logging\n\nThis tool prevents unauthorized modifications to critical system files.\nTo disable: rm /opt/security/VPNSecurityTool.exe\n\nWARNING: Removing this tool will be logged and may trigger security alerts.', 5, 'rwxr-xr-x'),
                (10, '89.123.45.67', '/opt/security/install_vpn.sh', 'install_vpn.sh', 0, '#!/bin/bash\n# VPN Security Tool Installation Script\n\necho \"Installing VPN Security Tool...\"\ncp VPNSecurityTool.exe /opt/security/\nchmod 755 /opt/security/VPNSecurityTool.exe\n\necho \"Configuring protection...\"\necho \"/etc/routing.conf\" >> /opt/security/protected_files.list\necho \"/etc/network/interfaces\" >> /opt/security/protected_files.list\n\necho \"Starting security monitoring...\"\n/opt/security/VPNSecurityTool.exe &\n\necho \"Installation complete!\"', 1, 'rwxr-xr-x'),
                (10, '89.123.45.67', '/opt/security/protected_files.list', 'protected_files.list', 0, '/etc/routing.conf\n/etc/network/interfaces\n/etc/iptables.rules', 1, 'rw-r--r--'),

                -- Log files
                (10, '89.123.45.67', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/var/log/system.log', 'system.log', 0, 'Nov 15 08:30:10 isp-datacenter systemd[1]: Started Apache HTTP Server.\nNov 15 08:30:11 isp-datacenter systemd[1]: Started MySQL Database Server.\nNov 15 08:30:12 isp-datacenter systemd[1]: Started network_monitor.service\nNov 15 08:30:13 isp-datacenter systemd[1]: Started traffic_analyzer.service\nNov 15 08:30:14 isp-datacenter systemd[1]: Started VPNSecurityTool.service\nNov 15 12:45:22 isp-datacenter kernel: [UFW BLOCK] IN=eth0 OUT= MAC=00:16:3e:e2:52:42:fe:54:00:9e:c3:c4:08:00 SRC=123.45.67.89 DST=89.123.45.67 LEN=40 TOS=0x00 PREC=0x00 TTL=245 ID=41792 PROTO=TCP SPT=45358 DPT=22 WINDOW=1024 RES=0x00 SYN URGP=0', 3, 'rw-r-----'),
                (10, '89.123.45.67', '/var/log/network.log', 'network.log', 0, 'Nov 15 09:15:22 isp-datacenter network_monitor: Routing table loaded\nNov 15 09:15:23 isp-datacenter traffic_analyzer: Monitoring system activated\nNov 15 10:30:45 isp-datacenter network_monitor: BGP peers established\nNov 15 11:20:15 isp-datacenter traffic_analyzer: 1,000,000 packets analyzed\nNov 15 14:30:45 isp-datacenter network_monitor: System performance normal\nNov 15 16:45:30 isp-datacenter network_monitor: Configuration backup completed', 3, 'rw-r-----'),
                (10, '89.123.45.67', '/var/log/security.log', 'security.log', 0, 'Nov 15 08:30:15 isp-datacenter VPNSecurityTool: Protection system started\nNov 15 08:30:16 isp-datacenter VPNSecurityTool: Monitoring /etc/routing.conf\nNov 15 08:30:17 isp-datacenter VPNSecurityTool: Monitoring /etc/network/interfaces\nNov 15 08:30:18 isp-datacenter VPNSecurityTool: All protected files verified\nNov 15 12:30:22 isp-datacenter VPNSecurityTool: File integrity check passed\nNov 15 16:30:45 isp-datacenter VPNSecurityTool: System scan completed - no threats', 3, 'rw-r-----'),

                -- Backup directory
                (10, '89.123.45.67', '/var/backups', 'backups', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/var/backups/configs', 'configs', 1, NULL, 0, 'drwxr-xr-x'),
                (10, '89.123.45.67', '/var/backups/configs/routing.conf.backup', 'routing.conf.backup', 0, '# ISP DataCenter Routing Configuration - BACKUP\n# Date: 2004-11-14\n\nroute add default gw 192.168.1.1\nroute add 10.0.0.0/8 gw 10.0.0.1\nroute add 172.16.0.0/12 gw 172.16.0.1\nroute add 192.168.0.0/16 gw 192.168.1.1', 2, 'rw-r-----')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                -- Server 1: 155.22.88.4 (Main Server)
                (11, '155.22.88.4', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/var/lib', 'lib', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- Home directories Server 1
                (11, '155.22.88.4', '/home/contractor', 'contractor', 1, NULL, 0, 'drwxr-x---'),
                (11, '155.22.88.4', '/home/engineer', 'engineer', 1, NULL, 0, 'drwxr-x---'),
                (11, '155.22.88.4', '/home/security', 'security', 1, NULL, 0, 'drwxr-x---'),
                (11, '155.22.88.4', '/home/admin', 'admin', 1, NULL, 0, 'drwxr-x---'),

                -- Contractor files
                (11, '155.22.88.4', '/home/contractor/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/home/contractor/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/home/contractor/Downloads', 'Downloads', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/home/contractor/Desktop/network_map.txt', 'network_map.txt', 0, 'Military Network Infrastructure\n\nMain Server: 155.22.88.4\n- Role: Central database server\n- Database: /var/lib/weapons_db.sql\n- Users: contractor, engineer, security\n\nInternal Network: 10.20.30.1\n- Role: Defense contracts management\n- Database: Located in /opt directory\n- Users: military, defense\n\nClassified Server: 172.16.5.10\n- Role: Research projects\n- Database: Check user home directories\n- Users: classified, research\n\nNote: All databases must be eliminated.', 2, 'rw-r-----'),
                (11, '155.22.88.4', '/home/contractor/Documents/access_log.txt', 'access_log.txt', 0, 'Access Log - February 2005\n\n2005-02-15 09:30 - Login from 192.168.1.100\n2005-02-15 10:15 - Accessed weapons_db.sql\n2005-02-15 10:45 - Connected to 10.20.30.1\n2005-02-15 11:00 - Connected to 172.16.5.10\n2005-02-15 14:30 - Database backup created', 1, 'rw-r-----'),
                (11, '155.22.88.4', '/home/contractor/Documents/passwords.txt', 'passwords.txt', 0, 'System Passwords - CONFIDENTIAL\n\nMain Server (155.22.88.4):\n- contractor: MilitaryC0ntr4ct\n- root: [ENCRYPTED]\n\nInternal (10.20.30.1):\n- military: D3f3ns3Sys\n\nClassified (172.16.5.10):\n- classified: T0pS3cr3t2005', 1, 'rw-------'),

                -- Engineer files
                (11, '155.22.88.4', '/home/engineer/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/home/engineer/projects', 'projects', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '155.22.88.4', '/home/engineer/Desktop/weapons_list.txt', 'weapons_list.txt', 0, 'Active Weapons Projects\n\n1. F-35X Stealth Fighter\n   Status: Development\n   Budget: $50M\n\n2. MX-100 Guided Missile\n   Status: Testing\n   Budget: $35M\n\n3. EW-500 Electronic Warfare\n   Status: Production\n   Budget: $28M\n\n4. Hypersonic Missile System\n   Status: Research\n   Budget: $120M\n\nTotal Budget: $233 Million\n\nAll data stored in weapons_db.sql', 2, 'rw-r-----'),
                (11, '155.22.88.4', '/home/engineer/projects/stealth_tech.txt', 'stealth_tech.txt', 0, 'Stealth Technology Research\n\nRadar Absorption:\n- New composite materials\n- 99.8% absorption rate\n- Temperature range: -50C to +200C\n\nGeometric Design:\n- Computer-optimized surfaces\n- RCS reduced by 1000x\n- Wind tunnel validated\n\nEngine Suppression:\n- Infrared signature reduced 85%\n- Performance maintained', 2, 'rw-r-----'),

                -- Database location (SERVER 1 TARGET)
                (11, '155.22.88.4', '/var/lib/weapons_db.sql', 'weapons_db.sql', 0, '-- Military Weapons Database\n-- Classification: TOP SECRET\n-- Last Modified: 2005-02-15\n\nCREATE TABLE weapons (\n    id INTEGER PRIMARY KEY,\n    name VARCHAR(255),\n    type VARCHAR(100),\n    status VARCHAR(50),\n    budget INTEGER\n);\n\nINSERT INTO weapons VALUES\n(1, ''F-35X Stealth Fighter'', ''Aircraft'', ''Development'', 50000000),\n(2, ''MX-100 Guided Missile'', ''Missile'', ''Testing'', 35000000),\n(3, ''EW-500 Electronic Warfare'', ''Defense'', ''Production'', 28000000),\n(4, ''Hypersonic Missile HM-200'', ''Missile'', ''Research'', 120000000);\n\n-- 1,247 rows of classified data\n-- DELETE THIS FILE', 12, 'rw-r-----'),
                (11, '155.22.88.4', '/var/lib/readme.txt', 'readme.txt', 0, 'Database Directory\n\nThis directory contains system databases.\n\nFiles:\n- weapons_db.sql: Weapons specifications\n- backups/: Automated backups\n\nAccess: Restricted\nBackup Schedule: Daily 02:00', 1, 'rw-r--r--'),

                -- System files Server 1
                (11, '155.22.88.4', '/var/log/auth.log', 'auth.log', 0, 'Feb 15 09:30:15 military-main sshd[1234]: Accepted password for contractor\nFeb 15 10:45:30 military-main sshd[1356]: Connection to 10.20.30.1\nFeb 15 11:00:15 military-main sshd[1456]: Connection to 172.16.5.10\nFeb 15 14:30:45 military-main accessed: /var/lib/weapons_db.sql', 2, 'rw-r-----'),
                (11, '155.22.88.4', '/var/log/syslog', 'syslog', 0, 'Feb 15 09:00:00 military-main systemd: Started database service\nFeb 15 10:15:30 military-main database: Query executed on weapons_db.sql\nFeb 15 12:00:00 military-main cron: Daily backup started', 2, 'rw-r-----'),
                (11, '155.22.88.4', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\ncontractor:x:1000:1000:Military Contractor:/home/contractor:/bin/bash\nengineer:x:1001:1001:Weapons Engineer:/home/engineer:/bin/bash\nsecurity:x:1002:1002:Security Officer:/home/security:/bin/bash\nadmin:x:1003:1003:System Admin:/home/admin:/bin/bash', 1, 'rw-r--r--'),
                (11, '155.22.88.4', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n155.22.88.4 main.military.net\n10.20.30.1 internal.military.net\n172.16.5.10 classified.military.net', 1, 'rw-r--r--'),
                (11, '155.22.88.4', '/etc/network.conf', 'network.conf', 0, 'Network Configuration\n\nInterface: eth0\nIP: 155.22.88.4\nNetmask: 255.255.255.0\nGateway: 155.22.88.1\n\nRoutes:\n- 10.20.30.0/24 via 155.22.88.1\n- 172.16.5.0/24 via 155.22.88.1', 1, 'rw-r--r--'),

                -- Server 2: 10.20.30.1 (Internal Network)
                (11, '10.20.30.1', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '10.20.30.1', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '10.20.30.1', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '10.20.30.1', '/opt/defense', 'defense', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '10.20.30.1', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '10.20.30.1', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '10.20.30.1', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '10.20.30.1', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- Home directories Server 2
                (11, '10.20.30.1', '/home/military', 'military', 1, NULL, 0, 'drwxr-x---'),
                (11, '10.20.30.1', '/home/defense', 'defense', 1, NULL, 0, 'drwxr-x---'),
                (11, '10.20.30.1', '/home/officer', 'officer', 1, NULL, 0, 'drwxr-x---'),

                -- Military user files
                (11, '10.20.30.1', '/home/military/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '10.20.30.1', '/home/military/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '10.20.30.1', '/home/military/blueprints', 'blueprints', 1, NULL, 0, 'drwxr-x---'),
                (11, '10.20.30.1', '/home/military/Desktop/system_info.txt', 'system_info.txt', 0, 'Internal Network Server\n\nHostname: internal.military.net\nIP: 10.20.30.1\nRole: Defense Contracts Management\n\nImportant:\n- Contracts database in /opt/defense/\n- All files classified SECRET or above\n- Connected to main server and classified server', 1, 'rw-r-----'),
                (11, '10.20.30.1', '/home/military/Documents/contracts_info.txt', 'contracts_info.txt', 0, 'Defense Contracts Information\n\nDatabase Location: /opt/defense/contracts.db\nFormat: SQLite3\nRecords: 892 active contracts\nTotal Value: $8.5 Billion\n\nMajor Contractors:\n- Lockheed Martin: $2.1B\n- Raytheon: $1.8B\n- Northrop Grumman: $1.5B\n- Boeing Defense: $1.2B\n\nAccess Level: SECRET', 2, 'rw-r-----'),
                (11, '10.20.30.1', '/home/military/blueprints/f35x_specs.pdf', 'f35x_specs.pdf', 0, '[PDF] F-35X Stealth Fighter\nClassification: TOP SECRET\n\nSpecifications:\n- Length: 15.7m\n- Wingspan: 10.7m  \n- Max Speed: Mach 2.5\n- Combat Radius: 1,200km\n- RCS: 0.005 m²\n\nWeapons:\n- Internal bays: 4x AIM-120\n- External: 8 hardpoints\n\n[127 pages of technical data]', 8, 'rw-------'),
                (11, '10.20.30.1', '/home/military/blueprints/missile_guidance.pdf', 'missile_guidance.pdf', 0, '[PDF] MX-100 Missile Guidance\nClassification: SECRET\n\nGuidance System:\n- GPS/INS navigation\n- Active radar terminal\n- CEP: <1 meter\n\nPerformance:\n- Range: 500km\n- Speed: Mach 3.5\n- Payload: 500kg\n\n[89 pages]', 6, 'rw-------'),

                -- Defense user files
                (11, '10.20.30.1', '/home/defense/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '10.20.30.1', '/home/defense/reports', 'reports', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '10.20.30.1', '/home/defense/Desktop/active_contracts.txt', 'active_contracts.txt', 0, 'Active Defense Contracts - 2005\n\n1. F-35X Development\n   Contractor: Lockheed Martin\n   Value: $50M\n   Status: Active\n\n2. Missile Systems\n   Contractor: Raytheon\n   Value: $35M\n   Status: Testing\n\n3. Electronic Warfare\n   Contractor: Northrop Grumman\n   Value: $28M\n   Status: Production\n\n4. Radar Upgrade\n   Contractor: Boeing\n   Value: $42M\n   Status: Active\n\nTotal: $155 Million', 2, 'rw-r-----'),
                (11, '10.20.30.1', '/home/defense/reports/budget_2005.txt', 'budget_2005.txt', 0, 'Defense Budget Report 2005\n\nTotal Allocated: $8.5 Billion\n\nBreakdown:\n- Aircraft: $3.2B (38%)\n- Missiles: $2.1B (25%)\n- Electronics: $1.8B (21%)\n- Other: $1.4B (16%)\n\nAll contract details in contracts.db', 2, 'rw-r-----'),

                -- Database location (SERVER 2 TARGET)
                (11, '10.20.30.1', '/opt/defense/contracts.db', 'contracts.db', 0, 'SQLite format 3\n-- Defense Contracts Database\n-- Classification: SECRET\n-- Last Update: 2005-02-15\n\nCREATE TABLE contracts (\n    contract_id INTEGER PRIMARY KEY,\n    contractor VARCHAR(255),\n    project_name VARCHAR(255),\n    value INTEGER,\n    status VARCHAR(50)\n);\n\nINSERT INTO contracts VALUES\n(1001, ''Lockheed Martin'', ''F-35X Stealth Fighter'', 50000000, ''Active''),\n(1002, ''Raytheon'', ''MX-100 Missile System'', 35000000, ''Testing''),\n(1003, ''Northrop Grumman'', ''EW-500 Electronic Warfare'', 28000000, ''Production'');\n\n-- 892 rows of contract data\n-- DELETE THIS FILE', 10, 'rw-r-----'),
                (11, '10.20.30.1', '/opt/defense/README.txt', 'README.txt', 0, 'Defense Contracts Directory\n\nDatabase: contracts.db\nFormat: SQLite3\nRecords: 892 contracts\n\nBackup: Daily at 03:00\nAccess: Restricted', 1, 'rw-r--r--'),

                -- System files Server 2
                (11, '10.20.30.1', '/var/log/access.log', 'access.log', 0, 'Feb 15 10:45:30 military-internal sshd[2345]: Connection from 155.22.88.4\nFeb 15 10:45:35 military-internal login: military logged in\nFeb 15 11:15:22 military-internal accessed: /opt/defense/contracts.db\nFeb 15 14:20:10 military-internal database query executed', 2, 'rw-r-----'),
                (11, '10.20.30.1', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nmilitary:x:1000:1000:Military Officer:/home/military:/bin/bash\ndefense:x:1001:1001:Defense Analyst:/home/defense:/bin/bash\nofficer:x:1002:1002:Security Officer:/home/officer:/bin/bash', 1, 'rw-r--r--'),
                (11, '10.20.30.1', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n10.20.30.1 internal.military.net\n155.22.88.4 main.military.net\n172.16.5.10 classified.military.net', 1, 'rw-r--r--'),

                -- Server 3: 172.16.5.10 (Classified Server)
                (11, '172.16.5.10', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '172.16.5.10', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '172.16.5.10', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '172.16.5.10', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '172.16.5.10', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '172.16.5.10', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '172.16.5.10', '/opt/research', 'research', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '172.16.5.10', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- Home directories Server 3
                (11, '172.16.5.10', '/home/classified', 'classified', 1, NULL, 0, 'drwxr-x---'),
                (11, '172.16.5.10', '/home/research', 'research', 1, NULL, 0, 'drwxr-x---'),
                (11, '172.16.5.10', '/home/scientist', 'scientist', 1, NULL, 0, 'drwxr-x---'),

                -- Classified user files + DATABASE (SERVER 3 TARGET)
                (11, '172.16.5.10', '/home/classified/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '172.16.5.10', '/home/classified/documents', 'documents', 1, NULL, 0, 'drwxr-x---'),
                (11, '172.16.5.10', '/home/classified/projects.sqlite', 'projects.sqlite', 0, 'SQLite format 3\n-- Classified Research Projects\n-- Classification: TOP SECRET/SCI\n-- Last Modified: 2005-02-15\n\nCREATE TABLE projects (\n    project_id INTEGER PRIMARY KEY,\n    code_name VARCHAR(100),\n    description TEXT,\n    budget INTEGER,\n    classification VARCHAR(50)\n);\n\nINSERT INTO projects VALUES\n(1, ''Black Knight'', ''Advanced stealth technology'', 150000000, ''TOP SECRET/SCI''),\n(2, ''Dark Storm'', ''Hypersonic missile development'', 200000000, ''TOP SECRET/SCI''),\n(3, ''Silent Thunder'', ''Quantum radar evasion'', 95000000, ''TOP SECRET''),\n(4, ''Ghost Protocol'', ''AI electronic warfare'', 180000000, ''TOP SECRET/SCI'');\n\n-- 543 rows of classified data\n-- DELETE THIS FILE', 15, 'rw-------'),
                (11, '172.16.5.10', '/home/classified/Desktop/project_summary.txt', 'project_summary.txt', 0, 'Classified Research Projects\n\nDatabase: projects.sqlite\nLocation: /home/classified/\nRecords: 543 projects\nTotal Budget: $625 Million\n\nActive Projects:\n1. Black Knight - Stealth Tech\n2. Dark Storm - Hypersonics\n3. Silent Thunder - Quantum Systems\n4. Ghost Protocol - AI Warfare\n\nClearance: TOP SECRET/SCI required', 2, 'rw-------'),
                (11, '172.16.5.10', '/home/classified/documents/security_protocol.txt', 'security_protocol.txt', 0, 'Security Protocol\n\nClearance Levels:\n- Level 1: CONFIDENTIAL\n- Level 2: SECRET\n- Level 3: TOP SECRET\n- Level 4: TOP SECRET/SCI\n\nCurrent User: Level 4 access\n\nEmergency Protocol:\nIf breach detected:\n1. Lock all systems\n2. Delete all databases\n3. Notify command\n4. Preserve logs', 2, 'rw-r-----'),

                -- Research user files
                (11, '172.16.5.10', '/home/research/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '172.16.5.10', '/home/research/data', 'data', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '172.16.5.10', '/home/research/Desktop/black_knight.txt', 'black_knight.txt', 0, 'Project Black Knight\n\nObjective: Next-gen stealth technology\n\nAdvances:\n- Radar absorption: 99.8%\n- Heat signature: -85%\n- Acoustic: -40%\n\nBudget: $150M\nStatus: Phase 3 testing\n\nTest Results:\nRCS: 0.003 m² (smaller than golf ball)\nDetection range: <15km vs 200km normal', 2, 'rw-r-----'),
                (11, '172.16.5.10', '/home/research/data/test_results.txt', 'test_results.txt', 0, 'Classified Test Results\n\nBlack Knight: Success\n- All stealth metrics exceeded\n\nDark Storm: Success  \n- Mach 7.5 achieved\n- Range: 1,200km\n\nSilent Thunder: Success\n- Quantum coating effective\n- Detection: <5%\n\nGhost Protocol: Success\n- AI accuracy: 99.2%\n- Response: <100ms', 3, 'rw-r-----'),

                -- Scientist files
                (11, '172.16.5.10', '/home/scientist/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (11, '172.16.5.10', '/home/scientist/Desktop/hypersonic_data.txt', 'hypersonic_data.txt', 0, 'Hypersonic Missile Research\n\nProject Dark Storm\n\nSpeed Tests:\n- Mach 5.0: Success\n- Mach 6.5: Success\n- Mach 7.5: Success\n\nGuidance:\n- GPS accurate at Mach 7+\n- Terminal guidance functional\n- CEP maintained <1m\n\nNext: Mach 10 attempt', 2, 'rw-r-----'),

                -- Research directory
                (11, '172.16.5.10', '/opt/research/analysis.txt', 'analysis.txt', 0, 'Research Analysis 2005\n\nAll projects on schedule\nBudget utilization: 92%\n\nBreakthroughs:\n- Quantum stealth coating\n- Hypersonic propulsion\n- AI warfare systems\n\nDatabase: See /home/classified/projects.sqlite\nfor complete project information', 2, 'rw-r-----'),

                -- System files Server 3
                (11, '172.16.5.10', '/var/log/security.log', 'security.log', 0, 'Feb 15 11:00:15 classified-db sshd[3456]: Connection from 10.20.30.1\nFeb 15 11:00:20 classified-db login: classified authenticated\nFeb 15 11:30:45 classified-db accessed: /home/classified/projects.sqlite\nFeb 15 14:15:22 classified-db database query: projects table\nFeb 15 16:30:10 classified-db security_scan: All systems secure', 3, 'rw-r-----'),
                (11, '172.16.5.10', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nclassified:x:1000:1000:Classified Projects:/home/classified:/bin/bash\nresearch:x:1001:1001:Research Scientist:/home/research:/bin/bash\nscientist:x:1002:1002:Senior Scientist:/home/scientist:/bin/bash', 1, 'rw-r--r--'),
                (11, '172.16.5.10', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n172.16.5.10 classified.military.net\n155.22.88.4 main.military.net\n10.20.30.1 internal.military.net', 1, 'rw-r--r--')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                -- Server 1: 234.56.78.90 (Main Bank Server)
                (12, '234.56.78.90', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),
                (12, '234.56.78.90', '/vault', 'vault', 1, NULL, 0, 'drwx------'),
                (12, '234.56.78.90', '/opt/bank', 'bank', 1, NULL, 0, 'drwxr-xr-x'),

                -- Home directories Server 1
                (12, '234.56.78.90', '/home/banker', 'banker', 1, NULL, 0, 'drwxr-x---'),
                (12, '234.56.78.90', '/home/vault', 'vault', 1, NULL, 0, 'drwxr-x---'),
                (12, '234.56.78.90', '/home/security', 'security', 1, NULL, 0, 'drwxr-x---'),
                (12, '234.56.78.90', '/home/admin', 'admin', 1, NULL, 0, 'drwxr-x---'),

                -- Banker user directories
                (12, '234.56.78.90', '/home/banker/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/home/banker/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/home/banker/Downloads', 'Downloads', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/home/banker/Desktop/network_map.txt', 'network_map.txt', 0, 'CryptoBank Network Infrastructure - July 2005\n\nNetwork Topology:\n\n[Main Server] 234.56.78.90\n  |\n  +-- Connected to Security Server: 10.30.40.1\n      (Internal security network)\n      Access: SSH on port 22\n      Purpose: Password management and security protocols\n\nNote: The security server contains decryption passwords.\nMaster keys are stored on the backup server.\n\nFor security reasons, backup server IP is only accessible from security server.\n\n--- CLASSIFIED ---', 3, 'rw-r-----'),
                (12, '234.56.78.90', '/home/banker/Desktop/bank_notes.txt', 'bank_notes.txt', 0, 'CryptoBank International - Security Notes - July 2005\n\nSecurity Updates:\n- Implemented AES-256 encryption for all vaults\n- Added biometric authentication\n- Updated digital signature protocols\n- Enhanced transaction monitoring\n- Multi-server security architecture deployed\n\nVault Status:\n- Main vault: $2.3 billion in assets\n- Safety deposit boxes: 10,000+ customers\n- Digital currency: $500 million\n- International accounts: $1.8 billion\n\nSecurity Architecture:\n- Main server: Vault data storage\n- Security server: Password and key management\n- Backup server: Master key storage\n\nNote: vault_keys.aes requires password AND master key for decryption', 2, 'rw-r-----'),
                (12, '234.56.78.90', '/home/banker/Desktop/transaction_summary.txt', 'transaction_summary.txt', 0, 'CryptoBank Transaction Summary - July 2005\n\nDaily Transactions: 125,000+\nTotal Volume: $850 million/day\nAverage Transaction: $6,800\n\nTransaction Types:\n- Wire transfers: 45%\n- ATM withdrawals: 25%\n- Online banking: 20%\n- Branch deposits: 10%\n\nInternational Transfers:\n- SWIFT network: 15,000/day\n- Currency exchange: $120M/day\n- Cross-border: 89 countries\n\nSecurity:\n- All transactions encrypted\n- Real-time fraud detection\n- Multi-factor authentication\n- 24/7 monitoring', 2, 'rw-r-----'),
                (12, '234.56.78.90', '/home/banker/Documents/customer_accounts.txt', 'customer_accounts.txt', 0, 'CryptoBank Customer Account Summary\n\nTotal Accounts: 500,000+\nActive Accounts: 425,000\nCorporate Accounts: 15,000\nHigh Net Worth: 2,500\n\nAccount Types:\n- Checking: 250,000\n- Savings: 180,000\n- Investment: 45,000\n- Business: 25,000\n\nAverage Balance:\n- Personal: $45,000\n- Business: $280,000\n- Investment: $1.2M\n\nVIP Accounts (>$10M): 150\nTotal Assets Under Management: $22 billion', 2, 'rw-r-----'),
                (12, '234.56.78.90', '/home/banker/Documents/vault_procedures.txt', 'vault_procedures.txt', 0, 'CryptoBank Vault Access Procedures\n\nDaily Operations:\n1. Two-person authentication required\n2. Biometric scan + PIN code\n3. Time-locked vault doors\n4. Video surveillance mandatory\n5. All access logged\n\nVault Schedule:\n- Opening: 8:00 AM (Mon-Fri)\n- Closing: 6:00 PM (Mon-Fri)\n- Weekend: Closed (Emergency access only)\n\nEmergency Protocol:\n- Requires 3 authorized personnel\n- CEO approval mandatory\n- Federal notification within 1 hour\n\nSecurity Systems:\n- Motion detectors\n- Heat sensors\n- Pressure plates\n- Armed response team on-site', 2, 'rw-r-----'),

                -- Vault user
                (12, '234.56.78.90', '/home/vault/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/home/vault/Desktop/deposit_boxes.txt', 'deposit_boxes.txt', 0, 'Safety Deposit Box Registry\n\nTotal Boxes: 10,000\nOccupied: 8,500\nAvailable: 1,500\n\nBox Sizes:\n- Small (3x5): 3,000 boxes\n- Medium (5x10): 4,500 boxes\n- Large (10x10): 2,000 boxes\n- Jumbo (10x20): 500 boxes\n\nAnnual Rental:\n- Small: $75/year\n- Medium: $150/year\n- Large: $300/year\n- Jumbo: $600/year\n\nRevenue: $1.2M/year\n\nSecurity:\n- Dual key system\n- Access logged\n- Video recorded\n- Private viewing rooms', 2, 'rw-r-----'),

                -- Security user
                (12, '234.56.78.90', '/home/security/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/home/security/Desktop/incident_log.txt', 'incident_log.txt', 0, 'CryptoBank Security Incidents - July 2005\n\n2005-07-01: Failed login attempt detected\nIP: 67.89.123.45\nAttempts: 5\nAction: IP blocked\n\n2005-07-05: Unusual transaction pattern\nAccount: #5023948\nAmount: $500K wire transfer\nAction: Flagged for review, verified legitimate\n\n2005-07-12: Unauthorized access attempt\nServer: vault.cryptobank.internal\nAction: Access denied, security team notified\n\n2005-07-15: Network scan detected\nSource: External\nAction: Firewall rules updated, IDS alerted\n\nOverall Status: SECURE\nThreat Level: LOW', 2, 'rw-r-----'),

                -- Vault directory with ENCRYPTED FILE
                (12, '234.56.78.90', '/vault/vault_keys.aes', 'vault_keys.aes', 0, 'U2FsdGVkX1+vupppZksvRf5pq5g5XjFRlipRkwB0K1Y96Qsv2Lm+31cmzaAILwyt\nMKvDjF8xPqEuzF3LXqhXwNjFPQe3EfcVqGr7LwmKmxCPLlqF9OjY0B5eCcDKmSs4\nBfNzZEqx4BsL9p2FQx5mU7yJkW3FvPqGxL8Rt2vT4QwDkZJ5NcYvLmHxPfS9K2aB\nVqF7LwGxTy8Np4JcQs2YkM9PvB3LxFzE8RtW5KmN6JqGxYcL4TsF9vP2BwZxK7Ja\nN4MqVs8LcF3TyPxRw5GkJ2BvLzY9QxFmW8NsKpJ7VcH4LwTfG2vB9RxPzY5KmN6J\nLqGxYcL4TsF9vP2BwZxK7JaN4MqVs8LcF3TyPxRw5GkJ2BvLzY9QxFmW8NsKpJ7V\n\n-----BEGIN AES-256 ENCRYPTED DATA-----\nEncryption: AES-256-CBC\nKey Derivation: PBKDF2\nSalt: Random 128-bit\n\n[ENCRYPTED CONTENT - Use /decrypt_tool to decrypt]\nFile: vault_keys.aes\nPassword + Master Key Required\nFormat: CryptoKey2005-MASTER-AES-2005-XK9P\n-----END AES-256 ENCRYPTED DATA-----', 12, 'rw-------'),
                (12, '234.56.78.90', '/vault/access_log.txt', 'access_log.txt', 0, 'Vault Access Log - July 2005\n\n2005-07-15 08:00:00 - banker - Vault opened\n2005-07-15 08:15:22 - vault_manager - Safety deposit access\n2005-07-15 09:30:45 - banker - Cash count verification\n2005-07-15 11:20:10 - security - Security inspection\n2005-07-15 14:45:30 - banker - Customer deposit box access\n2005-07-15 17:55:00 - banker - Vault closed\n\nAll access authorized and logged.', 1, 'rw-r-----'),

                -- Opt bank directory
                (12, '234.56.78.90', '/opt/bank/transactions', 'transactions', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '234.56.78.90', '/opt/bank/transactions/daily_log.txt', 'daily_log.txt', 0, 'Transaction Processing Log - 2005-07-15\n\n08:00 - System startup\n08:15 - 1,247 transactions processed\n09:00 - 2,893 transactions processed\n10:00 - 4,521 transactions processed\n11:00 - 3,678 transactions processed\n12:00 - 2,156 transactions processed\n\nTotal: 14,495 transactions\nTotal Volume: $98.5 million\nFailed: 3 (fraud prevention)\nReversed: 8 (customer request)\n\nSystem Performance: OPTIMAL\nProcessing Time: <0.5 seconds avg', 2, 'rw-r--r--'),

                -- System files Server 1
                (12, '234.56.78.90', '/var/log/auth.log', 'auth.log', 0, 'Jul 15 09:30:15 cryptobank-main sshd[1234]: Accepted password for banker from 192.168.1.100 port 22\nJul 15 10:45:30 cryptobank-main sshd[1356]: Connection to 10.30.40.1 established\nJul 15 11:00:15 cryptobank-main sshd[1456]: Accessed vault directory\nJul 15 14:30:45 cryptobank-main sudo: banker : TTY=pts/0 ; PWD=/vault ; USER=root ; COMMAND=/bin/ls vault_keys.aes', 2, 'rw-r-----'),
                (12, '234.56.78.90', '/var/log/syslog', 'syslog', 0, 'Jul 15 08:00:00 cryptobank-main systemd: Banking system started\nJul 15 08:01:15 cryptobank-main database: Connected to transaction database\nJul 15 08:02:30 cryptobank-main vault: Vault system initialized\nJul 15 09:00:00 cryptobank-main backup: Hourly backup completed\nJul 15 14:30:22 cryptobank-main security: All systems secure', 2, 'rw-r-----'),
                (12, '234.56.78.90', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nbanker:x:1000:1000:Bank Administrator:/home/banker:/bin/bash\nvault:x:1001:1001:Vault Manager:/home/vault:/bin/bash\nsecurity:x:1002:1002:Security Officer:/home/security:/bin/bash\nadmin:x:1003:1003:System Admin:/home/admin:/bin/bash', 1, 'rw-r--r--'),
                (12, '234.56.78.90', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n234.56.78.90 main.cryptobank.net\n10.30.40.1 security.cryptobank.net\n172.20.10.5 backup.cryptobank.net', 1, 'rw-r--r--'),

                -- Server 2: 10.30.40.1 (Security Server)
                (12, '10.30.40.1', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '10.30.40.1', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '10.30.40.1', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '10.30.40.1', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '10.30.40.1', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '10.30.40.1', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '10.30.40.1', '/opt/security', 'security', 1, NULL, 0, 'drwxr-xr-x'),

                -- Home directories Server 2
                (12, '10.30.40.1', '/home/security', 'security', 1, NULL, 0, 'drwxr-x---'),
                (12, '10.30.40.1', '/home/admin', 'admin', 1, NULL, 0, 'drwxr-x---'),
                (12, '10.30.40.1', '/home/monitor', 'monitor', 1, NULL, 0, 'drwxr-x---'),

                -- Security user directories
                (12, '10.30.40.1', '/home/security/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '10.30.40.1', '/home/security/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '10.30.40.1', '/home/security/Desktop/passwords.txt', 'passwords.txt', 0, 'CryptoBank Security - Password Database\n\nDate: 2005-07-15\n\n=== VAULT DECRYPTION PASSWORDS ===\n\nMain Vault Password: CryptoKey2005\nBackup Vault Password: SecureVault2005\nEmergency Access: Emergency2005\n\nIMPORTANT:\nThese passwords must be combined with master key for vault access.\nMaster key location: Backup server (172.20.10.5)\n\nDecryption Format: password-masterkey\n\nExample: CryptoKey2005-[MASTERKEY]\n\n--- HIGHLY CONFIDENTIAL ---', 3, 'rw-------'),
                (12, '10.30.40.1', '/home/security/Desktop/backup_server_info.txt', 'backup_server_info.txt', 0, 'CryptoBank Backup Server Information\n\nBackup Server Details:\n- IP Address: 172.20.10.5\n- Purpose: Master key storage and disaster recovery\n- Access: SSH on port 22\n- Location: Secure data center - Site B\n\nSecurity Note:\nMaster keys are stored on backup server for added security.\nOnly authorized security personnel should access this server.\n\nAccess Protocol:\n1. Obtain password from this server\n2. Connect to backup server: 172.20.10.5\n3. Retrieve master key\n4. Combine password with master key\n5. Decrypt vault files\n\nEmergency Contact: security@cryptobank.com', 2, 'rw-r-----'),
                (12, '10.30.40.1', '/home/security/Documents/security_policy.txt', 'security_policy.txt', 0, 'CryptoBank Security Policy\n\nPassword Requirements:\n- Minimum 12 characters\n- Mix of upper/lower/numbers/symbols\n- Changed every 60 days\n- No password reuse\n- Multi-factor authentication required\n\nAccess Control:\n- Role-based access (RBAC)\n- Principle of least privilege\n- Regular access reviews\n- Immediate revocation on termination\n\nNetwork Security:\n- Firewall protection\n- Intrusion detection system\n- VPN for remote access\n- Network segmentation\n- DMZ for public services\n\nIncident Response:\n- 24/7 security operations center\n- Incident response team\n- Forensic capabilities\n- Regular security drills', 3, 'rw-r-----'),

                -- Monitor user
                (12, '10.30.40.1', '/home/monitor/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '10.30.40.1', '/home/monitor/Desktop/monitoring_status.txt', 'monitoring_status.txt', 0, 'Security Monitoring Status - 2005-07-15\n\nSystems Monitored:\n- Main server: 234.56.78.90 (ONLINE)\n- Security server: 10.30.40.1 (ONLINE)\n- Backup server: 172.20.10.5 (ONLINE)\n- Database server: 192.168.10.50 (ONLINE)\n- Web server: 234.56.78.91 (ONLINE)\n\nSecurity Events (Last 24h):\n- Failed logins: 12 (normal range)\n- Firewall blocks: 89 (automated)\n- IDS alerts: 3 (false positives)\n- Malware attempts: 0\n\nSystem Health:\n- CPU usage: 45% avg\n- Memory: 62% used\n- Disk: 58% used\n- Network: Normal traffic\n\nStatus: ALL SYSTEMS SECURE', 2, 'rw-r-----'),

                -- Opt security
                (12, '10.30.40.1', '/opt/security/firewall_rules.txt', 'firewall_rules.txt', 0, 'CryptoBank Firewall Rules\n\nInbound Rules:\n- Allow SSH (port 22) from internal network only\n- Allow HTTPS (port 443) from anywhere\n- Allow database (port 3306) from main server only\n- Block all other inbound traffic\n\nOutbound Rules:\n- Allow all from internal network\n- Allow HTTPS to payment processors\n- Allow SMTP for email (port 587)\n- Log all outbound connections\n\nSpecial Rules:\n- Rate limiting: 100 req/min per IP\n- Geo-blocking: High-risk countries\n- DDoS protection: Enabled\n- Port scanning detection: Active', 2, 'rw-r-----'),

                -- System files Server 2
                (12, '10.30.40.1', '/var/log/security.log', 'security.log', 0, 'Jul 15 08:00:00 cryptobank-security: System startup\nJul 15 08:15:30 cryptobank-security: Password database accessed by security\nJul 15 09:15:30 cryptobank-security: Backup server connection established\nJul 15 10:30:00 cryptobank-security: Master key synchronization completed\nJul 15 11:45:15 cryptobank-security: Security audit performed\nJul 15 14:00:00 cryptobank-security: All systems secure\nJul 15 16:30:22 cryptobank-security: Daily security report generated', 2, 'rw-r-----'),
                (12, '10.30.40.1', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nsecurity:x:1000:1000:Security Officer:/home/security:/bin/bash\nadmin:x:1001:1001:System Admin:/home/admin:/bin/bash\nmonitor:x:1002:1002:Security Monitor:/home/monitor:/bin/bash', 1, 'rw-r--r--'),
                (12, '10.30.40.1', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n10.30.40.1 security.cryptobank.net\n234.56.78.90 main.cryptobank.net\n172.20.10.5 backup.cryptobank.net', 1, 'rw-r--r--'),

                -- Server 3: 172.20.10.5 (Backup Server)
                (12, '172.20.10.5', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '172.20.10.5', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '172.20.10.5', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '172.20.10.5', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '172.20.10.5', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '172.20.10.5', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '172.20.10.5', '/opt/backups', 'backups', 1, NULL, 0, 'drwxr-xr-x'),

                -- Home directories Server 3
                (12, '172.20.10.5', '/home/backup', 'backup', 1, NULL, 0, 'drwxr-x---'),
                (12, '172.20.10.5', '/home/admin', 'admin', 1, NULL, 0, 'drwxr-x---'),

                -- Backup user directories
                (12, '172.20.10.5', '/home/backup/keys', 'keys', 1, NULL, 0, 'drwx------'),
                (12, '172.20.10.5', '/home/backup/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '172.20.10.5', '/home/backup/keys/master_keys.txt', 'master_keys.txt', 0, 'CryptoBank Master Key Database\n\nDate: 2005-07-15\n\n=== MASTER ENCRYPTION KEYS ===\n\nVault Master Key: MASTER-AES-2005-XK9P\nBackup Master Key: BACKUP-AES-2005-YL3Q\nEmergency Master Key: EMERGENCY-AES-2005-ZM7R\n\nSECURITY WARNING:\nThese keys provide access to $2.3 billion in bank assets.\nUnauthorized access is a federal crime.\n\n--- TOP SECRET ---', 3, 'rw-------'),
                (12, '172.20.10.5', '/home/backup/Desktop/backup_schedule.txt', 'backup_schedule.txt', 0, 'CryptoBank Backup Schedule\n\nDaily Backups:\n- 02:00 AM - Full database backup\n- 06:00 AM - Transaction logs\n- 12:00 PM - Incremental backup\n- 18:00 PM - Incremental backup\n- 22:00 PM - Security logs\n\nWeekly Backups:\n- Sunday 00:00 AM - Complete system backup\n- Archive to offsite storage\n\nMonthly Backups:\n- Last day of month - Full archive\n- Stored in secure vault\n- Kept for 7 years (regulatory requirement)\n\nBackup Retention:\n- Daily: 30 days\n- Weekly: 1 year\n- Monthly: 7 years\n\nDisaster Recovery:\n- RTO: 4 hours\n- RPO: 1 hour\n- Hot standby available', 2, 'rw-r-----'),

                -- Admin user
                (12, '172.20.10.5', '/home/admin/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (12, '172.20.10.5', '/home/admin/Desktop/system_info.txt', 'system_info.txt', 0, 'Backup Server System Information\n\nServer: backup.cryptobank.net\nIP: 172.20.10.5\nRole: Backup and disaster recovery\nLocation: Secure Data Center - Site B\n\nHardware:\n- CPU: 16 cores\n- RAM: 128 GB\n- Storage: 50 TB RAID 10\n- Network: 10 Gbps\n\nSoftware:\n- OS: Debian Linux 3.1\n- Backup: Bacula Enterprise\n- Encryption: AES-256\n- Database: PostgreSQL 8.0\n\nConnected Systems:\n- Main server: 234.56.78.90\n- Security server: 10.30.40.1\n- Database server: 192.168.10.50\n\nStatus: OPERATIONAL\nUptime: 145 days', 2, 'rw-r-----'),

                -- Opt backups
                (12, '172.20.10.5', '/opt/backups/transaction_backup.tar.gz', 'transaction_backup.tar.gz', 0, '[COMPRESSED BACKUP FILE]\n\nTransaction Database Backup\nDate: 2005-07-15 02:00:00\nSize: 45 GB (compressed from 120 GB)\n\nContents:\n- All transactions (Jan-Jul 2005)\n- Customer account data\n- Wire transfer records\n- International transactions\n- Audit trails\n\nEncryption: AES-256\nIntegrity: SHA-256 checksum verified\nRetention: 30 days', 8, 'rw-r-----'),
                (12, '172.20.10.5', '/opt/backups/vault_backup.tar.gz', 'vault_backup.tar.gz', 0, '[COMPRESSED BACKUP FILE]\n\nVault System Backup\nDate: 2005-07-15 02:30:00\nSize: 2.5 GB\n\nContents:\n- Safety deposit box registry\n- Access logs\n- Vault configurations\n- Security camera recordings (30 days)\n- Biometric data (encrypted)\n\nEncryption: AES-256\nRetention: 90 days\nCompliance: Bank Secrecy Act', 5, 'rw-r-----'),

                -- System files Server 3
                (12, '172.20.10.5', '/var/log/backup.log', 'backup.log', 0, 'Jul 15 02:00:00 cryptobank-backup: Daily backup started\nJul 15 02:45:30 cryptobank-backup: Master key backup completed\nJul 15 03:15:00 cryptobank-backup: Vault data backup completed\nJul 15 03:30:00 cryptobank-backup: Transaction backup completed\nJul 15 04:00:00 cryptobank-backup: All backups successful (Total: 52 GB)\nJul 15 10:30:00 cryptobank-backup: Security server connection verified\nJul 15 14:20:15 cryptobank-backup: Backup integrity check: PASSED', 2, 'rw-r-----'),
                (12, '172.20.10.5', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nbackup:x:1000:1000:Backup Administrator:/home/backup:/bin/bash\nadmin:x:1001:1001:System Admin:/home/admin:/bin/bash', 1, 'rw-r--r--'),
                (12, '172.20.10.5', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n172.20.10.5 backup.cryptobank.net\n234.56.78.90 main.cryptobank.net\n10.30.40.1 security.cryptobank.net', 1, 'rw-r--r--')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                -- Server 1: 78.90.123.45 (Public Server)
                (13, '78.90.123.45', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),
                (13, '78.90.123.45', '/opt/company', 'company', 1, NULL, 0, 'drwxr-xr-x'),

                -- Home directories Server 1
                (13, '78.90.123.45', '/home/manager', 'manager', 1, NULL, 0, 'drwxr-x---'),
                (13, '78.90.123.45', '/home/developer', 'developer', 1, NULL, 0, 'drwxr-x---'),
                (13, '78.90.123.45', '/home/security', 'security', 1, NULL, 0, 'drwxr-x---'),

                -- Manager user directories
                (13, '78.90.123.45', '/home/manager/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/home/manager/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/home/manager/Mail', 'Mail', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/home/manager/Downloads', 'Downloads', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/home/manager/Mail/inbox.txt', 'inbox.txt', 0, 'From: hr@techsecure.com\nTo: manager@techsecure.com\nDate: March 12, 2006\nSubject: Internal Database SSH Access\n\nHi Manager,\n\nAs requested, here are the SSH credentials for the internal HR database server:\n\nServer IP: 10.15.20.30\nSSH Username: hr_admin\nSSH Password: TechHR2006!\n\nIMPORTANT: This server requires SSH authentication. Use these credentials when connecting.\n\nThe server contains:\n- Employee database (employees.db)\n- Financial records (financial_records.xls)\n- Performance reviews (performance_reviews.txt)\n- Backup system access\n\nPlease keep these credentials secure. Unauthorized access is a federal crime.\n\nRegards,\nHR Department\n\n---\n\nFrom: finance@techsecure.com\nTo: manager@techsecure.com\nDate: March 15, 2006\nSubject: Q1 Financial Report Location\n\nThe Q1 2006 financial reports are now on the HR database server (192.168.50.20).\nYou will need SSH access to review them.\n\nBest,\nFinance Team', 3, 'rw-r-----'),
                (13, '78.90.123.45', '/home/manager/Desktop/notes.txt', 'notes.txt', 0, 'TechSecure Solutions - Manager Notes\n\nMarch 2006:\n- Review quarterly financial reports\n- Update employee database\n- Prepare board presentation\n- Schedule security audit\n\nReminders:\n- HR database SSH: 10.15.20.30 (check email for credentials)\n- Financial records need review by March 25\n- Board meeting preparation\n- Security policy update required\n\nServer Access:\n- Public server: No authentication required\n- HR Database: SSH required (see email)\n- Backup system: Via HR server\n\nPasswords:\n- Main system: ManagerPass2006\n- Email: same as above', 2, 'rw-r-----'),
                (13, '78.90.123.45', '/home/manager/Desktop/quarterly_summary.txt', 'quarterly_summary.txt', 0, 'TechSecure Solutions - Q1 2006 Summary\n\nRevenue: $15.2M (up 12% from Q4 2005)\nExpenses: $8.5M\nNet Profit: $6.7M\n\nEmployee Count: 245\nNew Hires: 45\nTurnover Rate: 6%\n\nClient Statistics:\n- New Contracts: 38\n- Client Retention: 94%\n- Average Contract Value: $400K\n\nKey Achievements:\n- Launched TechSecure Platform 2.0\n- Expanded to 3 new markets (EU, Asia)\n- Hired 45 new employees\n- Acquired 2 smaller competitors\n\nChallenges:\n- Increased competition from larger firms\n- Rising operational costs (+15%)\n- Talent retention in tech sector\n\nGoals for Q2 2006:\n- Increase revenue by 15%\n- Reduce operational costs by 8%\n- Launch global marketing campaign\n- Open 2 new offices', 2, 'rw-r-----'),
                (13, '78.90.123.45', '/home/manager/Documents/company_structure.txt', 'company_structure.txt', 0, 'TechSecure Solutions - Organizational Structure\n\nExecutive Team:\n- CEO: Michael Stevens\n- CTO: Jennifer Liu\n- CFO: Robert Martinez\n- COO: Sarah Anderson\n\nDepartments:\n\n1. Engineering (120 employees)\n   - Software Development: 60\n   - Security Research: 30\n   - QA/Testing: 20\n   - DevOps: 10\n\n2. Sales & Marketing (45 employees)\n   - Sales: 25\n   - Marketing: 15\n   - Business Development: 5\n\n3. Human Resources (15 employees)\n   - Recruitment: 8\n   - Employee Relations: 4\n   - Training: 3\n\n4. Finance (20 employees)\n   - Accounting: 12\n   - Financial Planning: 5\n   - Payroll: 3\n\n5. Operations (45 employees)\n   - IT Support: 20\n   - Facilities: 15\n   - Legal: 10', 2, 'rw-r-----'),
                (13, '78.90.123.45', '/home/manager/Documents/network_diagram.txt', 'network_diagram.txt', 0, 'TechSecure Solutions - Network Architecture\n\n[Internet]\n    |\n[Firewall]\n    |\n[Public DMZ] - 78.90.123.45 (This server)\n    |\n    +-- [Internal Network]\n            |\n            +-- HR Database Server: 10.15.20.30\n            |   (SSH Authentication Required)\n            |   Username: hr_admin\n            |   Contains: Employee data, financials\n            |\n            +-- Development Servers: 10.15.20.x\n            +-- Production Servers: 10.15.30.x\n            +-- Backup Systems: 10.15.40.x\n\nSecurity Notes:\n- Public server: Open access\n- Internal servers: SSH authentication mandatory\n- All connections logged\n- VPN alternative available', 2, 'rw-r-----'),

                -- Developer user
                (13, '78.90.123.45', '/home/developer/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/home/developer/projects', 'projects', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/home/developer/Desktop/project_status.txt', 'project_status.txt', 0, 'TechSecure Platform Development - March 2006\n\nActive Projects:\n\n1. Platform 2.0 Upgrade\n   Status: 85% complete\n   Launch: April 2006\n   Team: 12 developers\n\n2. Mobile Security App\n   Status: 60% complete\n   Launch: June 2006\n   Team: 8 developers\n\n3. Enterprise Dashboard\n   Status: 40% complete\n   Launch: August 2006\n   Team: 6 developers\n\n4. API Modernization\n   Status: Planning phase\n   Launch: Q4 2006\n   Team: 5 developers\n\nCode Repositories:\n- Main: git.techsecure.internal\n- Backup: 10.15.20.30:/opt/repos\n\nDevelopment Standards:\n- Code reviews mandatory\n- Unit test coverage: 80%+\n- Security scans weekly', 2, 'rw-r-----'),
                (13, '78.90.123.45', '/home/developer/projects/README.txt', 'README.txt', 0, 'Development Projects Directory\n\nThis directory contains active development projects.\n\nGuidelines:\n1. Always commit before end of day\n2. Follow coding standards\n3. Document all major changes\n4. Test locally before pushing\n\nAccess to production:\n- Requires manager approval\n- SSH to HR server for deployment keys\n- All deployments logged\n\nSupport:\nEmail: dev-support@techsecure.com\nSlack: #dev-team', 1, 'rw-r-----'),

                -- Security user
                (13, '78.90.123.45', '/home/security/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '78.90.123.45', '/home/security/Desktop/security_audit.txt', 'security_audit.txt', 0, 'TechSecure Security Audit - March 2006\n\nAudit Date: March 10, 2006\nAuditor: Security Team\n\nFindings:\n\n1. SSH Authentication (IMPLEMENTED)\n   - Internal servers now require SSH auth\n   - Credentials stored securely\n   - Two-factor planned for Q3\n   Status: SECURE\n\n2. Firewall Configuration\n   - All ports closed except 22, 80, 443\n   - DDoS protection enabled\n   - Intrusion detection active\n   Status: SECURE\n\n3. Data Encryption\n   - All sensitive data encrypted\n   - SSL certificates valid\n   - Database encryption enabled\n   Status: SECURE\n\n4. Access Logs\n   - All access logged\n   - Retention: 90 days\n   - Automated alerts configured\n   Status: SECURE\n\nRecommendations:\n- Implement 2FA by Q3 2006\n- Quarterly penetration testing\n- Employee security training\n\nOverall Rating: SECURE', 3, 'rw-r-----'),

                -- Opt company
                (13, '78.90.123.45', '/opt/company/licenses.txt', 'licenses.txt', 0, 'TechSecure Solutions - Software Licenses\n\nActive Licenses:\n\n1. Development Tools:\n   - Visual Studio: 50 licenses\n   - JetBrains Suite: 80 licenses\n   - GitHub Enterprise: Unlimited\n\n2. Security Tools:\n   - Nessus Professional: 10 licenses\n   - Burp Suite Pro: 15 licenses\n   - Wireshark: Open source\n\n3. Productivity:\n   - Microsoft Office 365: 245 licenses\n   - Slack Business: 245 users\n   - Jira Software: 150 users\n\n4. Infrastructure:\n   - AWS: Enterprise account\n   - Azure: Pay-as-you-go\n   - VMware: 20 licenses\n\nTotal Annual Cost: $450,000', 2, 'rw-r-----'),

                -- System files Server 1
                (13, '78.90.123.45', '/var/log/auth.log', 'auth.log', 0, 'Mar 16 09:15:22 techsecure-public sshd[1234]: Accepted publickey for manager from 192.168.1.150 port 22\nMar 16 10:30:45 techsecure-public sudo: manager : TTY=pts/0 ; PWD=/home/manager ; USER=root ; COMMAND=/bin/cat /var/log/syslog\nMar 16 11:45:20 techsecure-public sshd[1356]: Connection to 10.15.20.30 established\nMar 16 14:20:15 techsecure-public sshd[1456]: Failed password for developer from 78.90.123.50 port 22', 2, 'rw-r-----'),
                (13, '78.90.123.45', '/var/log/syslog', 'syslog', 0, 'Mar 16 08:00:00 techsecure-public systemd: System started\nMar 16 08:01:15 techsecure-public sshd: SSH daemon started\nMar 16 09:00:00 techsecure-public cron: Daily backup started\nMar 16 14:30:22 techsecure-public kernel: Firewall rule updated\nMar 16 16:45:10 techsecure-public systemd: All systems operational', 2, 'rw-r-----'),
                (13, '78.90.123.45', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nmanager:x:1000:1000:Manager:/home/manager:/bin/bash\ndeveloper:x:1001:1001:Developer:/home/developer:/bin/bash\nsecurity:x:1002:1002:Security Officer:/home/security:/bin/bash\nwww-data:x:1003:1003:Web Server:/var/www:/bin/false', 1, 'rw-r--r--'),
                (13, '78.90.123.45', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n78.90.123.45 public.techsecure.com\n10.15.20.30 hrdb.techsecure.internal\n10.15.20.50 dev.techsecure.internal', 1, 'rw-r--r--'),

                -- Server 2: 10.15.20.30 (HR Database Server - SSH REQUIRED)
                (13, '10.15.20.30', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '10.15.20.30', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '10.15.20.30', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '10.15.20.30', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '10.15.20.30', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '10.15.20.30', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '10.15.20.30', '/opt/database', 'database', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '10.15.20.30', '/opt/repos', 'repos', 1, NULL, 0, 'drwxr-xr-x'),

                -- Home directories Server 2
                (13, '10.15.20.30', '/home/hr_admin', 'hr_admin', 1, NULL, 0, 'drwxr-x---'),
                (13, '10.15.20.30', '/home/backup', 'backup', 1, NULL, 0, 'drwxr-x---'),
                (13, '10.15.20.30', '/home/mysql', 'mysql', 1, NULL, 0, 'drwxr-x---'),

                -- HR Admin user directories
                (13, '10.15.20.30', '/home/hr_admin/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '10.15.20.30', '/home/hr_admin/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '10.15.20.30', '/home/hr_admin/database', 'database', 1, NULL, 0, 'drwxr-xr-x'),
                (13, '10.15.20.30', '/home/hr_admin/database/employees.db', 'employees.db', 0, 'TechSecure Solutions - Employee Database\nLast Updated: March 16, 2006\n\nEmployee Records (245 total):\n\nID: 001 | Name: John Smith | Position: Senior Developer | Salary: $95,000 | Joined: 2004-03-15\nID: 002 | Name: Sarah Johnson | Position: Project Manager | Salary: $105,000 | Joined: 2003-11-20\nID: 003 | Name: Mike Chen | Position: Security Analyst | Salary: $88,000 | Joined: 2005-06-10\nID: 004 | Name: Emily Rodriguez | Position: HR Director | Salary: $120,000 | Joined: 2002-08-25\nID: 005 | Name: David Kim | Position: Finance Manager | Salary: $110,000 | Joined: 2004-01-12\nID: 006 | Name: Lisa Wang | Position: Lead Developer | Salary: $98,000 | Joined: 2004-06-20\nID: 007 | Name: James Brown | Position: Sales Director | Salary: $115,000 | Joined: 2003-09-15\nID: 008 | Name: Maria Garcia | Position: Marketing Manager | Salary: $92,000 | Joined: 2005-01-10\n\n[... 237 more employee records ...]\n\nNote: This database contains highly sensitive employee information.\nAccess is restricted to HR and management only.\nAll access attempts are logged and monitored.', 8, 'rw-------'),
                (13, '10.15.20.30', '/home/hr_admin/database/financial_records.xls', 'financial_records.xls', 0, 'TechSecure Solutions - Financial Records Q1 2006\n\n=== REVENUE DETAILS ===\nSoftware Licenses: $8,500,000\nConsulting Services: $4,200,000\nSupport Contracts: $2,500,000\n-----------------------------------\nTotal Revenue: $15,200,000\n\n=== EXPENSE BREAKDOWN ===\nSalaries & Benefits: $5,200,000\nOffice Rent & Utilities: $1,100,000\nMarketing & Advertising: $800,000\nR&D Investment: $1,400,000\n-----------------------------------\nTotal Expenses: $8,500,000\n\n=== NET PROFIT ===\nQ1 2006 Profit: $6,700,000\nProfit Margin: 44%\n\n=== BANKING INFORMATION ===\nPrimary Account: Chase Business\nAccount Number: 1234567890\nRouting Number: 021000021\nCurrent Balance: $18,500,000\n\nSecondary Account: Bank of America\nAccount Number: 9876543210\nCurrent Balance: $5,200,000\n\n=== INVESTMENTS ===\nStock Portfolio: $12,000,000\nBonds: $8,000,000\nReal Estate: $15,000,000\n\nNote: These records are confidential and for internal use only.\nUnauthorized access is a federal crime.', 4, 'rw-------'),
                (13, '10.15.20.30', '/home/hr_admin/database/performance_reviews.txt', 'performance_reviews.txt', 0, 'TechSecure Solutions - Performance Reviews Q1 2006\n\n=== ENGINEERING DEPARTMENT ===\n\nJohn Smith (Senior Developer):\n- Performance: Excellent (9.2/10)\n- Projects completed: 8\n- Code quality: Outstanding\n- Team collaboration: Excellent\n- Innovation: High\n- Recommendation: Promotion to Lead Developer + $10K raise\n\nSarah Johnson (Project Manager):\n- Performance: Good (8.5/10)\n- Projects managed: 12 (all on time)\n- Team satisfaction: 92%\n- Budget management: Excellent\n- Recommendation: Continue current role + $5K bonus\n\nMike Chen (Security Analyst):\n- Performance: Excellent (9.5/10)\n- Vulnerabilities found: 47\n- Response time: 1.2 hours avg\n- Security audits: 15 completed\n- Recommendation: Promote to Security Team Lead + $12K raise\n\n=== SALES DEPARTMENT ===\n\nJames Brown (Sales Director):\n- Performance: Outstanding (9.8/10)\n- Revenue generated: $8.2M\n- New clients: 38\n- Client retention: 96%\n- Recommendation: $15K bonus + additional commission\n\n=== HR DEPARTMENT ===\n\nEmily Rodriguez (HR Director):\n- Performance: Excellent (9.0/10)\n- Hiring success rate: 94%\n- Employee satisfaction: 88%\n- Turnover reduction: 40%\n- Recommendation: Continue + $8K raise\n\n[... more reviews for remaining 240 employees ...]', 5, 'rw-r-----'),
                (13, '10.15.20.30', '/home/hr_admin/Documents/salary_structure.txt', 'salary_structure.txt', 0, 'TechSecure Solutions - Salary Structure 2006\n\n=== EXECUTIVE LEVEL ===\nCEO: $250,000 - $400,000\nCTO/CFO/COO: $180,000 - $300,000\nVP Level: $150,000 - $220,000\n\n=== MANAGEMENT ===\nDirector: $120,000 - $180,000\nSenior Manager: $100,000 - $140,000\nManager: $80,000 - $110,000\n\n=== TECHNICAL ===\nLead Developer: $95,000 - $130,000\nSenior Developer: $85,000 - $115,000\nDeveloper: $65,000 - $90,000\nJunior Developer: $50,000 - $70,000\n\n=== SALES ===\nSales Director: $110,000 - $150,000 + Commission\nSenior Account Manager: $80,000 - $110,000 + Commission\nAccount Manager: $60,000 - $85,000 + Commission\n\n=== SUPPORT ===\nSenior Support Engineer: $70,000 - $95,000\nSupport Engineer: $50,000 - $70,000\n\nBenefits:\n- Health insurance: 100% covered\n- 401(k) matching: 6%\n- Stock options: Yes\n- Annual bonus: 10-20% of salary\n- PTO: 20-30 days/year', 3, 'rw-r-----'),

                -- System files Server 2
                (13, '10.15.20.30', '/var/log/auth.log', 'auth.log', 0, 'Mar 16 08:30:10 techsecure-hrdb sshd[1234]: SSH service started\nMar 16 09:15:22 techsecure-hrdb sshd[1245]: Accepted password for hr_admin from 78.90.123.45 port 22\nMar 16 10:30:15 techsecure-hrdb sudo: hr_admin : TTY=pts/0 ; PWD=/home/hr_admin ; USER=root ; COMMAND=/usr/bin/mysql\nMar 16 11:45:30 techsecure-hrdb sshd[1267]: Failed password for root from 185.123.45.67 port 22\nMar 16 14:20:45 techsecure-hrdb sshd[1289]: Accepted password for hr_admin from 192.168.1.200 port 22', 3, 'rw-r-----'),
                (13, '10.15.20.30', '/var/log/mysql.log', 'mysql.log', 0, 'Mar 16 08:30:10 MySQL Server started\nMar 16 09:15:30 Query executed: SELECT * FROM employees WHERE department=Engineering\nMar 16 10:30:15 Query executed: UPDATE employees SET salary=salary*1.05 WHERE performance>8.5\nMar 16 11:45:30 Database backup completed successfully\nMar 16 14:00:00 Query executed: SELECT SUM(salary) FROM employees\nMar 16 16:30:22 MySQL Server: All queries processed', 2, 'rw-r-----'),
                (13, '10.15.20.30', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nhr_admin:x:1000:1000:HR Administrator:/home/hr_admin:/bin/bash\nbackup:x:1001:1001:Backup User:/home/backup:/bin/bash\nmysql:x:1002:1002:MySQL Server:/home/mysql:/bin/false', 1, 'rw-r--r--'),
                (13, '10.15.20.30', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n10.15.20.30 hrdb.techsecure.internal\n78.90.123.45 public.techsecure.com', 1, 'rw-r--r--')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (14, '145.67.89.123', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '145.67.89.123', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '145.67.89.123', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '145.67.89.123', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '145.67.89.123', '/home/admin', 'admin', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '145.67.89.123', '/home/admin/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '145.67.89.123', '/home/admin/Mail', 'Mail', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '145.67.89.123', '/home/admin/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '145.67.89.123', '/home/admin/Mail/inbox.txt', 'inbox.txt', 0, 'From: security@dataminer.com\nTo: admin@dataminer.com\nDate: September 10, 2006\nSubject: URGENT: System Update Required\n\nAdmin,\n\nWe need to update the rc.local configuration file on the database server immediately due to privacy concerns.\n\nFor security reasons, the modification password has been split into 3 parts:\n- Part 1: Included in this email below\n- Part 2: Stored in your personal notes on this system\n- Part 3: Stored in database server documentation\n\nYou must find all 3 parts and combine them (no spaces between parts).\n\nIMPORTANT: The old monitoring software must be completely removed from BOTH servers before the system update can proceed. These legacy tools will conflict with our new privacy-compliant monitoring system.\n\nPassword Part 1: DataPriv\n\nOnce you have all parts and removed the old software, proceed with the system update.\n\nSecurity Team', 3, 'rw-r-----'),
                (14, '145.67.89.123', '/home/admin/Desktop/privacy_monitor.exe', 'privacy_monitor.exe', 0, 'MZ\\x90\\x00\\x03\\x00\\x00\\x00\\x04\\x00\\x00\\x00\\xFF\\xFF\\x00\\x00\\xB8\\x00\\x00\\x00\\x00\\x00\\x00\\x00@\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\xE8\\x00\\x00\\x00\\x0E\\x1F\\xBA\\x0E\\x00\\xB4\\t\\xCD!\\xB8\\x01L\\xCD!This program monitors user privacy violations.\\r\\r\\n$', 5, 'rwxr-xr-x'),
                (14, '145.67.89.123', '/home/admin/Desktop/system_monitor.exe', 'system_monitor.exe', 0, 'MZ\\x90\\x00\\x03\\x00\\x00\\x00\\x04\\x00\\x00\\x00\\xFF\\xFF\\x00\\x00\\xB8\\x00\\x00\\x00\\x00\\x00\\x00\\x00@\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\xF0\\x00\\x00\\x00\\x0E\\x1F\\xBA\\x0E\\x00\\xB4\\t\\xCD!\\xB8\\x01L\\xCD!System monitoring tool for performance tracking.\\r\\r\\n$', 4, 'rwxr-xr-x'),
                (14, '145.67.89.123', '/home/admin/Desktop/admin_notes.txt', 'admin_notes.txt', 0, 'DataMiner Admin Personal Notes\nSeptember 2006\n\nTO-DO List:\n- Complete rc.local update on database server (URGENT)\n- Remove legacy monitoring tools from all servers\n- Quarterly review meeting next week\n- Update employee handbook\n- Schedule server maintenance window\n\nSystem Passwords:\n- Personal workstation: Admin2006\n- Email account: same as above\n- VPN access: Admin2006!Secure\n- Database server: DataBase2006#Secure\n\nDatabase Server Access:\n- IP Address: 172.18.25.50\n- Username: db_master\n- Port: 3306\n\nPassword Part 2 (for rc.local update): 2006\n\nRemember: Security said I need to find Part 3 in the database server docs before I can complete the update.\n\nMeeting Notes:\n- Privacy policy revision due Q4 2006\n- Legal team concerned about data retention\n- User growth: 15% month-over-month', 3, 'rw-r-----'),
                (14, '145.67.89.123', '/home/admin/Desktop/passwords.txt', 'passwords.txt', 0, 'Personal Password List (DO NOT SHARE!)\n\nEmail: Admin2006\nWorkstation: Admin2006\nVPN: Admin2006!Secure\nWiFi: DataMinerWiFi2006\nBackup System: BackupPass2006\n\nNote: Need to update these to more secure passwords next month.', 1, 'rw-------'),
                (14, '145.67.89.123', '/home/admin/Desktop/user_stats.txt', 'user_stats.txt', 0, 'DataMiner User Statistics - September 2006\n\nTotal Registered Users: 2,500,000\nActive Monthly Users: 1,800,000\nDaily Active Users: 950,000\n\nUser Demographics:\n- Age 13-17: 25%\n- Age 18-24: 35%\n- Age 25-34: 28%\n- Age 35+: 12%\n\nTop Countries:\n1. United States: 1,200,000\n2. United Kingdom: 350,000\n3. Canada: 280,000\n4. Australia: 180,000\n5. Germany: 150,000\n\nEngagement Metrics:\n- Average session time: 45 minutes\n- Posts per user: 12/day\n- Messages sent: 2.5M/day\n- Photos uploaded: 150K/day\n\nRevenue:\n- Ad Revenue: $8.5M/month\n- Premium Subscriptions: $2.2M/month\n- Total: $10.7M/month', 2, 'rw-r--r--'),
                (14, '145.67.89.123', '/home/admin/Desktop/meeting_agenda.txt', 'meeting_agenda.txt', 0, 'Board Meeting Agenda - September 25, 2006\n\n1. Q3 Financial Review\n   - Revenue: $32.1M (up 18%)\n   - Expenses: $18.5M\n   - Net Profit: $13.6M\n\n2. User Growth Update\n   - 2.5M total users\n   - 15% monthly growth\n   - Target: 5M users by Q2 2007\n\n3. Privacy Policy Concerns\n   - Legal team review required\n   - Potential regulatory issues\n   - Action plan needed\n\n4. Infrastructure Upgrade\n   - Database server expansion\n   - New monitoring systems\n   - Security improvements\n\n5. Q4 Goals\n   - Launch mobile app\n   - European expansion\n   - Partnership deals', 2, 'rw-r-----'),
                (14, '145.67.89.123', '/home/admin/Documents/privacy_concerns.txt', 'privacy_concerns.txt', 0, 'DataMiner - Privacy Concerns Report\n\nDate: September 15, 2006\n\nIssues Raised:\n1. Excessive data collection beyond what users consent to\n2. Sharing user data with third-party advertisers without clear disclosure\n3. Tracking user activity across external websites\n4. Storing private messages indefinitely without deletion option\n5. Facial recognition technology without opt-out\n\nLegal Team Assessment:\n- Risk Level: High\n- Potential Fines: $50-100M if privacy violations proven\n- Recommendation: Immediate policy review and update\n\nAction Items:\n- Implement user data export functionality\n- Add message deletion feature\n- Update Terms of Service for transparency\n- Reduce data retention periods\n- Offer opt-out for tracking\n\nTimeline: Must complete by Q4 2006 to avoid regulatory action', 2, 'rw-------'),
                (14, '145.67.89.123', '/home/admin/Documents/q3_financial_report.txt', 'q3_financial_report.txt', 0, 'DataMiner Q3 2006 Financial Report\n\nRevenue Breakdown:\n- Advertising: $24.5M\n- Premium Subscriptions: $6.8M\n- Data Licensing: $0.8M\nTotal Revenue: $32.1M\n\nExpenses:\n- Salaries: $9.2M\n- Infrastructure: $4.8M\n- Marketing: $2.5M\n- R&D: $2.0M\nTotal Expenses: $18.5M\n\nNet Profit: $13.6M\n\nYear-over-Year Growth: +48%\nUser Acquisition Cost: $2.15\nLifetime Value per User: $28.50', 2, 'rw-r-----'),
                (14, '145.67.89.123', '/home/admin/Documents/employee_list.txt', 'employee_list.txt', 0, 'DataMiner Employee Directory\n\nEngineering (45 employees):\n- John Smith - Lead Developer\n- Sarah Johnson - Senior Engineer\n- Mike Chen - Database Admin\n- Lisa Anderson - QA Lead\n\nMarketing (12 employees):\n- Robert Martinez - Marketing Director\n- Emily Davis - Content Manager\n- James Wilson - Social Media Lead\n\nOperations (8 employees):\n- David Brown - Operations Manager\n- Jennifer Lee - HR Director\n- Thomas Garcia - IT Support\n\nTotal Employees: 65\nOpen Positions: 12', 1, 'rw-r-----'),
                (14, '145.67.89.123', '/home/admin/Documents/server_maintenance.txt', 'server_maintenance.txt', 0, 'Server Maintenance Schedule\n\nDatabase Server (172.18.25.50):\n- Weekly Restart: Sunday 3:00 AM\n- Monthly Update: First Sunday\n- Backup: Daily 2:00 AM\n\nWeb Servers:\n- Load Balancer: lb.dataminer.com\n- Web1: 145.67.89.123 (this server)\n- Web2: 145.67.89.124\n- Web3: 145.67.89.125\n\nUpcoming Maintenance:\n- Database upgrade: September 30\n- Security patches: October 5\n- Hardware upgrade: October 15', 1, 'rw-r-----'),
                (14, '145.67.89.123', '/var/log/auth.log', 'auth.log', 0, 'Sep 18 08:45:15 dataminer-web sshd[1234]: Accepted password for admin from 192.168.1.100 port 22\nSep 18 09:30:22 dataminer-web sudo: admin : TTY=pts/0 ; PWD=/home/admin ; USER=root ; COMMAND=/bin/cat /etc/shadow\nSep 18 11:15:45 dataminer-web sshd[1356]: Accepted password for admin from 172.18.25.50 port 22\nSep 18 14:30:10 dataminer-web sshd[1456]: Failed password for admin from 145.67.89.50 port 22', 2, 'rw-r-----'),
                (14, '145.67.89.123', '/var/log/access.log', 'access.log', 0, 'Sep 18 08:30:15 dataminer-web nginx: GET /admin/dashboard - 200 OK\nSep 18 08:35:22 dataminer-web nginx: GET /admin/users - 200 OK\nSep 18 09:15:45 dataminer-web nginx: POST /api/users/search - 200 OK\nSep 18 10:30:10 dataminer-web nginx: GET /admin/statistics - 200 OK\nSep 18 11:45:30 dataminer-web nginx: GET /admin/database - 200 OK', 2, 'rw-r-----'),
                (14, '145.67.89.123', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nadmin:x:1000:1000:System Administrator:/home/admin:/bin/bash\nwebserver:x:1001:1001:Web Server:/home/webserver:/bin/bash\nbackup:x:1002:1002:Backup User:/home/backup:/bin/bash', 1, 'rw-r--r--'),
                (14, '172.18.25.50', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '172.18.25.50', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '172.18.25.50', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '172.18.25.50', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '172.18.25.50', '/home/db_master', 'db_master', 1, NULL, 0, 'drwxr-x---'),
                (14, '172.18.25.50', '/home/db_master/scripts', 'scripts', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '172.18.25.50', '/home/db_master/logs', 'logs', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '172.18.25.50', '/home/db_master/backups', 'backups', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '172.18.25.50', '/home/db_master/data', 'data', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '172.18.25.50', '/home/db_master/system_docs', 'system_docs', 1, NULL, 0, 'drwxr-xr-x'),
                (14, '172.18.25.50', '/home/db_master/security_guard.exe', 'security_guard.exe', 0, 'MZ\\x90\\x00\\x03\\x00\\x00\\x00\\x04\\x00\\x00\\x00\\xFF\\xFF\\x00\\x00\\xB8\\x00\\x00\\x00\\x00\\x00\\x00\\x00@\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\xE0\\x00\\x00\\x00\\x0E\\x1F\\xBA\\x0E\\x00\\xB4\\t\\xCD!\\xB8\\x01L\\xCD!This program guards database security and monitors access.\\r\\r\\n$', 5, 'rwxr-xr-x'),
                (14, '172.18.25.50', '/home/db_master/db_monitor.exe', 'db_monitor.exe', 0, 'MZ\\x90\\x00\\x03\\x00\\x00\\x00\\x04\\x00\\x00\\x00\\xFF\\xFF\\x00\\x00\\xB8\\x00\\x00\\x00\\x00\\x00\\x00\\x00@\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\x00\\xD0\\x00\\x00\\x00\\x0E\\x1F\\xBA\\x0E\\x00\\xB4\\t\\xCD!\\xB8\\x01L\\xCD!Database performance monitoring utility.\\r\\r\\n$', 4, 'rwxr-xr-x'),
                (14, '172.18.25.50', '/home/db_master/scripts/backup.sh', 'backup.sh', 0, '#!/bin/bash\n# DataMiner Database Backup Script\n# Automated daily backup system\n\n# Configuration\nBACKUP_DIR=/home/db_master/backups\nDB_NAME=dataminer_db\nDB_USER=db_master\n\n# Execute backup\necho Starting database backup...\nmysqldump -u db_user -p db_name > backup.sql\necho Backup completed successfully', 1, 'rwxr-x---'),
                (14, '172.18.25.50', '/home/db_master/scripts/cleanup.sh', 'cleanup.sh', 0, '#!/bin/bash\n# Database Cleanup Script\n# Removes old logs and temporary files\n\necho Starting cleanup process...\nfind /var/log/mysql -name old_log -mtime +30 -delete\nfind /tmp -name mysql_temp -mtime +7 -delete\necho Cleanup completed', 1, 'rwxr-x---'),
                (14, '172.18.25.50', '/home/db_master/logs/access_log.txt', 'access_log.txt', 0, 'Database Access Log - September 2006\n\n2006-09-18 08:30:15 - User: admin - IP: 145.67.89.123 - Action: SELECT\n2006-09-18 09:15:22 - User: admin - IP: 145.67.89.123 - Action: UPDATE\n2006-09-18 10:45:30 - User: backup - IP: 172.18.25.51 - Action: BACKUP\n2006-09-18 14:20:45 - User: admin - IP: 145.67.89.123 - Action: SELECT\n2006-09-18 16:35:10 - User: webserver - IP: 145.67.89.123 - Action: INSERT', 2, 'rw-r-----'),
                (14, '172.18.25.50', '/home/db_master/logs/error_log.txt', 'error_log.txt', 0, 'Database Error Log - September 2006\n\n2006-09-15 03:22:15 - WARNING: Slow query detected (4.2s)\n2006-09-16 08:45:30 - ERROR: Connection timeout from 145.67.89.125\n2006-09-17 14:30:22 - WARNING: High memory usage (87%)\n2006-09-18 02:15:45 - INFO: Backup completed successfully', 1, 'rw-r-----'),
                (14, '172.18.25.50', '/home/db_master/system_docs/password_info.txt', 'password_info.txt', 0, 'DataMiner Database Server - System Configuration Guide\n\nLast Updated: September 2006\n\nCritical System Files:\n- /etc/rc.local: System startup configuration\n- /etc/my.cnf: MySQL configuration\n- /etc/hosts: Network configuration\n\nBackup Schedule:\n- Daily: 2:00 AM (incremental)\n- Weekly: Sunday 3:00 AM (full)\n- Monthly: First Sunday (archive)\n\nAccess Control:\nModification of critical system files requires multi-part authentication.\nPassword Part 3 (final component): !\n\nNote: Combine all password parts in sequence to complete system modifications.\n\nSecurity Protocols:\n- All legacy monitoring tools must be removed before system updates\n- Configuration changes require admin-level authentication\n- System modifications are logged and audited', 2, 'rw-r-----'),
                (14, '172.18.25.50', '/home/db_master/system_docs/mysql_config.txt', 'mysql_config.txt', 0, 'MySQL Configuration Documentation\n\nServer Version: 5.0.45\nPort: 3306\nMax Connections: 500\nMax Packet Size: 64MB\n\nStorage Engines:\n- InnoDB (default)\n- MyISAM\n- MEMORY\n\nPerformance Settings:\n- Query Cache: 256MB\n- Buffer Pool: 4GB\n- Thread Cache: 50\n\nReplication:\n- Master: 172.18.25.50\n- Slave: 172.18.25.51\n- Binary Logging: Enabled', 1, 'rw-r-----'),
                (14, '172.18.25.50', '/home/db_master/system_docs/network_info.txt', 'network_info.txt', 0, 'Network Configuration\n\nDatabase Server:\n- Hostname: db.dataminer.internal\n- IP: 172.18.25.50\n- Gateway: 172.18.25.1\n- DNS: 172.18.25.2\n\nFirewall Rules:\n- Allow: 145.67.89.0/24 (web servers)\n- Allow: 172.18.25.0/24 (internal network)\n- Deny: All others\n\nMonitoring:\n- SNMP: Enabled\n- Syslog: 172.18.25.10', 1, 'rw-r-----'),
                (14, '172.18.25.50', '/home/db_master/system_docs/maintenance_log.txt', 'maintenance_log.txt', 0, 'Server Maintenance Log\n\n2006-09-01: Upgraded MySQL to 5.0.45\n2006-09-05: Increased buffer pool size\n2006-09-10: Installed new monitoring tools\n2006-09-15: Database optimization performed\n2006-09-18: Security audit completed\n\nNext Scheduled Maintenance:\n- 2006-09-30: System updates\n- 2006-10-15: Hardware upgrades', 1, 'rw-r-----'),
                (14, '172.18.25.50', '/home/db_master/data/user_profiles.sql', 'user_profiles.sql', 0, 'DataMiner User Profiles Database\n\n-- User Profile Table (2.5 million records)\nCREATE TABLE user_profiles (\n    user_id INT PRIMARY KEY,\n    username VARCHAR(50),\n    email VARCHAR(100),\n    full_name VARCHAR(100),\n    birth_date DATE,\n    location VARCHAR(100),\n    phone VARCHAR(20),\n    join_date DATETIME,\n    last_login DATETIME,\n    profile_picture_url TEXT,\n    bio TEXT,\n    interests TEXT,\n    privacy_settings JSON\n);\n\n-- Sample Data:\nINSERT INTO user_profiles VALUES\n(1, ''john_smith'', ''john@email.com'', ''John Smith'', ''1985-05-15'', ''New York, NY'', ''555-1234'', ''2005-03-20'', ''2006-09-18'', ''...'', ''Tech enthusiast'', ''technology,gaming,music'', ''...''),\n(2, ''sarah_jones'', ''sarah@email.com'', ''Sarah Jones'', ''1990-08-22'', ''Los Angeles, CA'', ''555-5678'', ''2005-06-10'', ''2006-09-18'', ''...'', ''Photographer'', ''photography,travel,art'', ''...''),\n...\n\n-- Total: 2.5 million user records\n-- Database Size: 850 GB\n-- Includes: profiles, messages, posts, photos, connections, activity logs', 15, 'rw-------'),
                (14, '172.18.25.50', '/home/db_master/data/user_messages.sql', 'user_messages.sql', 0, 'DataMiner User Messages Database\n\n-- Private Messages Table\nCREATE TABLE user_messages (\n    message_id INT PRIMARY KEY,\n    sender_id INT,\n    recipient_id INT,\n    message_text TEXT,\n    sent_datetime DATETIME,\n    read_status BOOLEAN,\n    deleted_by_sender BOOLEAN,\n    deleted_by_recipient BOOLEAN\n);\n\n-- Total Messages: 500+ million\n-- Average per user: 200 messages\n-- Storage: 250 GB\n\nNote: All private messages are stored permanently.\nNo deletion functionality implemented yet (coming in Q4 2006).', 8, 'rw-------'),
                (14, '172.18.25.50', '/home/db_master/data/user_activity_logs.sql', 'user_activity_logs.sql', 0, 'DataMiner User Activity Logs\n\n-- Activity Tracking Table\nCREATE TABLE activity_logs (\n    log_id INT PRIMARY KEY,\n    user_id INT,\n    activity_type VARCHAR(50),\n    activity_data JSON,\n    ip_address VARCHAR(50),\n    user_agent TEXT,\n    timestamp DATETIME\n);\n\n-- Tracked Activities:\n- Page views\n- Posts created/deleted\n- Photos uploaded\n- Profile updates\n- Login/logout\n- Connections made/removed\n- Messages sent\n- Search queries\n- External link clicks (tracking pixels)\n- Third-party site activity (cookies)\n\n-- Total Logs: 5+ billion records\n-- Storage: 200 GB\n-- Retention: Indefinite (privacy concern)\n\nNote: This data is shared with advertising partners for targeted ads.', 10, 'rw-------'),
                (14, '172.18.25.50', '/home/db_master/data/advertiser_data.txt', 'advertiser_data.txt', 0, 'DataMiner - Third-Party Advertiser Data Sharing\n\nPartner Advertisers (Receiving User Data):\n\n1. AdNetwork Global\n   - Data Shared: User demographics, interests, browsing history\n   - Monthly Fee: $500,000\n   - Access Level: Full activity logs\n\n2. TargetAds Inc\n   - Data Shared: User profiles, messages (keywords), location\n   - Monthly Fee: $350,000\n   - Access Level: Real-time tracking\n\n3. BehaviorTrack Systems\n   - Data Shared: Click patterns, engagement metrics, social graph\n   - Monthly Fee: $280,000\n   - Access Level: Historical and real-time\n\n4. MarketInsights Corp\n   - Data Shared: Purchase intent, product interests, demographics\n   - Monthly Fee: $420,000\n   - Access Level: Aggregated and individual data\n\nTotal Revenue from Data Sharing: $1.55M/month\n\nPrivacy Policy Compliance: QUESTIONABLE\nUser Consent: IMPLIED (buried in ToS)\nLegal Risk: HIGH\n\nNote: Legal team recommends immediate review of data sharing practices.', 3, 'rw-------'),
                (14, '172.18.25.50', '/var/log/mysql.log', 'mysql.log', 0, 'Sep 18 02:00:00 dataminer-db mysql: Daily backup started\nSep 18 02:45:30 dataminer-db mysql: Backup completed successfully - 850 GB backed up\nSep 18 08:30:15 dataminer-db mysql: Query: SELECT * FROM user_profiles WHERE last_login > ''2006-09-01''\nSep 18 09:15:22 dataminer-db mysql: Query: SELECT COUNT(*) FROM user_messages WHERE sent_datetime > ''2006-09-01''\nSep 18 10:30:45 dataminer-db mysql: Query: UPDATE user_profiles SET last_login=NOW() WHERE user_id=12345\nSep 18 11:45:10 dataminer-db mysql: Query: INSERT INTO activity_logs VALUES (...)\nSep 18 14:20:30 dataminer-db mysql: Connection from 145.67.89.123 (admin)\nSep 18 15:35:45 dataminer-db mysql: Query: SELECT * FROM advertiser_data', 4, 'rw-r-----'),
                (14, '172.18.25.50', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\ndb_master:x:1000:1000:Database Master:/home/db_master:/bin/bash\nmysql:x:1001:1001:MySQL Server:/var/lib/mysql:/bin/false\nbackup:x:1002:1002:Backup User:/home/backup:/bin/bash', 1, 'rw-r--r--'),
                (14, '172.18.25.50', '/etc/rc.local', 'rc.local', 0, '#!/bin/bash\n# DataMiner Database Server Startup Script\n\n# Start MySQL\n/usr/bin/mysqld_safe &\n\n# Start backup service\n/usr/bin/backup_service &\n\n# Start monitoring service\n/usr/bin/monitor_service &\n\n# Custom backdoor check\nif [ -f /tmp/.backdoor ]; then\n    /bin/bash /tmp/.backdoor &\nfi\n\nexit 0', 1, 'rwxr-xr-x')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (15, '198.51.100.45', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),
                (15, '198.51.100.45', '/srv', 'srv', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/root', 'root', 1, NULL, 0, 'drwx------'),
                (15, '198.51.100.45', '/home/editor', 'editor', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/webmaster', 'webmaster', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/sysadmin', 'sysadmin', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/reporter', 'reporter', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/reporter/Mail', 'Mail', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/reporter/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/reporter/Downloads', 'Downloads', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/reporter/.config', '.config', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/editor/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/editor/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/webmaster/public_html', 'public_html', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/webmaster/logs', 'logs', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/opt/apache', 'apache', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/opt/mysql', 'mysql', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/usr/bin', 'bin', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/usr/local', 'local', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/var/www', 'www', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/var/cache', 'cache', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/tmp/temp_files', 'temp_files', 1, NULL, 0, 'drwxrwxrwt'),
                (15, '198.51.100.45', '/srv/backups', 'backups', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/editor/Desktop/editorial_calendar.txt', 'editorial_calendar.txt', 0, 'MediaCorp Editorial Calendar - April 2007\n\nMonday: City Council Coverage\nTuesday: Business Section\nWednesday: Investigative Reports\nThursday: Features & Opinion\nFriday: Weekend Edition Prep\n\nUpcoming Major Stories:\n- GlobalEnergy Investigation (Reporter assigned)\n- Healthcare Reform Analysis\n- Education Budget Crisis\n- Local Election Coverage', 1, 'rw-r--r--'),
                (15, '198.51.100.45', '/home/editor/Documents/staff_assignments.txt', 'staff_assignments.txt', 0, 'Staff Assignments - April 2007\n\nReporter 1: GlobalEnergy investigation (HIGH PRIORITY)\nReporter 2: City hall beat\nReporter 3: Education coverage\nReporter 4: Sports section\nPhotographer: Various assignments\nCopy Editor: All sections', 1, 'rw-r--r--'),
                (15, '198.51.100.45', '/home/webmaster/public_html/index.html', 'index.html', 0, '<!DOCTYPE html>\n<html>\n<head>\n<title>MediaCorp News</title>\n</head>\n<body>\n<h1>MediaCorp - Truth in Journalism</h1>\n<p>Your trusted source for investigative journalism</p>\n</body>\n</html>', 1, 'rw-r--r--'),
                (15, '198.51.100.45', '/home/webmaster/logs/access.log', 'access.log', 0, '2007-04-12 08:30:15 - Page accessed: /news/investigation\n2007-04-12 10:45:22 - Page accessed: /about\n2007-04-12 14:20:33 - Page accessed: /contact', 1, 'rw-r--r--'),
                (15, '198.51.100.45', '/home/reporter/Downloads/press_release.pdf', 'press_release.pdf', 0, 'GlobalEnergy Corporation Press Release\nQ1 2007 Earnings Announcement\n\n[PDF Content - Official corporate statement]', 1, 'rw-r--r--'),
                (15, '198.51.100.45', '/home/reporter/Downloads/financial_report.xls', 'financial_report.xls', 0, 'GlobalEnergy Financial Data 2006-2007\nQ1 Revenue: $470M (reported)\nQ1 Actual: $420M (internal)', 1, 'rw-r--r--'),
                (15, '198.51.100.45', '/home/reporter/.config/ssh_config', 'ssh_config', 0, 'Host email-server\n  HostName 172.16.45.122\n  User emailadmin\n  Port 22', 2, 'rw-------'),
                (15, '198.51.100.45', '/opt/apache/httpd.conf', 'httpd.conf', 0, 'Apache Configuration\nServerName mediacorp.com\nDocumentRoot /var/www\nPort 80', 1, 'rw-r--r--'),
                (15, '198.51.100.45', '/opt/mysql/my.cnf', 'my.cnf', 0, 'MySQL Configuration\nDataDir /var/lib/mysql\nPort 3306', 1, 'rw-r--r--'),
                (15, '198.51.100.45', '/var/www/index.php', 'index.php', 0, 'MediaCorp Website PHP File', 1, 'rw-r--r--'),
                (15, '198.51.100.45', '/var/log/syslog', 'syslog', 0, 'Apr 12 08:00:00 mediacorp systemd[1]: Started system logging\nApr 12 09:15:22 mediacorp sshd[1234]: Session opened\nApr 12 10:30:45 mediacorp apache2[5678]: Server started', 2, 'rw-r-----'),
                (15, '198.51.100.45', '/var/cache/apt', 'apt', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/tmp/temp_files/temp_data.tmp', 'temp_data.tmp', 0, 'Temporary file contents', 1, 'rw-rw-rw-'),
                (15, '198.51.100.45', '/srv/backups/backup_20070412.tar.gz', 'backup_20070412.tar.gz', 0, 'Backup archive from April 12, 2007', 2, 'rw-r-----'),
                (15, '198.51.100.45', '/home/reporter/Mail/source_contact.eml', 'source_contact.eml', 0, 'From: anonymous_source@darkmail.net\nTo: reporter@mediacorp.com\nDate: April 8, 2007\nSubject: Re: Corporate Scandal Evidence\n\nDear Reporter,\n\nI have the evidence you need. Internal emails from GlobalEnergy Corporation that prove:\n\n1. Manipulation of quarterly earnings reports\n2. Bribing government officials for contracts  \n3. Covering up environmental violations\n4. Insider trading by C-level executives\n\nThe documents are stored on our secure email server:\n\nServer IP: 172.16.45.122\nSSH Username: emailadmin\nSSH Password: MediaSecure2007!\n\nYou will need SSH authentication to access this server. The evidence files are scattered across the email system for security - you will need to search for them.\n\nFind all 3 key emails and you will have everything needed for publication.\n\nPlease protect my identity. This could cost me everything.\n\n- Anonymous Source', 2, 'rw-r-----'),
                (15, '198.51.100.45', '/home/reporter/Mail/editor_response.eml', 'editor_response.eml', 0, 'From: editor@mediacorp.com\nTo: reporter@mediacorp.com\nDate: April 10, 2007\nSubject: Urgent: GlobalEnergy Story\n\nGreat work on securing the source! This could be the biggest story of the year.\n\nI need you to collect at least 3 key email files from the source:\n1. The earnings manipulation email\n2. The bribery communication\n3. The environmental cover-up memo\n\nOnce you have all three, we can move forward with publication. Legal team is standing by.\n\nBe careful - GlobalEnergy has deep pockets and powerful lawyers.\n\nEditor-in-Chief', 1, 'rw-r-----'),
                (15, '198.51.100.45', '/home/reporter/Mail/legal_warning.eml', 'legal_warning.eml', 0, 'From: legal@globalenergy.com\nTo: reporter@mediacorp.com\nDate: April 12, 2007\nSubject: CEASE AND DESIST\n\nDear Ms. Reporter,\n\nIt has come to our attention that you are investigating GlobalEnergy Corporation based on illegally obtained documents.\n\nWe hereby demand that you:\n1. Cease all investigation immediately\n2. Return all documents to GlobalEnergy\n3. Publish a retraction of any claims made\n\nFailure to comply will result in immediate legal action including but not limited to:\n- Defamation lawsuit seeking $100 million in damages\n- Criminal charges for corporate espionage\n- Permanent injunction against publication\n\nYou have 48 hours to comply.\n\nGlobalEnergy Legal Department', 2, 'rw-r-----'),
                (15, '198.51.100.45', '/home/reporter/Desktop/story_notes.txt', 'story_notes.txt', 0, 'MediaCorp Investigation Notes - April 2007\n\nGlobalEnergy Corporate Scandal\n\nKey Points:\n- $500M in fraudulent earnings reported\n- $10M in bribes paid to government officials\n- 15+ environmental violations covered up\n- Insider trading worth $25M\n\nSources:\n- Anonymous whistleblower (reliable)\n- Internal company emails\n- Financial records\n\nRisks:\n- Legal threats from GlobalEnergy\n- Whistleblower safety\n- MediaCorp liability\n\nNext Steps:\n1. Access email server (SSH required - check source email for credentials)\n2. Find and collect all 3 key email files (scattered across email system)\n3. Verify authenticity of documents\n4. Get legal approval\n5. Prepare for publication\n\nDeadline: April 20, 2007', 2, 'rw-r--r--'),
                (15, '198.51.100.45', '/home/reporter/Desktop/interview_schedule.txt', 'interview_schedule.txt', 0, 'Interview Schedule - April 2007\n\nMonday:\n- 10:00 AM: City Council Member\n- 2:00 PM: Local Business Owner\n\nTuesday:\n- 9:00 AM: Environmental Expert\n- 3:00 PM: Financial Analyst\n\nWednesday:\n- RESERVED: GlobalEnergy investigation\n\nThursday:\n- 11:00 AM: Healthcare Reform Story\n- 4:00 PM: Education Budget Meeting\n\nFriday:\n- Morning: Write GlobalEnergy article\n- Afternoon: Submit to editor', 1, 'rw-r--r--'),
                (15, '198.51.100.45', '/home/reporter/Desktop/source_protection.txt', 'source_protection.txt', 0, 'Source Protection Guidelines\n\nFor GlobalEnergy Investigation:\n\n1. Never mention source name in any document\n2. Use secure communication only (encrypted email)\n3. Store evidence on encrypted drive\n4. Meet only in secure locations\n5. Prepare legal defense if needed\n\nSource Safety:\n- Anonymous whistleblower from inside GlobalEnergy\n- Career and possibly life at risk\n- Evidence suggests retaliation is common at GlobalEnergy\n- Legal team on standby\n\nJournalist Shield Law:\n- Protected under state law\n- Cannot be forced to reveal source\n- Criminal penalties for source exposure', 2, 'rw-------'),
                (15, '198.51.100.45', '/home/reporter/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '198.51.100.45', '/home/reporter/Documents/past_articles.txt', 'past_articles.txt', 0, 'Published Articles - 2007\n\nJanuary: City Budget Crisis Investigation\nFebruary: Local Corruption Scandal\nMarch: Healthcare System Problems\nApril: GlobalEnergy (IN PROGRESS)\n\nAwards:\n- Regional Journalism Award 2006\n- Investigative Reporter of the Year 2006\n\nUpcoming:\n- Education reform series\n- Environmental protection story', 1, 'rw-r--r--'),
                (15, '198.51.100.45', '/home/reporter/Documents/contacts.txt', 'contacts.txt', 0, 'Professional Contacts\n\nEditors:\n- Chief Editor: editor@mediacorp.com\n- Managing Editor: managing@mediacorp.com\n\nLegal:\n- Corporate Lawyer: legal@mediacorp.com\n- Media Attorney: attorney@legalfirm.com\n\nSources:\n- Anonymous (GlobalEnergy): anonymous_source@darkmail.net\n- Government Official: contact via secure channel\n- Financial Analyst: analyst@finance.com\n\nEmergency:\n- Legal Hotline: 1-800-MEDIA-LAW\n- Source Protection Line: 1-800-PROTECT', 1, 'rw-------'),
                (15, '198.51.100.45', '/var/log/auth.log', 'auth.log', 0, 'Apr 12 09:15:22 mediacorp-server sshd[1234]: Accepted password for reporter from 192.168.1.150 port 22\nApr 12 10:30:45 mediacorp-server sudo: reporter : TTY=pts/0 ; PWD=/home/reporter ; USER=root ; COMMAND=/bin/cat /etc/shadow\nApr 12 14:20:15 mediacorp-server sshd[1356]: Accepted password for reporter from 172.16.45.122 port 22', 2, 'rw-r-----'),
                (15, '198.51.100.45', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nreporter:x:1000:1000:News Reporter:/home/reporter:/bin/bash\neditor:x:1001:1001:Editor:/home/editor:/bin/bash\nwebserver:x:1002:1002:Web Server:/home/webserver:/bin/bash', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),
                (15, '172.16.45.122', '/srv', 'srv', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/root', 'root', 1, NULL, 0, 'drwx------'),
                (15, '172.16.45.122', '/home/postfix', 'postfix', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/postfix/queue', 'queue', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/postfix/spool', 'spool', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/postfix/queue/pending.msg', 'pending.msg', 0, 'Message queue file - pending delivery', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/postfix/spool/maildrop', 'maildrop', 0, 'Mail spool data', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/backup', 'backup', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/backup/daily', 'daily', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/backup/weekly', 'weekly', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/backup/daily/backup_20070412.tar', 'backup_20070412.tar', 0, 'Daily backup archive', 2, 'rw-r-----'),
                (15, '172.16.45.122', '/home/backup/weekly/backup_weekly_15.tar.gz', 'backup_weekly_15.tar.gz', 0, 'Weekly backup - Week 15', 2, 'rw-r-----'),
                (15, '172.16.45.122', '/home/backup/backup_script.sh', 'backup_script.sh', 0, '#!/bin/bash\n# Email backup script\ntar -czf /home/backup/daily/backup_$(date +%Y%m%d).tar /home/emailadmin/', 1, 'rwxr-xr-x'),
                (15, '172.16.45.122', '/home/webmaster', 'webmaster', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/webmaster/www', 'www', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/webmaster/logs', 'logs', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/webmaster/www/webmail.html', 'webmail.html', 0, 'GlobalEnergy Webmail Interface\n<html><body>Webmail Login</body></html>', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/webmaster/logs/webmail_access.log', 'webmail_access.log', 0, '2007-04-10 08:30:12 - User login: cfo@globalenergy.com\n2007-04-11 09:15:33 - User login: ceo@globalenergy.com\n2007-04-12 10:45:22 - User login: emailadmin', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/emailadmin', 'emailadmin', 1, NULL, 0, 'drwxr-x---'),
                (15, '172.16.45.122', '/home/emailadmin/.config', '.config', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/emailadmin/.ssh', '.ssh', 1, NULL, 0, 'drwx------'),
                (15, '172.16.45.122', '/home/emailadmin/.config/email_client.conf', 'email_client.conf', 0, 'Email client configuration\nServer: localhost\nPort: 25\nProtocol: SMTP', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/emailadmin/.ssh/authorized_keys', 'authorized_keys', 0, 'ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQ... emailadmin@globalenergy', 1, 'rw-------'),
                (15, '172.16.45.122', '/home/emailadmin/inbox', 'inbox', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/emailadmin/sent', 'sent', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/emailadmin/archive', 'archive', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/emailadmin/drafts', 'drafts', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/emailadmin/trash', 'trash', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/home/emailadmin/inbox/earnings_fraud.eml', 'earnings_fraud.eml', 0, 'From: cfo@globalenergy.com\nTo: accounting@globalenergy.com\nDate: March 5, 2007\nSubject: Q1 2007 Earnings Adjustment\n\nTeam,\n\nAs discussed in our private meeting, we need to adjust the Q1 earnings report to meet Wall Street expectations. Current revenue is $420M but we need to report $470M.\n\nPlease use the following accounting methods:\n1. Move $30M in Q2 revenue to Q1 (early recognition)\n2. Delay reporting $15M in expenses to Q2\n3. Revalue our overseas assets upward by $5M\n\nThis gives us exactly $470M to report. Legal has approved these methods as within acceptable GAAP standards.\n\nEarnings call is April 15. Let us make the board and investors happy.\n\nCFO', 3, 'rw-------'),
                (15, '172.16.45.122', '/home/emailadmin/inbox/weekly_report.eml', 'weekly_report.eml', 0, 'From: hr@globalenergy.com\nTo: all@globalenergy.com\nDate: March 12, 2007\nSubject: Weekly Company Update\n\nDear Team,\n\nThis week highlights:\n- Q1 earnings preparation in progress\n- New employee orientation on Friday\n- Company picnic scheduled for April 20th\n- IT maintenance window this weekend\n\nHave a great week!\nHR Department', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/emailadmin/inbox/meeting_reminder.eml', 'meeting_reminder.eml', 0, 'From: calendar@globalenergy.com\nTo: executives@globalenergy.com\nDate: March 8, 2007\nSubject: Reminder: Board Meeting Tomorrow\n\nBoard meeting scheduled for:\nDate: March 9, 2007\nTime: 10:00 AM\nLocation: Conference Room A\n\nAgenda:\n1. Q1 Financial Review\n2. Strategic Planning\n3. Investment Opportunities', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/emailadmin/inbox/spam1.eml', 'spam1.eml', 0, 'From: marketing@onlinedeals.com\nSubject: Amazing Deals!\n\nBuy now and save 50%! Limited time offer!', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/emailadmin/inbox/spam2.eml', 'spam2.eml', 0, 'From: newsletter@techblog.com\nSubject: Weekly Tech News\n\nThis week in technology news...', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/emailadmin/sent/bribery_scheme.eml', 'bribery_scheme.eml', 0, 'From: ceo@globalenergy.com\nTo: government_relations@globalenergy.com\nDate: February 20, 2007\nSubject: Re: Contract Negotiations\n\nExcellent work on the offshore drilling contract!\n\nI have approved the $10M consulting fee payment to Senator Johnson as discussed. Wire transfer should go through the Cayman Islands subsidiary to avoid detection.\n\nThis investment will secure us the $500M government contract and give us exclusive rights to the Gulf drilling zones.\n\nFor accounting purposes, record this as government relations consulting services.\n\nKeep this communication confidential.\n\nCEO', 2, 'rw-------'),
                (15, '172.16.45.122', '/home/emailadmin/sent/quarterly_update.eml', 'quarterly_update.eml', 0, 'From: ceo@globalenergy.com\nTo: shareholders@globalenergy.com\nDate: March 1, 2007\nSubject: Q4 2006 Results\n\nDear Shareholders,\n\nWe are pleased to announce strong Q4 2006 results:\n- Revenue: $445M (up 12%)\n- Net Income: $89M\n- Earnings Per Share: $2.15\n\nLooking forward to an even stronger 2007.\n\nCEO', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/emailadmin/sent/contract_proposal.eml', 'contract_proposal.eml', 0, 'From: sales@globalenergy.com\nTo: client@example.com\nDate: February 15, 2007\nSubject: Partnership Proposal\n\nDear Valued Client,\n\nWe would like to propose a partnership opportunity for offshore drilling operations.\n\nEstimated contract value: $50M\nDuration: 3 years\nRevenue share: 70/30\n\nPlease review the attached proposal.\n\nBest regards,\nSales Team', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/emailadmin/archive/environmental_coverup.eml', 'environmental_coverup.eml', 0, 'From: operations@globalenergy.com\nTo: environmental@globalenergy.com, legal@globalenergy.com\nDate: January 15, 2007\nSubject: URGENT: Offshore Spill Incident\n\nWe have a situation. One of our offshore rigs leaked approximately 50,000 gallons of crude oil into protected marine areas.\n\nEPA regulations require immediate reporting, but this would trigger:\n- $25M+ in fines\n- Criminal investigation\n- Shutdown of all Gulf operations\n- Stock price collapse\n\nProposed solution:\n- DO NOT report to EPA\n- Classify as routine maintenance discharge\n- Use our cleanup contractor (discreet)\n- Destroy all evidence of actual volume\n- Pay off local witnesses ($500K budget approved)\n\nLegal team confirms this approach minimizes liability and keeps operations running.\n\nAll emails regarding this incident should be deleted after reading.\n\nOperations Director', 3, 'rw-------'),
                (15, '172.16.45.122', '/home/emailadmin/archive/old_contract_2006.eml', 'old_contract_2006.eml', 0, 'From: legal@globalenergy.com\nTo: contracts@globalenergy.com\nDate: December 2006\nSubject: 2006 Contract Archive\n\nArchiving all 2006 contracts as per company policy.\nTotal contracts: 247\nTotal value: $2.1B', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/emailadmin/archive/employee_reviews_2006.eml', 'employee_reviews_2006.eml', 0, 'From: hr@globalenergy.com\nDate: December 2006\nSubject: 2006 Performance Reviews Complete\n\nAll employee performance reviews have been completed.\n- Excellent: 45%\n- Good: 40%\n- Needs Improvement: 15%', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/emailadmin/drafts/press_release_draft.eml', 'press_release_draft.eml', 0, 'From: pr@globalenergy.com\nSubject: DRAFT - Q1 2007 Announcement\n\nDRAFT - NOT FOR PUBLICATION\n\nGlobalEnergy announces record Q1 2007 results...\n\n(This is a draft, needs CEO approval)', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/home/emailadmin/trash/deleted_memo.eml', 'deleted_memo.eml', 0, 'From: it@globalenergy.com\nDate: January 2007\nSubject: Server Maintenance\n\n[DELETED]\nScheduled maintenance completed successfully.', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/opt/postfix', 'postfix', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/opt/spamassassin', 'spamassassin', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/opt/ssl', 'ssl', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/opt/postfix/main.cf', 'main.cf', 0, 'Postfix Configuration\nmyhostname = mail.globalenergy.com\nmydomain = globalenergy.com\ninet_interfaces = all', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/opt/spamassassin/local.cf', 'local.cf', 0, 'SpamAssassin Configuration\nrequired_score 5.0\nreport_safe 0', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/opt/ssl/certificate.pem', 'certificate.pem', 0, '-----BEGIN CERTIFICATE-----\nMIIDXTCCAkWgAwIBAgIJAKZ... [SSL Certificate]\n-----END CERTIFICATE-----', 2, 'rw-r-----'),
                (15, '172.16.45.122', '/usr/bin/sendmail', 'sendmail', 0, 'Mail transfer agent binary', 1, 'rwxr-xr-x'),
                (15, '172.16.45.122', '/usr/sbin', 'sbin', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/usr/share', 'share', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/usr/sbin/postfix', 'postfix', 0, 'Postfix mail server daemon', 1, 'rwxr-xr-x'),
                (15, '172.16.45.122', '/usr/share/doc', 'doc', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/usr/share/doc/postfix-readme.txt', 'postfix-readme.txt', 0, 'Postfix Documentation\nVersion 2.4.5\nEmail server software', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/tmp/mail_temp', 'mail_temp', 1, NULL, 0, 'drwxrwxrwt'),
                (15, '172.16.45.122', '/tmp/session_data', 'session_data', 1, NULL, 0, 'drwxrwxrwt'),
                (15, '172.16.45.122', '/tmp/mail_temp/outgoing_12345.tmp', 'outgoing_12345.tmp', 0, 'Temporary outgoing mail file', 1, 'rw-rw-rw-'),
                (15, '172.16.45.122', '/tmp/session_data/sess_abc123', 'sess_abc123', 0, 'Web session data', 1, 'rw-rw-rw-'),
                (15, '172.16.45.122', '/srv/mail', 'mail', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/srv/www', 'www', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/srv/mail/quarantine', 'quarantine', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/srv/mail/quarantine/spam_20070410.eml', 'spam_20070410.eml', 0, 'Quarantined spam message from April 10', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/srv/www/webmail', 'webmail', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/srv/www/webmail/index.html', 'index.html', 0, 'GlobalEnergy Webmail Portal\nVersion 3.2.1', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/var/spool', 'spool', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/var/mail', 'mail', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/var/cache', 'cache', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/var/spool/postfix', 'postfix', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/var/spool/postfix/maildrop', 'maildrop', 0, 'Mail queue data', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/var/mail/emailadmin', 'emailadmin', 0, 'Local mailbox for emailadmin user', 2, 'rw-------'),
                (15, '172.16.45.122', '/var/cache/apt', 'apt', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/var/log/mail.log', 'mail.log', 0, 'Apr 10 08:15:33 email-server postfix/smtp: Delivered: from=cfo@globalenergy.com to=accounting@globalenergy.com\nApr 11 09:22:45 email-server postfix/smtp: Delivered: from=ceo@globalenergy.com to=government_relations@globalenergy.com\nApr 12 10:33:12 email-server postfix/smtp: Delivered: from=operations@globalenergy.com to=environmental@globalenergy.com', 2, 'rw-r-----'),
                (15, '172.16.45.122', '/var/log/auth.log', 'auth.log', 0, 'Apr 12 09:15:22 email-server sshd[1234]: Accepted password for emailadmin from 198.51.100.45 port 22\nApr 12 10:20:33 email-server sudo: emailadmin : TTY=pts/0 ; PWD=/home/emailadmin ; USER=root ; COMMAND=/usr/sbin/postfix reload', 2, 'rw-r-----'),
                (15, '172.16.45.122', '/var/log/system.log', 'system.log', 0, 'Apr 12 08:30:10 email-server systemd[1]: Started Mail Server.\nApr 12 09:15:22 email-server sshd[1234]: Accepted password for emailadmin from 198.51.100.45 port 22\nApr 12 10:30:15 email-server postfix[1456]: Email received from cfo@globalenergy.com\nApr 12 11:45:30 email-server postfix[1478]: Email received from ceo@globalenergy.com', 3, 'rw-r-----'),
                (15, '172.16.45.122', '/etc/postfix', 'postfix', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/etc/ssl', 'ssl', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/etc/postfix/master.cf', 'master.cf', 0, 'Postfix master process configuration', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/etc/ssl/certs', 'certs', 1, NULL, 0, 'drwxr-xr-x'),
                (15, '172.16.45.122', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n172.16.45.122 mail.globalenergy.com\n198.51.100.45 mediacorp.com', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nemailadmin:x:1000:1000:Email Administrator:/home/emailadmin:/bin/bash\npostfix:x:1001:1001:Mail Server:/var/spool/postfix:/bin/false', 1, 'rw-r--r--'),
                (15, '172.16.45.122', '/root/.bash_history', '.bash_history', 0, 'ls -la\ncd /home/emailadmin\ncat /var/log/mail.log\nsystemctl restart postfix\nnetstat -tulpn', 1, 'rw-------')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                (16, '203.0.113.89', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),
                (16, '203.0.113.89', '/srv', 'srv', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/root', 'root', 1, NULL, 0, 'drwx------'),
                (16, '203.0.113.89', '/home/finance', 'finance', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/home/hr', 'hr', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/home/it', 'it', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/home/sysadmin', 'sysadmin', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/home/sysadmin/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/home/sysadmin/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/home/sysadmin/logs', 'logs', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/home/sysadmin/.ssh', '.ssh', 1, NULL, 0, 'drwx------'),
                (16, '203.0.113.89', '/home/finance/reports', 'reports', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/home/hr/employee_files', 'employee_files', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/home/it/scripts', 'scripts', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/opt/trading_platform', 'trading_platform', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/opt/financial_software', 'financial_software', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/usr/local/bin', 'bin', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/var/backups', 'backups', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/srv/database', 'database', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '203.0.113.89', '/home/sysadmin/Desktop/admin_notes.txt', 'admin_notes.txt', 0, 'FinanceTech Solutions - System Admin Notes\n\nOctober 2007\n\nRecent Tasks:\n- Setup new CEO workstation (IP: 172.16.0.100)\n- Install financial software suite\n- Configure VPN access\n- Update backup schedules\n\nCEO System Access:\n- Hostname: CEO-WORKSTATION\n- IP Address: 172.16.0.100\n- SSH Username: ceo\n- SSH Password: FinanceCEO2007\n- Initial Password: FinanceCEO2007 (needs to change but he never does...)\n\nIMPORTANT: CEO workstation requires SSH authentication!\n\nSecurity Concerns:\n- CEO refuses to use strong passwords\n- CEO stores confidential files on desktop\n- CEO clicks every email link (security nightmare)\n- Multiple failed login attempts from unknown IPs\n- Found offshore account files on his Desktop!\n\nTODO:\n- Force CEO to use password manager\n- Enable 2FA on CEO account\n- Schedule security training for executives', 2, 'rw-r-----'),
                (16, '203.0.113.89', '/home/sysadmin/Documents/network_map.txt', 'network_map.txt', 0, 'FinanceTech Network Map - October 2007\n\n=== SERVERS ===\n\n1. Main Server (203.0.113.89)\n   - Role: Admin, HR, Finance\n   - Access: Standard\n   - Users: sysadmin, finance, hr, it\n\n2. CEO Workstation (172.16.0.100)\n   - Role: Executive workstation\n   - Access: SSH required (ceo / FinanceCEO2007)\n   - Users: ceo\n   - Security: LOW (CEO keeps sensitive files here)\n\n=== NETWORK STRUCTURE ===\n203.0.113.89 (Main) --> 172.16.0.100 (CEO)\n\n=== SECURITY NOTES ===\n- CEO workstation isolated for security\n- SSH authentication mandatory\n- Contains sensitive financial data\n- Offshore account information stored there', 1, 'rw-r--r--'),
                (16, '203.0.113.89', '/home/sysadmin/.ssh/known_hosts', 'known_hosts', 0, '172.16.0.100 ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQ...\n203.0.113.89 ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQ...', 1, 'rw-------'),
                (16, '203.0.113.89', '/home/finance/reports/q3_2007.txt', 'q3_2007.txt', 0, 'Q3 2007 Financial Report\n\nRevenue: $12.5M\nExpenses: $8.2M\nNet Profit: $4.3M\nGrowth: 15% YoY', 1, 'rw-r--r--'),
                (16, '203.0.113.89', '/home/hr/employee_files/employee_list.txt', 'employee_list.txt', 0, 'FinanceTech Employees - October 2007\n\n1. CEO - Executive\n2. John Smith - Finance\n3. Sarah Jones - HR\n4. Mike Chen - IT\n5. Admin - Sysadmin', 1, 'rw-r--r--'),
                (16, '203.0.113.89', '/home/it/scripts/backup.sh', 'backup.sh', 0, '#!/bin/bash\n# Daily backup script\ntar -czf /var/backups/daily_$(date +%Y%m%d).tar.gz /home/', 1, 'rwxr-xr-x'),
                (16, '203.0.113.89', '/opt/trading_platform/config.conf', 'config.conf', 0, 'Trading Platform Configuration\nServer: trading.financetech.com\nPort: 8443\nSSL: enabled', 1, 'rw-r--r--'),
                (16, '203.0.113.89', '/opt/financial_software/license.txt', 'license.txt', 0, 'FinanceTech Financial Suite\nLicense: FTECH-2007-PRO-12345\nExpires: December 31, 2008', 1, 'rw-r--r--'),
                (16, '203.0.113.89', '/var/backups/backup_20071017.tar.gz', 'backup_20071017.tar.gz', 0, 'System backup from October 17, 2007', 2, 'rw-r-----'),
                (16, '203.0.113.89', '/var/log/syslog', 'syslog', 0, 'Oct 17 08:00:00 financetech systemd[1]: System started\nOct 17 09:15:22 financetech sshd[1234]: Connection from 172.16.0.100\nOct 17 10:30:45 financetech trading[5678]: Platform active', 2, 'rw-r-----'),
                (16, '203.0.113.89', '/srv/database/financial_db.sql', 'financial_db.sql', 0, 'FinanceTech Database Backup\n-- Tables: accounts, transactions, users\n-- Records: 50000+\n-- Last backup: October 17, 2007', 2, 'rw-r-----'),
                (16, '203.0.113.89', '/tmp/session_12345', 'session_12345', 0, 'Temporary session data', 1, 'rw-rw-rw-'),
                (16, '203.0.113.89', '/home/sysadmin/logs/access_attempts.log', 'access_attempts.log', 0, 'FinanceTech Access Log - October 2007\n\nDate: 2007-10-15 09:30:22\nUser: ceo\nIP: 172.16.0.100\nStatus: SUCCESS\nAction: Login to financial system\n\nDate: 2007-10-15 14:45:10\nUser: ceo\nIP: 172.16.0.100\nStatus: SUCCESS\nAction: Accessed trading platform\n\nDate: 2007-10-16 08:15:33\nUser: unknown\nIP: 185.234.56.78\nStatus: FAILED\nAction: Attempted CEO account access\nNote: Possible intrusion attempt\n\nDate: 2007-10-16 10:30:45\nUser: ceo\nIP: 172.16.0.100\nStatus: SUCCESS\nAction: Modified portfolio allocations\n\nDate: 2007-10-17 11:20:15\nUser: unknown\nIP: 203.45.67.89\nStatus: FAILED\nAction: Attempted CEO account access\nNote: Another intrusion attempt - CEO password unchanged\n\nSecurity Alert: CEO credentials may be compromised. Recommend immediate password reset.', 2, 'rw-r-----'),
                (16, '203.0.113.89', '/home/sysadmin/logs/password_reset_requests.txt', 'password_reset_requests.txt', 0, 'Password Reset Requests - Q4 2007\n\nUser: john_smith | Date: 2007-10-05 | Reason: Forgot password\nUser: sarah_jones | Date: 2007-10-08 | Reason: Security update\nUser: ceo | Date: 2007-10-10 | Reason: Account locked (too many failed attempts)\nUser: mike_chen | Date: 2007-10-12 | Reason: Laptop stolen\nUser: ceo | Date: 2007-10-15 | Reason: Forgot password AGAIN\n\nNote: CEO has requested password reset 15 times this year. Current password: FinanceCEO2007\nRecommendation: Mandatory password training for CEO', 1, 'rw-r--r--'),
                (16, '203.0.113.89', '/var/log/auth.log', 'auth.log', 0, 'Oct 17 09:15:22 financetech-server sshd[1234]: Accepted password for sysadmin from 192.168.1.100 port 22\nOct 17 10:30:45 financetech-server sudo: sysadmin : TTY=pts/0 ; PWD=/home/sysadmin ; USER=root ; COMMAND=/bin/cat /etc/shadow\nOct 17 14:20:15 financetech-server sshd[1356]: Failed password for ceo from 185.234.56.78 port 22\nOct 17 14:25:30 financetech-server sshd[1357]: Failed password for ceo from 203.45.67.89 port 22', 2, 'rw-r-----'),
                (16, '203.0.113.89', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nsysadmin:x:1000:1000:System Administrator:/home/sysadmin:/bin/bash\nceo:x:1001:1001:CEO:/home/ceo:/bin/bash\nfinance:x:1002:1002:Finance Department:/home/finance:/bin/bash', 1, 'rw-r--r--'),
                (16, '172.16.0.100', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),
                (16, '172.16.0.100', '/root', 'root', 1, NULL, 0, 'drwx------'),
                (16, '172.16.0.100', '/home/admin', 'admin', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/home/backup', 'backup', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/home/ceo', 'ceo', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/home/ceo/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/home/ceo/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/home/ceo/Downloads', 'Downloads', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/home/ceo/.config', '.config', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/home/ceo/.ssh', '.ssh', 1, NULL, 0, 'drwx------'),
                (16, '172.16.0.100', '/home/admin/tools', 'tools', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/home/backup/archives', 'archives', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/opt/trading', 'trading', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/opt/analytics', 'analytics', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/usr/share', 'share', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/var/cache', 'cache', 1, NULL, 0, 'drwxr-xr-x'),
                (16, '172.16.0.100', '/tmp/trading_cache', 'trading_cache', 1, NULL, 0, 'drwxrwxrwt'),
                (16, '172.16.0.100', '/home/ceo/Desktop/credentials.txt', 'credentials.txt', 0, 'CEO Personal Credentials File\n\nNOTE: Keep this file secure!\n\n=== WORK ACCOUNTS ===\nCorporate Email: ceo@financetech.com\nPassword: FinanceCEO2007\n\nTrading Platform: ceo_trader\nPassword: FinanceCEO2007\n\nVPN Access: ceo\nPassword: FinanceCEO2007\n\n=== BANKING ===\nSwiss Bank Account: 0847362910\nPassword: FinanceCEO2007\n\nOffshore Account (Cayman): 9283746501\nPassword: FinanceCEO2007\n\n=== PERSONAL ===\nPersonal Email: ceo.private@securemail.com\nPassword: FinanceCEO2007\n\nBrokerage Account: CEO_INVEST\nPassword: FinanceCEO2007\n\nNote: I know I should use different passwords but I can never remember them!\n\n- CEO', 2, 'rw-------'),
                (16, '172.16.0.100', '/home/ceo/Desktop/trading_strategy.txt', 'trading_strategy.txt', 0, 'Q4 2007 Trading Strategy\n\nPortfolio Allocation:\n- Tech Stocks: 40% ($12M)\n- Real Estate: 25% ($7.5M)\n- Commodities: 20% ($6M)\n- Cash: 15% ($4.5M)\n\nTotal Portfolio Value: $30 Million\n\nUpcoming Moves:\n1. Dump TechCorp stock before earnings (insider info: bad quarter)\n2. Buy GlobalEnergy before government contract announcement\n3. Short real estate sector (housing bubble about to burst)\n\nInsider Information Sources:\n- Board member at TechCorp (quarterly dinner meetings)\n- Senator Johnson (political donations paying off)\n- CFO of GlobalEnergy (golf buddies)\n\nProjected Profit: $8-10M by end of Q4\n\nNote: Keep this strategy CONFIDENTIAL. SEC would have a field day with this info.', 2, 'rw-------'),
                (16, '172.16.0.100', '/home/ceo/Documents/offshore_accounts.xls', 'offshore_accounts.xls', 0, 'CEO Offshore Financial Holdings\n\nCayman Islands Account:\nAccount Number: 9283746501\nBalance: $15,250,000\nPurpose: Tax optimization\n\nSwiss Bank Account:\nAccount Number: 0847362910\nBalance: $8,750,000\nPurpose: Asset protection\n\nBermuda Trust:\nAccount Number: 7392846105\nBalance: $12,500,000\nPurpose: Estate planning\n\nTotal Offshore Assets: $36.5 Million\n\nNote: These accounts are NOT reported on US tax returns.\nAccountant has assured me this is ''legal grey area''.\n\nAnnual Maintenance Fees: $150,000\nTax Savings: $5-7 Million/year\n\nDefinitely worth it!', 2, 'rw-------'),
                (16, '172.16.0.100', '/home/ceo/Documents/tax_strategy.txt', 'tax_strategy.txt', 0, 'CEO Tax Avoidance Strategy 2007\n\n1. Route profits through Cayman subsidiary\n2. Transfer to Swiss account quarterly\n3. Use Bermuda trust for asset protection\n4. Keep offshore accounts off US tax forms\n\nProjected Tax Savings: $5-7M annually\n\nAccountant Contact: tax_wizard@offshore.com', 2, 'rw-------'),
                (16, '172.16.0.100', '/home/ceo/Downloads/market_analysis.pdf', 'market_analysis.pdf', 0, 'Market Analysis Report Q4 2007\nConfidential - For CEO Eyes Only\n\nKey trends and insider information...', 1, 'rw-r--r--'),
                (16, '172.16.0.100', '/home/ceo/Downloads/insider_tips.txt', 'insider_tips.txt', 0, 'Insider Trading Tips - October 2007\n\nFrom: Board Member (TechCorp)\nTip: Dump before Q4 earnings (bad quarter coming)\n\nFrom: Senator Johnson\nTip: Buy GlobalEnergy (govt contract approved)\n\nFrom: CFO Friend (RealEstate Inc)\nTip: Short housing sector (bubble bursting)', 2, 'rw-------'),
                (16, '172.16.0.100', '/home/ceo/.config/browser_history', 'browser_history', 0, 'Browsing History - October 17, 2007\n\n09:00 - offshore-banking.cayman.com\n09:15 - swiss-bank.ch/login\n10:30 - trading-platform.com\n11:00 - insider-trading-forum.onion\n14:00 - tax-haven-services.com', 1, 'rw-------'),
                (16, '172.16.0.100', '/home/ceo/.ssh/id_rsa', 'id_rsa', 0, '-----BEGIN RSA PRIVATE KEY-----\nMIIEpAIBAAKCAQEA... [Private SSH Key]\n-----END RSA PRIVATE KEY-----', 2, 'rw-------'),
                (16, '172.16.0.100', '/home/admin/tools/network_scanner.sh', 'network_scanner.sh', 0, 'Network scanner bash script for subnet scanning', 1, 'rwxr-xr-x'),
                (16, '172.16.0.100', '/home/backup/archives/ceo_files_backup.tar', 'ceo_files_backup.tar', 0, 'CEO files backup archive', 2, 'rw-r-----'),
                (16, '172.16.0.100', '/opt/trading/trading_bot.exe', 'trading_bot.exe', 0, 'Automated trading bot binary', 2, 'rwxr-xr-x'),
                (16, '172.16.0.100', '/opt/trading/config.ini', 'config.ini', 0, '[Trading]\napi_key=ABC123XYZ789\napi_secret=SECRET_KEY_HERE\nauto_trade=enabled', 1, 'rw-r--r--'),
                (16, '172.16.0.100', '/opt/analytics/market_data.db', 'market_data.db', 0, 'Market analysis database\nRecords: 100000+\nLast update: October 17, 2007', 2, 'rw-r--r--'),
                (16, '172.16.0.100', '/usr/share/doc/trading_manual.txt', 'trading_manual.txt', 0, 'Trading Platform Manual\nVersion 3.5\nLast updated: September 2007', 1, 'rw-r--r--'),
                (16, '172.16.0.100', '/var/log/trading.log', 'trading.log', 0, 'Oct 17 09:00:15 - Trade executed: BUY 1000 TECH at $50.25\nOct 17 10:30:22 - Trade executed: SELL 500 REAL at $120.50\nOct 17 14:15:45 - Trade executed: SHORT 2000 HOUSING at $85.00', 2, 'rw-r-----'),
                (16, '172.16.0.100', '/var/log/system.log', 'system.log', 0, 'Oct 17 08:30:10 ceo-workstation systemd[1]: Started Desktop Environment.\nOct 17 08:35:22 ceo-workstation login[1234]: User ceo logged in\nOct 17 09:15:45 ceo-workstation browser[1456]: Accessed trading platform\nOct 17 10:30:10 ceo-workstation browser[1567]: Accessed offshore banking website\nOct 17 14:45:30 ceo-workstation file[1678]: credentials.txt accessed', 3, 'rw-r-----'),
                (16, '172.16.0.100', '/var/cache/trading_cache.tmp', 'trading_cache.tmp', 0, 'Temporary trading data cache', 1, 'rw-rw-rw-'),
                (16, '172.16.0.100', '/tmp/trading_cache/session_data', 'session_data', 0, 'Trading session temporary data', 1, 'rw-rw-rw-'),
                (16, '172.16.0.100', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n172.16.0.100 ceo-workstation\n203.0.113.89 financetech-server', 1, 'rw-r--r--'),
                (16, '172.16.0.100', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nceo:x:1000:1000:CEO:/home/ceo:/bin/bash\nadmin:x:1001:1001:Admin:/home/admin:/bin/bash\nbackup:x:1002:1002:Backup:/home/backup:/bin/bash', 1, 'rw-r--r--'),
                (16, '172.16.0.100', '/root/.bash_history', '.bash_history', 0, 'ls -la /home/ceo\ncat /home/ceo/Documents/offshore_accounts.xls\ncd /opt/trading\n./trading_bot.exe', 1, 'rw-------')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                -- Server 1: 192.0.2.150 (Initial Access Point)
                (17, '192.0.2.150', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),
                (17, '192.0.2.150', '/root', 'root', 1, NULL, 0, 'drwx------'),

                -- Home directories
                (17, '192.0.2.150', '/home/broker', 'broker', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/home/security', 'security', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/home/dealer', 'dealer', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/home/trader', 'trader', 1, NULL, 0, 'drwxr-xr-x'),

                -- Broker home
                (17, '192.0.2.150', '/home/broker/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/home/broker/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/home/broker/Downloads', 'Downloads', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/home/broker/.bash_history', '.bash_history', 0, 'ssh vaultkeeper@198.18.0.50\nls -la\ncd /home/broker/Desktop\ncat client_info.txt\nping 198.18.0.50\nnmap 198.18.0.50\nssh vaultkeeper@198.18.0.50\nexit', 1, 'rw-------'),
                (17, '192.0.2.150', '/home/broker/Desktop/vault_access.txt', 'vault_access.txt', 0, 'BlackMarket Data Broker - Vault Server Access\n\nMarch 2008\n\nHigh-Security Vault Server:\n- Server IP: 198.18.0.50\n- SSH Username: vaultkeeper\n- SSH Password: DarkVault2008#Secure\n- Security Level: MAXIMUM\n\nWARNING: Advanced intrusion detection active!\n- Trace increases with each command\n- File copy operations increase trace by 15%\n- Maximum safe trace level: 35%\n- Exceeding 35% triggers IMMEDIATE alarm and mission failure\n\nTarget Files:\n1. /home/vaultkeeper/vault/credit_cards.db (5000+ stolen cards)\n2. /home/vaultkeeper/vault/ssn_database.txt (10000+ SSNs)\n\nYou MUST copy both files to complete the mission.\n\nStealth Protocol:\n1. SSH into vault server quickly\n2. Navigate directly to /home/vaultkeeper/vault\n3. Use \"cp\" command to copy BOTH target files\n4. Monitor trace carefully - each copy adds 15%\n5. Disconnect immediately after copying\n\nCalculation:\n- Starting trace: ~5%\n- After 1st copy: ~20%\n- After 2nd copy: ~35% (at threshold!)\n\nYou have NO room for error. Work fast and precise.', 3, 'rw-------'),
                (17, '192.0.2.150', '/home/broker/Desktop/client_list.txt', 'client_list.txt', 0, 'BlackMarket Clients - March 2008\n\nActive Buyers:\n\n1. RussianMafia_007\n   Specialty: Credit card data\n   Payment: Bitcoin\n   Last order: $50K (1000 cards)\n   Status: TRUSTED\n\n2. ChineseHacker_88\n   Specialty: SSN databases\n   Payment: Monero\n   Last order: $35K (2000 SSNs)\n   Status: TRUSTED\n\n3. ItalianConnection\n   Specialty: Bank accounts\n   Payment: Cash (dead drops)\n   Last order: $120K (bank database)\n   Status: VIP\n\n4. NigerianPrince\n   Specialty: Identity packages\n   Payment: Wire transfer (offshore)\n   Last order: $200K (complete ID packages)\n   Status: VIP\n\n5. DarknetDealer_UK\n   Specialty: Mixed data\n   Payment: Bitcoin\n   Last order: $75K (various)\n   Status: TRUSTED\n\nTotal Revenue (Q1 2008): $1.2M\n\nNote: All clients paying premium for fresh, unburned data.', 2, 'rw-------'),
                (17, '192.0.2.150', '/home/broker/Desktop/pricing.txt', 'pricing.txt', 0, 'BlackMarket Data Pricing - 2008\n\nCredit Cards:\n- Basic (no CVV): $5-10 each\n- Full (with CVV): $20-50 each\n- Premium (high balance): $100+ each\n\nSSN Database:\n- Bulk SSNs: $5-15 each\n- Verified SSNs: $20-30 each\n- Premium (clean credit): $50+ each\n\nBank Accounts:\n- Basic access: $100-300 each\n- Full access + password: $500-2000 each\n- Business accounts: $2000-10000 each\n\nIdentity Packages:\n- Partial info: $200-500 each\n- Complete identity: $1000-3000 each\n- Premium (high net worth): $5000+ each\n\nNote: Prices fluctuate based on data freshness and buyer demand.', 2, 'rw-r--r--'),
                (17, '192.0.2.150', '/home/broker/Documents/transaction_log.txt', 'transaction_log.txt', 0, 'March 2008 Transaction Log\n\nMar 5: Sold 500 credit cards to RussianMafia_007 - $25,000\nMar 7: Sold 1000 SSNs to ChineseHacker_88 - $15,000\nMar 9: Sold 50 bank accounts to ItalianConnection - $75,000\nMar 12: Sold 25 identity packages to NigerianPrince - $50,000\nMar 15: Sold mixed data to DarknetDealer_UK - $30,000\nMar 18: Sold 200 premium cards to RussianMafia_007 - $40,000\nMar 22: Sold 500 verified SSNs to ChineseHacker_88 - $25,000\nMar 25: Sold 30 business accounts to ItalianConnection - $150,000\n\nTotal March Revenue: $410,000\nQ1 2008 Total: $1,200,000\n\nNote: Business is booming. Need to restock vault soon.', 2, 'rw-------'),
                (17, '192.0.2.150', '/home/broker/Documents/security_measures.txt', 'security_measures.txt', 0, 'Security Measures - Updated March 2008\n\n1. Vault Server Protection:\n   - Advanced IDS (Intrusion Detection System)\n   - Real-time trace monitoring\n   - 35% trace threshold (auto-lockdown)\n   - Enhanced firewall rules\n   - SSH key authentication available\n\n2. Communication Security:\n   - PGP encryption for all messages\n   - Tor network for anonymity\n   - Dead drops for physical meetings\n   - Burner phones rotated weekly\n\n3. Payment Security:\n   - Bitcoin tumblers\n   - Offshore accounts\n   - Cash only for large deals\n   - No direct bank transfers\n\n4. Operational Security:\n   - No real names\n   - Multiple safe houses\n   - Regular location changes\n   - Encrypted backups\n\nLaw Enforcement Threat Level: MEDIUM\nFBI Cyber Crime is actively hunting for us.', 2, 'rw-r-----'),
                (17, '192.0.2.150', '/home/broker/Downloads/tor_browser.tar.gz', 'tor_browser.tar.gz', 0, '[BINARY CONTENT - Tor Browser Bundle for anonymous browsing]', 50, 'rw-r--r--'),
                (17, '192.0.2.150', '/home/broker/Downloads/pgp_keys.asc', 'pgp_keys.asc', 0, '-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: GnuPG v2\n\nmQENBFxYZ3kBCADK8...[truncated]\n-----END PGP PUBLIC KEY BLOCK-----\n\n[Multiple PGP keys for secure client communication]', 5, 'rw-r--r--'),

                -- Security home
                (17, '192.0.2.150', '/home/security/ids_config.conf', 'ids_config.conf', 0, 'IDS Configuration - Vault Server 198.18.0.50\n\nTrace Monitoring:\n- Base trace: 5%\n- File read: +3% per file\n- File copy: +15% per file\n- Directory listing: +2%\n- SSH connection: +5%\n\nAlert Thresholds:\n- Yellow alert: 25% trace\n- Orange alert: 30% trace  \n- RED ALERT: 35% trace (LOCKDOWN)\n\nLockdown Actions:\n- Terminate all connections\n- Lock all accounts\n- Alert law enforcement\n- Preserve evidence\n- Blacklist attacker IP\n\nNote: System is VERY sensitive. Legitimate users must work quickly.', 2, 'rw-r-----'),
                (17, '192.0.2.150', '/home/security/threat_log.txt', 'threat_log.txt', 0, 'Security Threat Log - March 2008\n\nMar 5: 3 failed SSH attempts on vault server\nMar 7: 2 failed SSH attempts on vault server\nMar 9: BREACH DETECTED - Data stolen from vault\nMar 10: IDS upgraded, trace monitoring enabled\nMar 12: 1 failed attempt (blocked by new IDS)\nMar 15: 2 failed attempts (blocked by trace)\nMar 18: All quiet (new security working)\n\nThreat Assessment:\n- Multiple actors trying to breach vault\n- Some have valid credentials (insider threat?)\n- New IDS appears to be working\n- Trace system catching intrusions\n\nRecommendation: Maintain high alert status.', 2, 'rw-r-----'),

                -- Dealer home
                (17, '192.0.2.150', '/home/dealer/sales_pitch.txt', 'sales_pitch.txt', 0, 'BlackMarket Sales Pitch\n\nWhy buy from us?\n\n1. Fresh Data\n   - Recently stolen\n   - Not yet burned\n   - High success rate\n\n2. Quality Guaranteed\n   - Verified before sale\n   - Money-back if invalid\n   - Premium selection\n\n3. Secure Transactions\n   - Anonymous payment\n   - Encrypted delivery\n   - No traces\n\n4. Bulk Discounts\n   - 10% off 100+ items\n   - 20% off 500+ items\n   - 30% off 1000+ items\n\n5. VIP Program\n   - Priority access to new data\n   - Custom data requests\n   - Premium support\n\nContact: darknet_market_007@tormail.onion', 1, 'rw-r--r--'),
                (17, '192.0.2.150', '/home/dealer/inventory.txt', 'inventory.txt', 0, 'Current Inventory - March 25, 2008\n\nVault Server Stock:\n- Credit cards: 5,247 cards\n- SSN database: 10,482 SSNs\n- Bank accounts: 2,156 accounts\n- Identity packages: 547 packages\n\nEstimated Value: $2-5 Million\n\nRestock Schedule:\n- Credit cards: Weekly\n- SSNs: Bi-weekly\n- Bank accounts: Monthly\n- Identity packages: As available\n\nNote: Demand is high. Running low on inventory.', 1, 'rw-r--r--'),

                -- Trader home
                (17, '192.0.2.150', '/home/trader/market_analysis.txt', 'market_analysis.txt', 0, 'BlackMarket Analysis - Q1 2008\n\nMarket Trends:\n- Credit card demand: UP 30%\n- SSN demand: UP 45%\n- Bank account demand: UP 25%\n- Identity package demand: UP 60%\n\nPrice Trends:\n- All categories increasing\n- Premium data commanding higher prices\n- Fresh data selling faster\n\nCompetition:\n- 3 major competitors\n- We have best quality reputation\n- Our prices are mid-range\n- Customer loyalty is strong\n\nOpportunities:\n- Expand into new markets\n- Offer subscription service\n- Premium tier for VIP clients\n\nThreats:\n- Law enforcement pressure increasing\n- Some competitors undercutting prices\n- Data breaches becoming harder\n\nOutlook: POSITIVE (with caution)', 2, 'rw-r--r--'),

                -- System directories
                (17, '192.0.2.150', '/opt/vpn', 'vpn', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '192.0.2.150', '/opt/vpn/config.ovpn', 'config.ovpn', 0, 'client\ndev tun\nproto udp\nremote vpn.darknet.onion 1194\nresolv-retry infinite\nnobind\npersist-key\npersist-tun\ncipher AES-256-CBC\nauth SHA256\ncomp-lzo\nverb 3', 1, 'rw-r-----'),
                (17, '192.0.2.150', '/tmp/connection.log', 'connection.log', 0, 'Recent Connections:\n2008-03-25 09:15:22 - SSH from 192.168.1.100\n2008-03-25 10:30:45 - SSH to 198.18.0.50\n2008-03-25 11:45:30 - VPN connection established\n2008-03-25 14:20:15 - Tor circuit built', 1, 'rw-r--r--'),
                (17, '192.0.2.150', '/var/log/security.log', 'security.log', 0, 'Mar 10 08:30:15 blackmarket-broker security[1234]: Vault server security upgraded\nMar 10 09:15:22 blackmarket-broker security[1245]: IDS enabled on 198.18.0.50\nMar 10 10:30:45 blackmarket-broker security[1256]: Trace monitoring active\nMar 10 14:20:15 blackmarket-broker security[1267]: Security alert threshold set to 35%\nMar 15 08:00:00 blackmarket-broker security[1278]: All systems operational\nMar 20 10:30:00 blackmarket-broker security[1289]: Routine security check passed\nMar 25 09:00:00 blackmarket-broker security[1290]: Vault access logged', 2, 'rw-r-----'),
                (17, '192.0.2.150', '/var/log/auth.log', 'auth.log', 0, 'Mar 25 09:15:22 blackmarket sshd[1234]: Accepted password for broker from 192.168.1.100\nMar 25 09:20:30 blackmarket sshd[1245]: pam_unix(sshd:session): session opened for user broker\nMar 25 10:30:45 blackmarket sshd[1256]: Connection from broker to vaultkeeper@198.18.0.50\nMar 25 14:00:00 blackmarket sshd[1267]: Session closed for broker', 2, 'rw-r-----'),
                (17, '192.0.2.150', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nbroker:x:1000:1000:Data Broker:/home/broker:/bin/bash\nsecurity:x:1001:1001:Security:/home/security:/bin/bash\ndealer:x:1002:1002:Dealer:/home/dealer:/bin/bash\ntrader:x:1003:1003:Trader:/home/trader:/bin/bash', 1, 'rw-r--r--'),
                (17, '192.0.2.150', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n192.0.2.150 blackmarket-broker\n198.18.0.50 vault-server\n\n# Darknet services\n127.0.0.1 darknet.onion\n127.0.0.1 vpn.darknet.onion', 1, 'rw-r--r--'),
                (17, '192.0.2.150', '/root/.ssh', '.ssh', 1, NULL, 0, 'drwx------'),
                (17, '192.0.2.150', '/root/.ssh/known_hosts', 'known_hosts', 0, '198.18.0.50 ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC...', 1, 'rw-------'),
                -- Server 2: 198.18.0.50 (Vault Server - SSH Required)
                (17, '198.18.0.50', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '198.18.0.50', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '198.18.0.50', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '198.18.0.50', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '198.18.0.50', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '198.18.0.50', '/usr', 'usr', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '198.18.0.50', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),
                (17, '198.18.0.50', '/root', 'root', 1, NULL, 0, 'drwx------'),

                -- Home directories
                (17, '198.18.0.50', '/home/vaultkeeper', 'vaultkeeper', 1, NULL, 0, 'drwxr-x---'),
                (17, '198.18.0.50', '/home/security', 'security', 1, NULL, 0, 'drwxr-x---'),
                (17, '198.18.0.50', '/home/backup', 'backup', 1, NULL, 0, 'drwxr-x---'),

                -- Vaultkeeper home
                (17, '198.18.0.50', '/home/vaultkeeper/.bash_history', '.bash_history', 0, 'cd vault\nls -la\ncat credit_cards.db\ncat ssn_database.txt\ntail -f /var/log/ids.log\nps aux | grep ids\nsudo service ids restart\nexit', 1, 'rw-------'),
                (17, '198.18.0.50', '/home/vaultkeeper/vault', 'vault', 1, NULL, 0, 'drwx------'),
                (17, '198.18.0.50', '/home/vaultkeeper/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '198.18.0.50', '/home/vaultkeeper/Documents/vault_readme.txt', 'vault_readme.txt', 0, 'Vault Server - Security Information\n\nThis server contains highly sensitive stolen data.\n\nProtection Systems:\n- Advanced IDS (Intrusion Detection System)\n- Real-time trace monitoring\n- Automatic lockdown at 35% trace\n- SSH authentication required\n- Encrypted filesystem\n- Firewall with strict rules\n\nTrace Level Information:\n- Base trace on connection: 5%\n- Directory listing: +2% per ls\n- File read (cat): +3% per file\n- File copy (cp): +15% per file\n- File deletion: +20% per file\n\nCritical Files in /home/vaultkeeper/vault:\n- credit_cards.db (5,247 stolen cards)\n- ssn_database.txt (10,482 SSNs)\n- bank_accounts.xls (2,156 accounts)\n- identity_packages.zip (547 complete IDs)\n- buyers_list.txt (customer data)\n\nWARNING:\nIf trace exceeds 35%, system will:\n1. Terminate ALL connections immediately\n2. Lock ALL user accounts\n3. Alert law enforcement automatically\n4. Preserve forensic evidence\n5. Blacklist attacker IP permanently\n\nWork quickly and efficiently to stay under threshold.', 3, 'rw-r-----'),
                (17, '198.18.0.50', '/home/vaultkeeper/Documents/security_audit.txt', 'security_audit.txt', 0, 'Vault Server Security Audit - March 15, 2008\n\nAudit Results:\n\n1. IDS System: EXCELLENT\n   - Detecting all intrusion attempts\n   - Trace calculations accurate\n   - Lockdown mechanism tested and working\n\n2. SSH Security: GOOD\n   - Key-based auth enabled\n   - Password auth also available (for convenience)\n   - Failed login attempts logged\n\n3. Filesystem Security: EXCELLENT\n   - Vault directory has 700 permissions\n   - Critical files have 600 permissions\n   - Only vaultkeeper has access\n\n4. Network Security: GOOD\n   - Firewall blocking most ports\n   - Only SSH (22) and HTTPS (443) open\n   - VPN tunnel available for backup\n\n5. Logging: EXCELLENT\n   - All access attempts logged\n   - IDS events logged separately\n   - Logs are tamper-proof\n\nOverall Rating: 9/10 (VERY SECURE)\n\nRecommendations:\n- Rotate SSH keys monthly\n- Review IDS logs daily\n- Update threshold to 30% (more strict)\n- Enable two-factor authentication\n\nNext Audit: June 2008', 2, 'rw-r-----'),
                (17, '198.18.0.50', '/home/vaultkeeper/vault/credit_cards.db', 'credit_cards.db', 0, 'BlackMarket Stolen Credit Card Database\n\nTotal Cards: 5,247\nValid Rate: 87%\nTotal Value: $8.5 Million\n\n=== SAMPLE ENTRIES ===\n\nCard: 4532-1234-5678-9012\nExp: 12/2010\nCVV: 423\nName: John Smith\nBalance: $15,420\nStatus: ACTIVE\nBIN: Visa Classic\n\nCard: 5425-8765-4321-0987\nExp: 08/2011\nCVV: 891\nName: Sarah Johnson  \nBalance: $8,750\nStatus: ACTIVE\nBIN: Mastercard Gold\n\nCard: 3782-822463-10005\nExp: 03/2012\nCVV: 7284\nName: Michael Chen\nBalance: $32,100\nStatus: ACTIVE\nBIN: American Express Platinum\n\nCard: 6011-1234-5678-9012\nExp: 06/2013\nCVV: 456\nName: Jennifer Davis\nBalance: $12,500\nStatus: ACTIVE\nBIN: Discover\n\nCard: 4111-1111-1111-1111\nExp: 09/2011\nCVV: 789\nName: Robert Wilson\nBalance: $22,800\nStatus: ACTIVE\nBIN: Visa Signature\n\n[... 5,242 more entries ...]\n\nMarket Pricing:\n- Basic cards (<$5K balance): $20-30 each\n- Standard cards ($5K-$15K): $50-80 each\n- Premium cards ($15K-$30K): $100-200 each\n- Platinum cards (>$30K): $300-500 each\n\nTotal Database Worth: $100K-250K on black market\n\nWARNING: Federal offense - minimum 5 years prison per card.', 8, 'rw-------'),
                (17, '198.18.0.50', '/home/vaultkeeper/vault/ssn_database.txt', 'ssn_database.txt', 0, 'Stolen Social Security Numbers Database\n\nTotal SSNs: 10,482\nVerification Rate: 92%\nIdentity Theft Potential: CRITICAL\n\n=== SAMPLE ENTRIES ===\n\nSSN: 123-45-6789\nName: John Smith\nDOB: 05/15/1975\nAddress: 123 Main St, New York, NY 10001\nCredit Score: 720\nEmployer: ABC Corporation\nAnnual Income: $85,000\nStatus: VERIFIED\n\nSSN: 987-65-4321\nName: Sarah Johnson\nDOB: 08/22/1982\nAddress: 456 Oak Ave, Los Angeles, CA 90001\nCredit Score: 680\nEmployer: Tech Innovations Inc\nAnnual Income: $95,000\nStatus: VERIFIED\n\nSSN: 456-78-9012\nName: Michael Chen\nDOB: 03/10/1969\nAddress: 789 Pine Rd, Chicago, IL 60601\nCredit Score: 750\nEmployer: Financial Services Group\nAnnual Income: $120,000\nStatus: VERIFIED\n\nSSN: 789-01-2345\nName: Jennifer Davis\nDOB: 11/30/1985\nAddress: 321 Elm St, Houston, TX 77001\nCredit Score: 695\nEmployer: Medical Center\nAnnual Income: $78,000\nStatus: VERIFIED\n\nSSN: 234-56-7890\nName: Robert Wilson\nDOB: 07/18/1972\nAddress: 654 Maple Dr, Phoenix, AZ 85001\nCredit Score: 715\nEmployer: Construction LLC\nAnnual Income: $92,000\nStatus: VERIFIED\n\n[... 10,477 more entries ...]\n\nMarket Pricing:\n- Basic SSN (no verification): $5-10 each\n- Verified SSN (credit check done): $20-30 each\n- Premium SSN (high income, good credit): $50-100 each\n\nTotal Database Worth: $50K-150K on black market\n\nUse Cases:\n- Tax fraud\n- Loan applications\n- Credit card applications\n- Identity theft\n- Document forgery\n\nWARNING: Class A felony - minimum 10 years federal prison.', 6, 'rw-------'),
                (17, '198.18.0.50', '/home/vaultkeeper/vault/bank_accounts.xls', 'bank_accounts.xls', 0, 'Compromised Bank Account Database\n\nTotal Accounts: 2,156\nAccess Level: Full (routing + account + passwords)\nTotal Accessible Funds: $12.3 Million\n\n=== SAMPLE ENTRIES ===\n\nBank: Chase\nRouting: 021000021\nAccount: 123456789012\nOnline Password: Summer2008\nBalance: $45,230\nOwner: John Smith\nSSN: 123-45-6789\nStatus: ACTIVE\n\nBank: Bank of America\nRouting: 026009593\nAccount: 987654321098\nOnline Password: Password123\nBalance: $28,500\nOwner: Sarah Johnson\nSSN: 987-65-4321\nStatus: ACTIVE\n\nBank: Wells Fargo\nRouting: 121000248\nAccount: 456789012345\nOnline Password: WellsFargo1\nBalance: $67,890\nOwner: Michael Chen\nSSN: 456-78-9012\nStatus: ACTIVE\n\nBank: Citibank\nRouting: 021000089\nAccount: 789012345678\nOnline Password: Citibank2008\nBalance: $51,200\nOwner: Jennifer Davis\nSSN: 789-01-2345\nStatus: ACTIVE\n\n[... 2,152 more entries ...]\n\nMarket Pricing:\n- Basic access (view only): $100-200 each\n- Full access (transfer capable): $500-1000 each\n- Business accounts: $2000-10000 each\n\nTotal Database Worth: $200K-1M on black market\n\nWARNING: Multiple federal agencies actively investigating this data.\nFBI Financial Crimes Unit has open case. EXTREME RISK.', 5, 'rw-------'),
                (17, '198.18.0.50', '/home/vaultkeeper/vault/identity_packages.zip', 'identity_packages.zip', 0, 'Complete Identity Package Database (COMPRESSED)\n\nTotal Packages: 547\nCompleteness: 100% (Full identity takeover capability)\nFile Size: 2.4 GB compressed\n\n=== EACH PACKAGE CONTAINS ===\n\nPersonal Information:\n- Full legal name\n- Social Security Number\n- Date of Birth\n- Mothers maiden name\n- Place of birth\n\nDocuments (scanned):\n- Drivers License (front + back photo)\n- Passport (all pages)\n- Birth certificate\n- Social Security card\n\nFinancial Access:\n- Bank account details (3-5 accounts)\n- Credit card details (5-10 cards)\n- Investment account info\n- Retirement account info\n\nOnline Access:\n- Email passwords (primary + recovery)\n- Social media credentials (Facebook, Twitter, etc)\n- Online banking passwords\n- Shopping account passwords\n\nContact Information:\n- Home address + phone\n- Work address + phone\n- Emergency contacts\n- Family member info\n\nEmployment:\n- Current employer details\n- Employment history\n- Tax returns (last 3 years)\n- W2 forms\n- Pay stubs\n\nMarket Pricing:\n- Partial package (50% info): $200-500\n- Standard package (75% info): $500-1000\n- Complete package (100% info): $1000-3000\n- Premium package (high net worth): $5000-10000\n\nTotal Database Worth: $275K-1M on black market\n\nUse Cases:\n- Complete identity theft\n- Loan fraud (mortgages, auto, personal)\n- Tax fraud (fake returns)\n- Document forgery\n- Money laundering\n- Credit applications\n- Government benefit fraud\n\nWARNING: This is the holy grail of identity theft databases.\nFBI Cyber Crime Division has this at TOP PRIORITY.\nPossession = automatic 15+ years federal prison.\nDistribution = 25+ years federal prison.\nEXTREME RISK.', 12, 'rw-------'),
                (17, '198.18.0.50', '/home/vaultkeeper/vault/buyers_list.txt', 'buyers_list.txt', 0, 'BlackMarket Buyers - March 2008\n\nTier 1 - VIP Buyers:\n\n1. RussianMafia_007\n   Specialty: Credit card data (bulk)\n   Payment: Bitcoin\n   Last order: $50,000 (1000 cards)\n   Total lifetime: $450,000\n   Status: TRUSTED - Priority access\n   Contact: russian007@tormail.onion\n\n2. ItalianConnection\n   Specialty: Bank accounts (high value)\n   Payment: Cash (dead drops in Rome)\n   Last order: $120,000 (bank database)\n   Total lifetime: $800,000\n   Status: VIP - Exclusive deals\n   Contact: Via encrypted phone only\n\nTier 2 - Regular Buyers:\n\n3. ChineseHacker_88\n   Specialty: SSN databases\n   Payment: Monero\n   Last order: $35,000 (2000 SSNs)\n   Total lifetime: $180,000\n   Status: TRUSTED\n   Contact: ch88@darknet.onion\n\n4. NigerianPrince\n   Specialty: Identity packages\n   Payment: Wire transfer (offshore)\n   Last order: $200,000 (complete ID packages)\n   Total lifetime: $600,000\n   Status: VIP\n   Contact: prince@offshore.com\n\n5. DarknetDealer_UK\n   Specialty: Mixed data\n   Payment: Bitcoin\n   Last order: $75,000 (various)\n   Total lifetime: $250,000\n   Status: TRUSTED\n   Contact: uk_dealer@tormail.onion\n\nTier 3 - New Buyers:\n\n6. SilkRoadMerchant\n   Specialty: Credit cards (small batches)\n   Payment: Bitcoin\n   Last order: $10,000 (100 cards)\n   Total lifetime: $15,000\n   Status: NEW - Under evaluation\n   Contact: merchant@silkroad.onion\n\nTotal Revenue (Q1 2008): $1,200,000\nTotal Lifetime Revenue: $2,450,000\n\nPrice List Updates:\n- Credit cards: UP 10% (high demand)\n- SSNs: UP 15% (supply shortage)\n- Bank accounts: UP 20% (risk increase)\n- Identity packages: UP 25% (FBI heat)\n\nNote: All buyers paying premium for fresh, unburned data.\nQuality over quantity is our brand reputation.', 2, 'rw-------'),

                -- Security home
                (17, '198.18.0.50', '/home/security/ids_status.txt', 'ids_status.txt', 0, 'IDS Status - Vault Server\n\nLast Update: March 25, 2008 09:00:00\n\nSystem Status: ARMED\nThreat Level: ORANGE\nTrace Threshold: 35%\n\nRecent Activity:\n- 15 intrusion attempts this week\n- 12 blocked before reaching vault\n- 3 reached vault but exceeded trace\n- 0 successful breaches\n\nEffectiveness: 100%\n\nNote: New IDS working perfectly.', 1, 'rw-r-----'),

                -- Backup home
                (17, '198.18.0.50', '/home/backup/vault_backup.tar.gz', 'vault_backup.tar.gz', 0, '[BINARY CONTENT - Compressed backup of vault directory]', 250, 'rw-------'),
                (17, '198.18.0.50', '/home/backup/backup_log.txt', 'backup_log.txt', 0, 'Vault Backup Log\n\nMar 1: Full backup completed - 2.1 GB\nMar 8: Incremental backup - 150 MB\nMar 15: Full backup completed - 2.4 GB\nMar 22: Incremental backup - 180 MB\n\nNext scheduled backup: Mar 29', 1, 'rw-r--r--'),

                -- System directories
                (17, '198.18.0.50', '/opt/ids', 'ids', 1, NULL, 0, 'drwxr-xr-x'),
                (17, '198.18.0.50', '/opt/ids/config.yaml', 'config.yaml', 0, 'ids:\n  enabled: true\n  trace_threshold: 35\n  base_trace: 5\n  actions:\n    ls: 2\n    cat: 3\n    cp: 15\n    rm: 20\n    ssh: 5\n  lockdown:\n    terminate_connections: true\n    lock_accounts: true\n    alert_law_enforcement: true\n    preserve_evidence: true\n    blacklist_ip: true', 1, 'rw-r-----'),
                (17, '198.18.0.50', '/tmp/trace.log', 'trace.log', 0, 'Trace monitoring log:\n2008-03-25 09:00:00 - System armed, base trace: 5%\n2008-03-25 09:15:00 - No activity\n2008-03-25 09:30:00 - No activity', 1, 'rw-r--r--'),
                (17, '198.18.0.50', '/var/log/ids.log', 'ids.log', 0, 'Intrusion Detection System Log - March 2008\n\nMar 10 08:30:00 vault-server IDS[1234]: System armed\nMar 10 08:30:01 vault-server IDS[1234]: Trace monitoring enabled\nMar 10 08:30:02 vault-server IDS[1234]: Alert threshold set to 35%\nMar 10 08:30:03 vault-server IDS[1234]: Automatic lockdown ready\nMar 10 10:15:22 vault-server IDS[1234]: Intrusion attempt detected\nMar 10 10:15:45 vault-server IDS[1234]: Trace exceeded 35% - LOCKDOWN INITIATED\nMar 10 10:15:46 vault-server IDS[1234]: All connections terminated\nMar 10 10:15:47 vault-server IDS[1234]: Accounts locked\nMar 10 10:15:48 vault-server IDS[1234]: Law enforcement notified\nMar 12 08:00:00 vault-server IDS[1234]: System reset and re-armed\nMar 15 14:30:00 vault-server IDS[1234]: Intrusion attempt detected\nMar 15 14:30:15 vault-server IDS[1234]: Trace at 32% - Warning level\nMar 15 14:30:20 vault-server IDS[1234]: Connection voluntarily terminated by user\nMar 20 11:00:00 vault-server IDS[1234]: Routine security check - All systems operational\nMar 25 09:00:00 vault-server IDS[1234]: System armed and ready\n\nNote: Any trace level above 35% triggers immediate lockdown:\n- Immediate connection termination\n- IP blacklist (permanent)\n- Law enforcement notification (FBI Cyber Crime)\n- Evidence preservation (full forensics)\n- Account lockdown (requires manual reset)', 2, 'rw-r-----'),
                (17, '198.18.0.50', '/var/log/auth.log', 'auth.log', 0, 'Mar 25 09:00:00 vault-server sshd[1234]: Server listening on 0.0.0.0 port 22\nMar 25 09:00:01 vault-server sshd[1234]: Server listening on :: port 22\nMar 25 09:15:22 vault-server sshd[1245]: Failed password for vaultkeeper from 192.168.1.100\nMar 25 09:15:30 vault-server sshd[1246]: Accepted password for vaultkeeper from 192.168.1.100\nMar 25 09:15:31 vault-server sshd[1246]: pam_unix(sshd:session): session opened for user vaultkeeper\nMar 25 12:00:00 vault-server sshd[1246]: pam_unix(sshd:session): session closed for user vaultkeeper', 2, 'rw-r-----'),
                (17, '198.18.0.50', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nvaultkeeper:x:1000:1000:Vault Keeper:/home/vaultkeeper:/bin/bash\nsecurity:x:1001:1001:Security System:/home/security:/bin/bash\nbackup:x:1002:1002:Backup User:/home/backup:/bin/bash', 1, 'rw-r--r--'),
                (17, '198.18.0.50', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n198.18.0.50 vault-server\n192.0.2.150 blackmarket-broker\n\n# IDS Management\n127.0.0.1 ids.vault.local', 1, 'rw-r--r--'),
                (17, '198.18.0.50', '/etc/ssh/sshd_config', 'sshd_config', 0, 'Port 22\nProtocol 2\nPermitRootLogin no\nPubkeyAuthentication yes\nPasswordAuthentication yes\nChallengeResponseAuthentication no\nUsePAM yes\nX11Forwarding no\nPrintMotd no\nAcceptEnv LANG LC_*\nSubsystem sftp /usr/lib/openssh/sftp-server\n\n# Security hardening\nMaxAuthTries 3\nMaxSessions 2\nClientAliveInterval 300\nClientAliveCountMax 2', 1, 'rw-r--r--')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                -- Server 1: 203.0.113.200 (Headquarters - Coordinator PC)
                (18, '203.0.113.200', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '203.0.113.200', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '203.0.113.200', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '203.0.113.200', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '203.0.113.200', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '203.0.113.200', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- Coordinator home
                (18, '203.0.113.200', '/home/coordinator', 'coordinator', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '203.0.113.200', '/home/coordinator/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '203.0.113.200', '/home/coordinator/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '203.0.113.200', '/home/coordinator/Downloads', 'Downloads', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '203.0.113.200', '/home/coordinator/.bash_history', '.bash_history', 0, 'ssh eu_manager@10.50.60.70\nls -la\nexit\nssh asia_manager@172.20.30.40\nls /home/asia_manager\nexit\nping 10.50.60.70\nping 172.20.30.40', 1, 'rw-------'),
                (18, '203.0.113.200', '/home/coordinator/Desktop/regional_servers.txt', 'regional_servers.txt', 0, 'GlobalTech Corporation - Regional Server Access\n\nSeptember 2008\n\nHeadquarters: 203.0.113.200 (New York, USA)\n\n=== REGIONAL DIVISIONS ===\n\n1. European Division (Frankfurt, Germany)\n   Server IP: 10.50.60.70\n   SSH Username: eu_manager\n   SSH Password: EuroTech2008!\n   Manager: Dr. Hans Mueller\n   Department: R&D / Patents\n   Key Projects: Quantum encryption, Next-gen products\n\n2. Asian Division (Tokyo, Japan)\n   Server IP: 172.20.30.40\n   SSH Username: asia_manager\n   SSH Password: AsiaTech2008!\n   Manager: Yuki Tanaka\n   Department: Manufacturing / Supply Chain\n   Key Projects: Production optimization, Supplier management\n\nNote: Each regional server contains confidential data.\nAccess restricted to authorized personnel only.', 2, 'rw-------'),
                (18, '203.0.113.200', '/home/coordinator/Desktop/company_structure.txt', 'company_structure.txt', 0, 'GlobalTech Corporation - Organizational Structure\n\nCEO: Robert Anderson (New York HQ)\n\nRegional Divisions:\n\n1. European Division\n   Location: Frankfurt, Germany\n   Head: Dr. Hans Mueller\n   Team: 250 employees\n   Focus: Research & Development\n   Budget: €80M annually\n\n2. Asian Division\n   Location: Tokyo, Japan\n   Head: Yuki Tanaka\n   Team: 400 employees\n   Focus: Manufacturing & Production\n   Budget: ¥12B annually\n\n3. Latin America Division\n   Location: São Paulo, Brazil\n   Head: Carlos Rodriguez\n   Team: 150 employees\n   Focus: Market Expansion & Sales\n   Budget: $60M annually\n\nTotal Employees: 1,200 worldwide\nAnnual Revenue: $5.2 Billion', 2, 'rw-r--r--'),
                (18, '203.0.113.200', '/home/coordinator/Documents/quarterly_report_q3_2008.pdf', 'quarterly_report_q3_2008.pdf', 0, 'GlobalTech Corporation\nQ3 2008 Quarterly Report\n\n=== FINANCIAL SUMMARY ===\n\nRevenue:\n- Q3 2008: $1.3 Billion\n- YTD 2008: $3.9 Billion\n- Growth: +15% vs Q3 2007\n\nProfit:\n- Q3 2008: $400 Million\n- YTD 2008: $1.2 Billion\n- Margin: 30.8%\n\n=== REGIONAL PERFORMANCE ===\n\nEurope: $500M (38%)\n- Patent applications: 12 filed\n- R&D projects: 8 active\n- Technology lead: 5+ years\n\nAsia: $600M (46%)\n- Production: 45,000 units\n- Manufacturing efficiency: +8%\n- Quality rating: 99.2%\n\nAmericas: $200M (16%)\n- New markets: 3 countries\n- Customer acquisition: +25%\n- Brand awareness: 60%\n\n=== OUTLOOK ===\n\nQ4 2008 Projection: $1.5B\nFull Year 2008: $5.2B\n2009 Target: $6.5B (+25%)\n\nKey Initiatives:\n- Launch QuantumSecure Pro 2.0\n- Expand Latin America operations\n- Increase manufacturing capacity\n- Develop next-gen products', 5, 'rw-r--r--'),
                (18, '203.0.113.200', '/home/coordinator/Documents/meeting_notes_sep_2008.txt', 'meeting_notes_sep_2008.txt', 0, 'Executive Meeting Notes - September 15, 2008\n\nAttendees:\n- Robert Anderson (CEO)\n- Dr. Hans Mueller (Europe)\n- Yuki Tanaka (Asia)\n- Carlos Rodriguez (Latin America)\n\nAgenda:\n\n1. Q3 Performance Review\n   - All regions meeting targets\n   - Europe exceeding R&D goals\n   - Asia production at record levels\n   - Latin America expanding rapidly\n\n2. Q4 Strategy\n   - Launch major product upgrade\n   - Increase marketing budget\n   - Hire 100+ new employees\n   - Open 2 new offices\n\n3. Competitive Landscape\n   - TechRival losing market share\n   - Our technology lead widening\n   - Patent portfolio growing\n   - Supply chain advantage maintained\n\n4. Security Concerns\n   - Increase cybersecurity measures\n   - Competitor espionage attempts detected\n   - Implement stricter access controls\n   - Regular security audits\n\n5. 2009 Planning\n   - Target: $6.5B revenue\n   - Expand to 5 new countries\n   - Launch 3 new products\n   - Double R&D investment\n\nNext Meeting: October 15, 2008', 2, 'rw-r--r--'),
                (18, '203.0.113.200', '/home/coordinator/Downloads/vpn_client.exe', 'vpn_client.exe', 0, '[BINARY CONTENT - GlobalTech VPN Client Software]', 25, 'rw-r--r--'),
                (18, '203.0.113.200', '/opt/globaltech', 'globaltech', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '203.0.113.200', '/opt/globaltech/company_directory.txt', 'company_directory.txt', 0, 'GlobalTech Employee Directory\n\nExecutive Team:\n- CEO: Robert Anderson (r.anderson@globaltech.com)\n- CFO: Sarah Williams (s.williams@globaltech.com)\n- CTO: Michael Chen (m.chen@globaltech.com)\n\nRegional Managers:\n- Europe: Dr. Hans Mueller (h.mueller@globaltech.de)\n- Asia: Yuki Tanaka (y.tanaka@globaltech.jp)\n- LATAM: Carlos Rodriguez (c.rodriguez@globaltech.br)\n\nTotal Employees: 1,200\nLast Updated: September 2008', 1, 'rw-r--r--'),
                (18, '203.0.113.200', '/var/log/auth.log', 'auth.log', 0, 'Sep 18 09:15:22 globaltech-hq sshd[1234]: Accepted password for coordinator from 192.168.1.100\nSep 18 10:30:45 globaltech-hq sshd[1245]: SSH connection to eu_manager@10.50.60.70\nSep 18 11:45:30 globaltech-hq sshd[1256]: SSH connection to asia_manager@172.20.30.40\nSep 18 14:20:15 globaltech-hq sshd[1267]: User coordinator disconnected', 2, 'rw-r-----'),
                (18, '203.0.113.200', '/var/log/system.log', 'system.log', 0, 'Sep 18 08:00:00 globaltech-hq systemd[1]: System boot complete\nSep 18 08:05:00 globaltech-hq network[123]: Network interfaces up\nSep 18 09:00:00 globaltech-hq cron[456]: Daily backup started\nSep 18 09:30:00 globaltech-hq cron[456]: Daily backup completed', 1, 'rw-r-----'),
                (18, '203.0.113.200', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\ncoordinator:x:1000:1000:Branch Coordinator:/home/coordinator:/bin/bash\nadmin:x:1001:1001:System Admin:/home/admin:/bin/bash', 1, 'rw-r--r--'),
                (18, '203.0.113.200', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n203.0.113.200 globaltech-hq\n10.50.60.70 europe-server\n172.20.30.40 asia-server\n192.168.100.50 latam-server', 1, 'rw-r--r--'),
                -- Server 2: 10.50.60.70 (Europe Division - Frankfurt - SSH Required)
                (18, '10.50.60.70', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '10.50.60.70', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '10.50.60.70', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '10.50.60.70', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '10.50.60.70', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '10.50.60.70', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- EU Manager home
                (18, '10.50.60.70', '/home/eu_manager', 'eu_manager', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '10.50.60.70', '/home/eu_manager/Research', 'Research', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '10.50.60.70', '/home/eu_manager/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '10.50.60.70', '/home/eu_manager/Projects', 'Projects', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '10.50.60.70', '/home/eu_manager/.bash_history', '.bash_history', 0, 'cd Research\nls -la\ncat patent_app_2008_v3.pdf\ncat rd_blueprint_nextgen.dwg\ncd ../Documents\nls\nexit', 1, 'rw-------'),
                (18, '10.50.60.70', '/home/eu_manager/Research/patent_app_2008_v3.pdf', 'patent_app_2008_v3.pdf', 0, 'GlobalTech European Division - Patent Application 2008-EU-4523\n\nTitle: Advanced Quantum Encryption Method for Secure Communications\n\nInventors:\n- Dr. Hans Mueller (Lead Researcher)\n- Dr. Sophie Bernard (Cryptography Specialist)\n- Dr. Klaus Schmidt (Quantum Physics)\n\nAbstract:\nThis patent describes a revolutionary quantum encryption method that makes communications theoretically unbreakable. Using entangled photon pairs and quantum key distribution, this technology ensures:\n\n- Perfect Forward Secrecy\n- Quantum-resistant encryption\n- Real-time intrusion detection\n- Zero-knowledge architecture\n\nCommercial Applications:\n- Military communications: $500M market\n- Banking security: $2B market\n- Government systems: $800M market\n- Enterprise security: $1.5B market\n\nTotal Addressable Market: $4.8 Billion\n\nPatent Status: Pending approval (expected Q4 2008)\nCompetitor Impact: Will make current encryption obsolete\nProjected Revenue: $500M in first 3 years\n\nThis is GlobalTech''s most valuable intellectual property.', 6, 'rw-------'),
                (18, '10.50.60.70', '/home/eu_manager/Research/rd_blueprint_nextgen.dwg', 'rd_blueprint_nextgen.dwg', 0, 'GlobalTech Next-Generation Product Blueprint\n\nProject: QuantumSecure Pro 2.0\nDevelopment Timeline: 2008-2010\nBudget: €50 Million\n\n=== HARDWARE SPECIFICATIONS ===\nQuantum Processor:\n- 512 qubit capacity\n- Operating temperature: -273°C (near absolute zero)\n- Processing speed: 10^15 operations/sec\n- Power consumption: 2 MW\n\nEncryption Module:\n- AES-256 + Quantum layer\n- Key generation: True random (quantum noise)\n- Key distribution: Entangled photon pairs\n- Security level: Mathematically unbreakable\n\n=== SOFTWARE ARCHITECTURE ===\n- Operating System: QuantumOS (proprietary)\n- Encryption Layer: Multi-dimensional quantum state\n- API: RESTful + Quantum channels\n- Integration: All major platforms\n\n=== MANUFACTURING ===\nCost per unit: €50,000\nSelling price: €500,000\nProfit margin: 90%\nTarget volume: 5,000 units/year\n\nProjected Revenue: €2.5 Billion annually\n\nCompetitive Advantage: 5-10 year technology lead\n\nNote: This blueprint represents 3 years of R&D investment.', 8, 'rw-------'),
                (18, '10.50.60.70', '/home/eu_manager/Research/algorithm_documentation.pdf', 'algorithm_documentation.pdf', 0, 'Quantum Encryption Algorithm - Technical Documentation\n\n=== ALGORITHM OVERVIEW ===\n\nThe quantum encryption algorithm uses entangled photon pairs to create mathematically unbreakable encryption keys.\n\nKey Generation Process:\n1. Generate entangled photon pairs\n2. Measure quantum states\n3. Apply error correction\n4. Extract random key material\n5. Perform privacy amplification\n\nSecurity Proof:\n- Based on laws of quantum mechanics\n- Any eavesdropping disturbs quantum states\n- Detection probability: >99.9%\n- Key secrecy: Information-theoretic\n\n=== IMPLEMENTATION ===\n\nHardware Requirements:\n- Quantum photon source\n- Single-photon detectors\n- Quantum memory\n- Classical processing unit\n\nSoftware Components:\n- Quantum state preparation\n- Measurement analysis\n- Error correction codes\n- Key management system\n\n=== PERFORMANCE ===\n\nKey Generation Rate: 1 Mbps\nError Rate: <1%\nDistance: Up to 100 km (fiber optic)\nLatency: <10 ms\n\nThis algorithm represents 5+ years of research and $100M+ investment.', 5, 'rw-------'),
                (18, '10.50.60.70', '/home/eu_manager/Research/competitor_analysis.txt', 'competitor_analysis.txt', 0, 'European Market Competitive Analysis 2008\n\nMain Competitors:\n- TechRival Corp (USA): Strong but outdated tech\n- CyberSecure Ltd (UK): Good marketing, weak R&D\n- QuantumSafe AG (Switzerland): Small player\n\nOur Advantages:\n- Patent portfolio: 47 patents vs 12 average\n- R&D budget: €50M vs €10M average\n- Talent: 200 PhDs vs 30 average\n- Technology lead: 5+ years ahead\n\nMarket Share:\n- GlobalTech: 45%\n- TechRival: 25%\n- Others: 30%\n\nThreat Level: LOW\nOur technology makes competition irrelevant.', 2, 'rw-r--r--'),
                (18, '10.50.60.70', '/home/eu_manager/Documents/budget_2008.xls', 'budget_2008.xls', 0, 'European Division Budget 2008\n\nTotal Budget: €80 Million\n\nBreakdown:\n- R&D: €50M (62.5%)\n- Salaries: €20M (25%)\n- Equipment: €5M (6.25%)\n- Operations: €3M (3.75%)\n- Marketing: €2M (2.5%)\n\nKey Investments:\n- Quantum lab equipment: €10M\n- PhD researcher salaries: €8M\n- Patent filing costs: €2M\n- Conference sponsorships: €1M\n\nROI Projection:\n- Expected revenue from patents: €500M over 3 years\n- ROI: 625%', 2, 'rw-r--r--'),
                (18, '10.50.60.70', '/home/eu_manager/Documents/team_roster.txt', 'team_roster.txt', 0, 'European Division Team Roster\n\nManagement:\n- Division Head: Dr. Hans Mueller\n- Deputy: Dr. Sophie Bernard\n- Project Manager: Klaus Schmidt\n\nResearch Team (200 PhDs):\n- Quantum Physics: 80 researchers\n- Cryptography: 60 researchers\n- Software Engineering: 40 researchers\n- Hardware Engineering: 20 researchers\n\nSupport Staff (50 employees):\n- Lab technicians: 20\n- Administrative: 15\n- IT support: 10\n- Security: 5\n\nTotal: 250 employees\n\nAverage Salary: €80,000/year\nTotal Payroll: €20M/year', 1, 'rw-r--r--'),
                (18, '10.50.60.70', '/home/eu_manager/Projects/quantum_secure_pro_2.0', 'quantum_secure_pro_2.0', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '10.50.60.70', '/home/eu_manager/Projects/quantum_secure_pro_2.0/project_timeline.txt', 'project_timeline.txt', 0, 'QuantumSecure Pro 2.0 - Project Timeline\n\nPhase 1: Research (2008 Q1-Q2) - COMPLETED\n- Algorithm development\n- Security proof\n- Prototype testing\n\nPhase 2: Development (2008 Q3-Q4) - IN PROGRESS\n- Hardware design\n- Software implementation\n- Integration testing\n\nPhase 3: Production (2009 Q1-Q2)\n- Manufacturing setup\n- Quality control\n- Certification\n\nPhase 4: Launch (2009 Q3)\n- Marketing campaign\n- Sales training\n- Customer deployment\n\nTotal Investment: €50M\nExpected Revenue: €2.5B/year\nPayback Period: 2 months', 1, 'rw-r--r--'),
                (18, '10.50.60.70', '/opt/research_tools', 'research_tools', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '10.50.60.70', '/opt/research_tools/quantum_simulator.exe', 'quantum_simulator.exe', 0, '[BINARY CONTENT - Proprietary quantum encryption simulator]', 50, 'rwxr-xr-x'),
                (18, '10.50.60.70', '/var/log/auth.log', 'auth.log', 0, 'Sep 18 10:30:45 europe-server sshd[1234]: Accepted password for eu_manager from 203.0.113.200\nSep 18 10:35:00 europe-server sshd[1234]: pam_unix(sshd:session): session opened for user eu_manager\nSep 18 15:00:00 europe-server sshd[1234]: pam_unix(sshd:session): session closed for user eu_manager', 1, 'rw-r-----'),
                (18, '10.50.60.70', '/var/log/access.log', 'access.log', 0, 'Sep 18 10:30:00 europe-server: File accessed: /home/eu_manager/Research/patent_app_2008_v3.pdf\nSep 18 10:35:00 europe-server: File accessed: /home/eu_manager/Research/rd_blueprint_nextgen.dwg\nSep 18 11:00:00 europe-server: File accessed: /home/eu_manager/Documents/budget_2008.xls', 1, 'rw-r-----'),
                (18, '10.50.60.70', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\neu_manager:x:1000:1000:EU Manager:/home/eu_manager:/bin/bash\nresearcher:x:1001:1001:Researcher:/home/researcher:/bin/bash', 1, 'rw-r--r--'),
                (18, '10.50.60.70', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n10.50.60.70 europe-server\n203.0.113.200 globaltech-hq', 1, 'rw-r--r--'),
                -- Server 3: 172.20.30.40 (Asia Division - Tokyo - SSH Required)
                (18, '172.20.30.40', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '172.20.30.40', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '172.20.30.40', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '172.20.30.40', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '172.20.30.40', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '172.20.30.40', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- Asia Manager home
                (18, '172.20.30.40', '/home/asia_manager', 'asia_manager', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '172.20.30.40', '/home/asia_manager/Manufacturing', 'Manufacturing', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '172.20.30.40', '/home/asia_manager/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '172.20.30.40', '/home/asia_manager/Suppliers', 'Suppliers', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '172.20.30.40', '/home/asia_manager/.bash_history', '.bash_history', 0, 'cd Manufacturing\nls -la\ncat production_process.pdf\ncat supplier_contracts.xls\ncd ../Documents\nls\nexit', 1, 'rw-------'),
                (18, '172.20.30.40', '/home/asia_manager/Manufacturing/production_process.pdf', 'production_process.pdf', 0, 'GlobalTech Asia Division - Manufacturing Process Documentation\n\nQuantumSecure Production Line - Tokyo Facility\n\n=== PRODUCTION STAGES ===\n\nStage 1: Quantum Chip Fabrication\n- Location: Clean room (Class 1)\n- Process: 7nm lithography\n- Yield: 87% (industry best)\n- Capacity: 10,000 chips/month\n- Cost: $500/chip\n\nStage 2: Cryogenic Assembly\n- Temperature control: ±0.001°C\n- Assembly time: 4 hours/unit\n- Defect rate: 0.8% (lowest in industry)\n- Proprietary cooling system (patent pending)\n\nStage 3: Quantum State Calibration\n- Precision: 99.999%\n- Calibration time: 2 hours/unit\n- Equipment: Custom quantum analyzer ($5M each)\n- Process: Trade secret (NOT patented to keep secret)\n\nStage 4: Quality Control\n- Testing: 48-hour burn-in\n- Quantum state verification\n- Security audit\n- Final certification\n\n=== COST BREAKDOWN ===\nMaterials: $15,000\nLabor: $8,000\nEnergy: $5,000\nOverhead: $2,000\nTotal: $30,000/unit\n\nSelling Price: $500,000\nGross Margin: $470,000 (94%)\n\n=== SECRET SAUCE ===\nOur cryogenic assembly process is 10x more efficient than competitors.\nThis gives us a 5-year manufacturing advantage.\n\nNote: DO NOT share this document. Competitors would kill for this info.', 7, 'rw-------'),
                (18, '172.20.30.40', '/home/asia_manager/Manufacturing/supplier_contracts.xls', 'supplier_contracts.xls', 0, 'GlobalTech Asia Division - Supplier Contracts 2008-2010\n\n=== KEY SUPPLIERS ===\n\n1. Tokyo Quantum Materials Inc.\n   Supply: Quantum processors\n   Contract Value: ¥5 Billion ($50M)\n   Terms: Exclusive 5-year contract\n   Discount: 40% below market rate\n   Why: Early investment in their startup\n\n2. Osaka Cryogenics Ltd.\n   Supply: Cooling systems  \n   Contract Value: ¥3 Billion ($30M)\n   Terms: Exclusive 3-year contract\n   Discount: 35% below market\n   Why: Joint R&D partnership\n\n3. Korean Semiconductor Corp.\n   Supply: Circuit boards\n   Contract Value: $20M\n   Terms: Non-exclusive\n   Discount: 25% volume discount\n\n4. Taiwan Precision Manufacturing\n   Supply: Assembly components\n   Contract Value: $15M\n   Terms: Preferred partner status\n   Discount: 30% below market\n\n=== COMPETITIVE ADVANTAGE ===\nOur supplier relationships give us:\n- 35% lower manufacturing costs\n- Guaranteed supply chain\n- First access to new technologies\n- Joint IP development\n\nTotal Savings: $40M annually\n\nCompetitors pay market rates and have supply issues.\nThis is a HUGE strategic advantage.\n\nNote: These contracts are confidential. Revealing terms would help competitors.', 5, 'rw-------'),
                (18, '172.20.30.40', '/home/asia_manager/Manufacturing/production_schedule.txt', 'production_schedule.txt', 0, 'Q3-Q4 2008 Production Schedule\n\nSeptember: 8,000 units\nOctober: 10,000 units\nNovember: 12,000 units\nDecember: 15,000 units\n\nTotal Q3-Q4: 45,000 units\nRevenue: $22.5 Billion\n\nNote: Ramping up for holiday season demand.', 1, 'rw-r--r--'),
                (18, '172.20.30.40', '/home/asia_manager/Manufacturing/quality_metrics.txt', 'quality_metrics.txt', 0, 'Quality Control Metrics - Q3 2008\n\nProduction Quality:\n- Defect Rate: 0.8% (Industry avg: 3-5%)\n- First-Pass Yield: 99.2%\n- Customer Returns: 0.1%\n- Warranty Claims: 0.05%\n\nProcess Efficiency:\n- Production Time: 6.5 hours/unit\n- Setup Time: 15 minutes\n- Downtime: <1%\n- OEE (Overall Equipment Effectiveness): 94%\n\nCertifications:\n- ISO 9001:2008 (Quality Management)\n- ISO 14001:2004 (Environmental)\n- OHSAS 18001 (Occupational Health & Safety)\n\nAwards:\n- Best Manufacturing Process 2008 (Industry Association)\n- Quality Excellence Award (Japanese Ministry)\n\nOur quality metrics are 3-5x better than competitors.', 2, 'rw-r--r--'),
                (18, '172.20.30.40', '/home/asia_manager/Documents/latam_server_access.txt', 'latam_server_access.txt', 0, 'Latin America Division - Server Access Information\n\nFor coordination with LATAM operations:\n\nLatin America Division (São Paulo, Brazil)\nServer IP: 192.168.100.50\nSSH Username: latam_manager\nSSH Password: LatamTech2008!\nManager: Carlos Rodriguez\nDepartment: Market Expansion & Sales\n\nNote: LATAM server contains market expansion plans and financial projections.\nAccess restricted to regional managers only.', 1, 'rw-------'),
                (18, '172.20.30.40', '/home/asia_manager/Documents/facility_report.pdf', 'facility_report.pdf', 0, 'Tokyo Manufacturing Facility Report - September 2008\n\nFacility Overview:\n- Location: Tokyo, Shinagawa Ward\n- Size: 50,000 square meters\n- Employees: 400 workers\n- Shifts: 3 (24/7 operation)\n\nProduction Capacity:\n- Current: 10,000 units/month\n- Maximum: 15,000 units/month\n- Utilization: 67%\n- Expansion planned: Q1 2009\n\nEquipment:\n- Clean rooms: 10 (Class 1)\n- Production lines: 5\n- Testing stations: 20\n- Quality labs: 3\n\nInvestment:\n- Facility construction: $200M\n- Equipment: $150M\n- Total: $350M\n\nROI: 8 months (already achieved)', 3, 'rw-r--r--'),
                (18, '172.20.30.40', '/home/asia_manager/Suppliers/supplier_directory.txt', 'supplier_directory.txt', 0, 'Supplier Directory - Asia Division\n\nPrimary Suppliers:\n1. Tokyo Quantum Materials (Japan)\n2. Osaka Cryogenics (Japan)\n3. Korean Semiconductor Corp (South Korea)\n4. Taiwan Precision Mfg (Taiwan)\n\nSecondary Suppliers:\n5. Singapore Electronics (Singapore)\n6. Chinese Rare Earth Co (China)\n7. Vietnam Assembly (Vietnam)\n8. Thailand Logistics (Thailand)\n\nTotal Suppliers: 23\nExclusive Contracts: 4\nPreferred Partners: 8\n\nSupply Chain Strength: EXCELLENT', 1, 'rw-r--r--'),
                (18, '172.20.30.40', '/opt/production_software', 'production_software', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '172.20.30.40', '/opt/production_software/mes_system.exe', 'mes_system.exe', 0, '[BINARY CONTENT - Manufacturing Execution System]', 40, 'rwxr-xr-x'),
                (18, '172.20.30.40', '/var/log/auth.log', 'auth.log', 0, 'Sep 18 11:45:30 asia-server sshd[1234]: Accepted password for asia_manager from 203.0.113.200\nSep 18 11:50:00 asia-server sshd[1234]: pam_unix(sshd:session): session opened for user asia_manager\nSep 18 16:00:00 asia-server sshd[1234]: pam_unix(sshd:session): session closed for user asia_manager', 1, 'rw-r-----'),
                (18, '172.20.30.40', '/var/log/production.log', 'production.log', 0, 'Sep 18 08:00:00 asia-server: Production shift 1 started\nSep 18 08:00:00 asia-server: Line 1-5 operational\nSep 18 12:00:00 asia-server: Daily production: 340 units\nSep 18 16:00:00 asia-server: Production shift 2 started', 1, 'rw-r-----'),
                (18, '172.20.30.40', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nasia_manager:x:1000:1000:Asia Manager:/home/asia_manager:/bin/bash\nproduction:x:1001:1001:Production:/home/production:/bin/bash', 1, 'rw-r--r--'),
                (18, '172.20.30.40', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n172.20.30.40 asia-server\n203.0.113.200 globaltech-hq\n192.168.100.50 latam-server', 1, 'rw-r--r--'),
                -- Server 4: 192.168.100.50 (Latin America Division - São Paulo - SSH Required)
                (18, '192.168.100.50', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '192.168.100.50', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '192.168.100.50', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '192.168.100.50', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '192.168.100.50', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '192.168.100.50', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- LATAM Manager home
                (18, '192.168.100.50', '/home/latam_manager', 'latam_manager', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '192.168.100.50', '/home/latam_manager/Strategy', 'Strategy', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '192.168.100.50', '/home/latam_manager/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '192.168.100.50', '/home/latam_manager/Financials', 'Financials', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '192.168.100.50', '/home/latam_manager/.bash_history', '.bash_history', 0, 'cd Strategy\nls -la\ncat latam_expansion_2009.pdf\ncat financial_projections_2009.xls\ncd ../Financials\nls\nexit', 1, 'rw-------'),
                (18, '192.168.100.50', '/home/latam_manager/Strategy/latam_expansion_2009.pdf', 'latam_expansion_2009.pdf', 0, 'GlobalTech Latin America Expansion Plan 2009-2011\n\nEXECUTIVE SUMMARY\nLatin America represents the next major growth opportunity for GlobalTech.\nMarket analysis shows 300% growth potential over 3 years.\n\n=== MARKET OPPORTUNITY ===\n\nTarget Countries:\n1. Brazil - $500M market (35% of LATAM)\n2. Mexico - $300M market (21% of LATAM)\n3. Argentina - $200M market (14% of LATAM)\n4. Chile - $150M market (11% of LATAM)\n5. Colombia - $100M market (7% of LATAM)\n\nTotal Addressable Market: $1.25 Billion\nOur Target: $400M (32% share) by 2011\n\n=== EXPANSION STRATEGY ===\n\nPhase 1 (Q1-Q2 2009): Brazil\n- Open São Paulo office\n- Hire 50 employees\n- Investment: $20M\n- Expected Revenue: $100M\n\nPhase 2 (Q3-Q4 2009): Mexico\n- Open Mexico City office\n- Hire 30 employees\n- Investment: $15M\n- Expected Revenue: $60M\n\nPhase 3 (2010): Argentina, Chile\n- Open Buenos Aires & Santiago offices\n- Hire 40 employees\n- Investment: $20M\n- Expected Revenue: $120M\n\nPhase 4 (2011): Colombia & others\n- Open Bogotá office\n- Hire 20 employees\n- Investment: $10M\n- Expected Revenue: $120M\n\nTOTAL INVESTMENT: $65M\nTOTAL EXPECTED REVENUE (2011): $400M\nROI: 6.2x over 3 years\n\n=== COMPETITIVE ANALYSIS ===\n\nCurrent Market Leaders:\n1. QuantumSafe Inc. - 25% share (weak in Brazil)\n2. SecureNet Corp. - 20% share (expensive)\n3. CryptoTech Ltd. - 15% share (old technology)\n\nOUR ADVANTAGES:\n- Superior technology (5 years ahead)\n- Lower prices (40% below competition)\n- Strong Asian manufacturing base\n- Proven track record in Europe\n\nWe can dominate this market quickly.\n\n=== PARTNERSHIP STRATEGY ===\n\nLocal Partners:\n- Banco do Brasil (Financial sector)\n- Petrobras (Energy sector)\n- Vale (Mining sector)\n- América Móvil (Telecom sector)\n\nGovernment Relations:\n- Brazilian Ministry of Technology\n- Mexican Secretary of Economy\n- Chile CORFO (Economic Development)\n\nThese partnerships will accelerate market entry.', 12, 'rw-------'),
                (18, '192.168.100.50', '/home/latam_manager/Strategy/financial_projections_2009.xls', 'financial_projections_2009.xls', 0, 'GlobalTech LATAM - Financial Projections 2009-2011\n\n=== REVENUE PROJECTIONS ===\n\n2009:\nQ1: $20M\nQ2: $35M\nQ3: $50M\nQ4: $75M\nTotal 2009: $180M\n\n2010:\nQ1: $85M\nQ2: $95M\nQ3: $110M\nQ4: $130M\nTotal 2010: $420M\n\n2011:\nQ1: $140M\nQ2: $155M\nQ3: $170M\nQ4: $185M\nTotal 2011: $650M\n\n3-YEAR TOTAL: $1.25 Billion\n\n=== COST STRUCTURE ===\n\nFixed Costs:\n- Salaries: $8M/year\n- Office rent: $2M/year\n- Operations: $3M/year\nTotal Fixed: $13M/year\n\nVariable Costs:\n- Cost of Goods: 30% of revenue\n- Marketing: 10% of revenue\n- Sales commission: 5% of revenue\nTotal Variable: 45% of revenue\n\n=== PROFITABILITY ===\n\n2009:\nRevenue: $180M\nCosts: $94M (fixed $13M + variable $81M)\nProfit: $86M\nMargin: 48%\n\n2010:\nRevenue: $420M\nCosts: $202M (fixed $13M + variable $189M)\nProfit: $218M\nMargin: 52%\n\n2011:\nRevenue: $650M\nCosts: $306M (fixed $13M + variable $293M)\nProfit: $344M\nMargin: 53%\n\n3-YEAR PROFIT: $648M\n\nInvestment: $65M\nNet Profit: $583M\nROI: 897%\n\nThis is an INCREDIBLE opportunity.', 8, 'rw-------'),
                (18, '192.168.100.50', '/home/latam_manager/Strategy/competitor_strategy.txt', 'competitor_strategy.txt', 0, 'Competitor Analysis - Latin America Market\n\n=== QUANTUMSAFE INC ===\nMarket Share: 25%\nStrengths:\n- Established presence in Mexico\n- Government contracts\n- Brand recognition\n\nWeaknesses:\n- Weak in Brazil (our main target)\n- Expensive ($800K per unit vs our $500K)\n- Old technology (2005 generation)\n- Poor customer service\n\nOUR STRATEGY:\n- Undercut on price (40% cheaper)\n- Offer superior technology\n- Target Brazil aggressively\n- Steal their customers with better service\n\n=== SECURENET CORP ===\nMarket Share: 20%\nStrengths:\n- Strong in Chile\n- Good technology\n- Financial stability\n\nWeaknesses:\n- Very expensive ($900K per unit)\n- Slow to innovate\n- Poor marketing\n- No manufacturing in region\n\nOUR STRATEGY:\n- Price advantage (45% cheaper)\n- Faster delivery (Asia manufacturing)\n- Better marketing\n- Target their enterprise customers\n\n=== CRYPTOTECH LTD ===\nMarket Share: 15%\nStrengths:\n- Low prices ($400K per unit)\n- Wide distribution\n\nWeaknesses:\n- Inferior technology (2004 generation)\n- Quality issues\n- No innovation\n- Weak brand\n\nOUR STRATEGY:\n- Compete on technology superiority\n- Highlight their quality problems\n- Position as premium alternative\n\nCOMBINED STRATEGY:\nWe can take 32% market share by:\n1. Stealing 50% of QuantumSafe customers (Brazil focus)\n2. Stealing 30% of SecureNet customers (price/tech)\n3. Converting 20% of CryptoTech customers (quality)\n4. Capturing 70% of new market growth\n\nThis gives us market leadership by 2011.', 4, 'rw-------'),
                (18, '192.168.100.50', '/home/latam_manager/Strategy/acquisition_targets.txt', 'acquisition_targets.txt', 0, 'Potential Acquisition Targets - LATAM\n\n1. BrasilCrypto S.A. (Brazil)\n   Revenue: $15M\n   Valuation: $50M\n   Why: Established customer base in Brazil\n   Status: In discussions\n   Recommendation: ACQUIRE - accelerates Brazil entry\n\n2. MexiSec Technologies (Mexico)\n   Revenue: $8M\n   Valuation: $25M\n   Why: Government contracts\n   Status: Interested\n   Recommendation: CONSIDER - good political connections\n\n3. ArgentinaSecure (Argentina)\n   Revenue: $5M\n   Valuation: $15M\n   Why: Local expertise\n   Status: Not approached yet\n   Recommendation: LOW PRIORITY - can build organically\n\nTotal Acquisition Budget: $100M available\n\nRecommendation: Acquire BrasilCrypto, skip others.', 2, 'rw-r--r--'),
                (18, '192.168.100.50', '/home/latam_manager/Documents/partnership_agreements.pdf', 'partnership_agreements.pdf', 0, 'Partnership Agreements - LATAM Division\n\n=== BANCO DO BRASIL ===\nType: Technology Partnership\nValue: $50M (3-year contract)\nScope: Quantum encryption for all branches\nStatus: Signed September 2008\nDeployment: Q1 2009\n\nThis is our anchor customer in Brazil.\nProves our technology to other banks.\n\n=== PETROBRAS ===\nType: Strategic Partnership\nValue: $35M (5-year contract)\nScope: Secure communications for offshore rigs\nStatus: Signed August 2008\nDeployment: Q2 2009\n\nMajor win. Petrobras is Brazil most important company.\n\n=== AMÉRICA MÓVIL ===\nType: Distribution Partnership\nValue: Potential $100M\nScope: Sell our products through their channels\nStatus: Negotiating\nTarget: Sign by December 2008\n\nCarlos Slim company. Huge distribution network.\n\n=== VALE S.A. ===\nType: Technology Partnership\nValue: $20M (3-year contract)\nScope: Secure data for mining operations\nStatus: Letter of Intent signed\nTarget: Final contract October 2008\n\nTotal Partnership Value: $205M\n\nThese partnerships establish us as THE security provider in LATAM.', 5, 'rw-------'),
                (18, '192.168.100.50', '/home/latam_manager/Documents/team_roster.txt', 'team_roster.txt', 0, 'LATAM Division Team - September 2008\n\nLeadership:\n- Carlos Rodriguez (Regional Director)\n- Maria Silva (VP Sales)\n- João Santos (VP Operations)\n\nSales Team: 15 people\nSupport Team: 8 people\nOperations: 12 people\n\nTotal Employees: 38\nTarget (2009): 90 employees\n\nOffice: São Paulo, Avenida Paulista\nSize: 2,000 sq meters', 1, 'rw-r--r--'),
                (18, '192.168.100.50', '/home/latam_manager/Financials/budget_2009.xls', 'budget_2009.xls', 0, 'LATAM Division Budget 2009\n\n=== EXPENSES ===\n\nPersonnel: $8,500,000\n- Salaries: $6,000,000\n- Benefits: $1,500,000\n- Training: $500,000\n- Bonuses: $500,000\n\nOperations: $3,200,000\n- Office rent: $1,200,000\n- IT infrastructure: $800,000\n- Utilities: $400,000\n- Supplies: $400,000\n- Travel: $400,000\n\nMarketing: $18,000,000\n- Advertising: $8,000,000\n- Events: $4,000,000\n- PR: $2,000,000\n- Partnerships: $4,000,000\n\nSales: $9,000,000\n- Commissions: $7,000,000\n- Sales operations: $2,000,000\n\nTOTAL EXPENSES: $38,700,000\n\n=== REVENUE TARGET ===\nTarget Revenue: $180,000,000\n\n=== PROFITABILITY ===\nGross Profit: $141,300,000\nMargin: 78%\n\nNote: Very high profitability due to low manufacturing costs (Asia).', 5, 'rw-------'),
                (18, '192.168.100.50', '/home/latam_manager/Financials/investment_report.txt', 'investment_report.txt', 0, 'LATAM Investment Report - September 2008\n\n=== INVESTMENT TO DATE ===\n\nPhase 1 (Q1-Q3 2008):\n- Office setup: $5M\n- Team hiring: $2M\n- Marketing launch: $3M\n- Legal/regulatory: $1M\nTotal Phase 1: $11M\n\n=== PLANNED INVESTMENT ===\n\nQ4 2008: $4M\n- Marketing ramp-up\n- Team expansion\n\n2009: $25M\n- Mexico office: $8M\n- Operations scale: $10M\n- Marketing: $7M\n\n2010-2011: $25M\n- Additional offices\n- Team growth\n- Infrastructure\n\nTOTAL PLANNED: $65M\n\n=== RETURNS ===\n\nExpected 3-year revenue: $1.25 Billion\nExpected 3-year profit: $648M\nROI: 997%\n\nInvestment approved by board July 2008.', 3, 'rw-r--r--'),
                (18, '192.168.100.50', '/opt/crm_system', 'crm_system', 1, NULL, 0, 'drwxr-xr-x'),
                (18, '192.168.100.50', '/opt/crm_system/salesforce.exe', 'salesforce.exe', 0, '[BINARY CONTENT - CRM System]', 35, 'rwxr-xr-x'),
                (18, '192.168.100.50', '/var/log/auth.log', 'auth.log', 0, 'Sep 18 14:20:00 latam-server sshd[5678]: Accepted password for latam_manager from 172.20.30.40\nSep 18 14:25:00 latam-server sshd[5678]: pam_unix(sshd:session): session opened for user latam_manager\nSep 18 18:00:00 latam-server sshd[5678]: pam_unix(sshd:session): session closed for user latam_manager', 1, 'rw-r-----'),
                (18, '192.168.100.50', '/var/log/access.log', 'access.log', 0, 'Sep 18 14:25:30 latam-server: latam_manager accessed /home/latam_manager/Strategy\nSep 18 14:30:00 latam-server: latam_manager accessed /home/latam_manager/Financials\nSep 18 15:00:00 latam-server: latam_manager accessed /home/latam_manager/Documents', 1, 'rw-r-----'),
                (18, '192.168.100.50', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nlatam_manager:x:1000:1000:LATAM Manager:/home/latam_manager:/bin/bash\nsales:x:1001:1001:Sales:/home/sales:/bin/bash', 1, 'rw-r--r--'),
                (18, '192.168.100.50', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n192.168.100.50 latam-server\n203.0.113.200 globaltech-hq\n172.20.30.40 asia-server', 1, 'rw-r--r--')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                -- Server 1: 198.18.5.100 (Forensics Lab - Initial Access)
                (19, '198.18.5.100', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '198.18.5.100', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '198.18.5.100', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '198.18.5.100', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '198.18.5.100', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),
                (19, '198.18.5.100', '/home/investigator', 'investigator', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '198.18.5.100', '/home/investigator/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '198.18.5.100', '/home/investigator/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '198.18.5.100', '/home/investigator/.bash_history', '.bash_history', 0, 'ls -la\ncd Documents\ncat evidence_server_access.txt\nssh criminal@10.25.35.45\nexit', 1, 'rw-------'),
                (19, '198.18.5.100', '/home/investigator/Documents/evidence_server_access.txt', 'evidence_server_access.txt', 0, 'Evidence Server Access - Case #2009-047\n\nAPRIL 2009\n\nEvidence Server: 10.25.35.45\nSSH Username: criminal\nSSH Password: CriminalPass2009\n\nNote: This server contains evidence logs for active criminal investigation.\nAccess restricted to authorized forensics personnel only.', 1, 'rw-------'),
                (19, '198.18.5.100', '/home/investigator/Documents/case_notes.txt', 'case_notes.txt', 0, 'Case #2009-047 Investigation Notes\n\nSuspect: Corporate executive\nCharges: Tax evasion, bribery, securities fraud\n\nEvidence Collection Status:\n- Financial records: COMPLETE\n- Email communications: COMPLETE\n- Transaction logs: COMPLETE\n\nProsecution probability: 95%\nCourt date: June 15, 2009\n\nAll evidence stored on secure server (10.25.35.45)', 1, 'rw-r--r--'),
                (19, '198.18.5.100', '/home/investigator/Desktop/lab_procedures.pdf', 'lab_procedures.pdf', 0, 'Digital Forensics Lab - Standard Operating Procedures\n\nEvidence Handling:\n1. Maintain chain of custody at all times\n2. Generate cryptographic hashes for all evidence\n3. Store evidence on secure server\n4. Regular backups mandatory\n5. Access logs required\n\nSecurity:\n- All servers require SSH authentication\n- Two-factor authentication for critical systems\n- Evidence tampering = federal crime\n\nLab Manager: Dr. Sarah Mitchell\nContact: s.mitchell@forensicslab.gov', 2, 'rw-r--r--'),
                (19, '198.18.5.100', '/var/log/system.log', 'system.log', 0, 'Apr 15 08:00:00 forensics-lab systemd[1]: System started\nApr 15 09:30:00 forensics-lab sshd[1234]: SSH connection to 10.25.35.45\nApr 15 10:45:00 forensics-lab sshd[1234]: User investigator disconnected\nApr 15 14:20:00 forensics-lab cron[456]: Daily backup completed', 1, 'rw-r-----'),
                (19, '198.18.5.100', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\ninvestigator:x:1000:1000:Investigator:/home/investigator:/bin/bash', 1, 'rw-r--r--'),
                (19, '198.18.5.100', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n198.18.5.100 forensics-lab\n10.25.35.45 evidence-server', 1, 'rw-r--r--'),

                -- Server 2: 10.25.35.45 (Evidence Server - SSH Required)
                (19, '10.25.35.45', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),
                (19, '10.25.35.45', '/root', 'root', 1, NULL, 0, 'drwx------'),

                -- Criminal home directory
                (19, '10.25.35.45', '/home/criminal', 'criminal', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/home/criminal/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/home/criminal/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/home/criminal/case_files', 'case_files', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/home/criminal/case_files/evidence', 'evidence', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/home/criminal/case_files/backups', 'backups', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/home/criminal/.bash_history', '.bash_history', 0, 'ls -la\ncat files_to_corrupt.txt\ncd case_files\nls /var/log\nexit', 1, 'rw-------'),
                (19, '10.25.35.45', '/home/criminal/files_to_corrupt.txt', 'files_to_corrupt.txt', 0, 'EVIDENCE.LOG\nEVIDENCE.LOG\nEVIDENCE.LOG\nTRANSACTION_LOG.TXT\nTRANSACTION_LOG.TXT\nTRANSACTION_LOG.TXT\nEMAIL_LOG.TXT\nEMAIL_LOG.TXT\nEMAIL_LOG.TXT', 1, 'rw-r--r--'),
                (19, '10.25.35.45', '/home/criminal/Desktop/notes.txt', 'notes.txt', 0, 'Personal Notes - April 2009\n\nReminder: Court date June 15, 2009\nLawyer: John Mitchell (555-0123)\n\nDefense strategy:\n- Challenge evidence chain of custody\n- Question search warrant validity\n- Suppress financial records if possible\n\nMeeting with lawyer tomorrow at 2 PM', 1, 'rw-r--r--'),
                (19, '10.25.35.45', '/home/criminal/Desktop/contacts.txt', 'contacts.txt', 0, 'Important Contacts\n\nLawyer: John Mitchell (555-0123)\nAccountant: Sarah Chen (555-0456)\nBusiness Partner: David Wilson (555-0789)\n\nOffshore Bank: +1-345-555-1000\nAccount Manager: Robert Taylor', 1, 'rw-r--r--'),
                (19, '10.25.35.45', '/home/criminal/Documents/financial_summary.txt', 'financial_summary.txt', 0, 'Financial Summary 2008-2009\n\nLegitimate Business Income: $1.2M\nOffshore Holdings: $5.6M (UNDER INVESTIGATION)\n\nAssets:\n- Property: $2.5M\n- Vehicles: $500K\n- Investments: $3.8M\n\nLiabilities:\n- Mortgage: $800K\n- Business Loans: $300K\n\nNet Worth: $10.6M', 2, 'rw-r--r--'),
                (19, '10.25.35.45', '/home/criminal/Documents/tax_returns_2008.pdf', 'tax_returns_2008.pdf', 0, 'TAX RETURN 2008\n\nReported Income: $1.2M\nDeductions: $400K\nTaxable Income: $800K\nTax Paid: $280K\n\nNote: Offshore income NOT reported\n(This is what they are investigating)', 3, 'rw-r--r--'),

                -- Case files - Deep structure
                (19, '10.25.35.45', '/home/criminal/case_files/evidence/transaction_log.txt', 'transaction_log.txt', 0, 'Financial Transaction Log\n\n2008-12-10: $2.5M wire transfer\n- Offshore tax haven\n- Evidence: Bank statements\n\n2009-01-22: $500K cash payment\n- Government official bribery\n- Evidence: Surveillance photos\n\n2009-02-05: $1.8M securities fraud\n- Insider trading\n- Evidence: Trading records\n\nTOTAL ILLEGAL: $5.6M\nEVIDENCE STATUS: Complete\nPROSECUTION PROBABILITY: 95%', 3, 'rw-r-----'),
                (19, '10.25.35.45', '/home/criminal/case_files/evidence/email_log.txt', 'email_log.txt', 0, 'Email Evidence Log\n\n47 incriminating emails collected\n\nEMAIL #1: Tax evasion planning\nEMAIL #2: Bribery arrangement\nEMAIL #3: Insider trading coordination\n\nAll emails AUTHENTICATED\nMetadata VERIFIED\nChain of custody INTACT\n\nProsecution value: EXTREMELY HIGH', 3, 'rw-r-----'),
                (19, '10.25.35.45', '/home/criminal/case_files/evidence/bank_statements.pdf', 'bank_statements.pdf', 0, 'CONFIDENTIAL BANK STATEMENTS\n\nCayman Islands Bank Account #8472935\n\nDecember 2008 Deposits:\n- Wire transfer: $2,500,000\n- Source: Corporate shell company\n\nJanuary 2009 Withdrawals:\n- Cash: $500,000 (Bribery payment)\n\nFebruary 2009 Deposits:\n- Securities trading: $1,800,000\n\nTotal Balance: $5,600,000', 4, 'rw-r-----'),
                (19, '10.25.35.45', '/home/criminal/case_files/evidence/surveillance_photos.txt', 'surveillance_photos.txt', 0, 'Surveillance Photo Evidence\n\n47 photos collected by FBI\n\nPhoto #1: Meeting with government official\nPhoto #2: Cash handoff at restaurant\nPhoto #3: Entering offshore bank building\nPhoto #4-10: Multiple meetings with co-conspirators\n\nAll photos timestamped and GPS-tagged\nQuality: HIGH RESOLUTION\nAuthenticity: VERIFIED', 2, 'rw-r-----'),
                (19, '10.25.35.45', '/home/criminal/case_files/backups/evidence_backup_2009.tar.gz', 'evidence_backup_2009.tar.gz', 0, '[COMPRESSED ARCHIVE - Evidence Backup]', 15, 'rw-r-----'),
                (19, '10.25.35.45', '/home/criminal/case_files/case_timeline.txt', 'case_timeline.txt', 0, 'Case #2009-047 Timeline\n\n2008-12-10: Initial offshore transfer detected\n2009-01-15: FBI surveillance begins\n2009-01-22: Bribery incident recorded\n2009-02-05: Securities fraud documented\n2009-03-10: Search warrant executed\n2009-03-15: Evidence collected and cataloged\n2009-04-01: Charges filed\n2009-06-15: Trial date set\n\nProsecution: Strong case\nDefense: Challenging evidence chain', 2, 'rw-r--r--'),
                (19, '10.25.35.45', '/home/criminal/case_files/prosecution_summary.txt', 'prosecution_summary.txt', 0, 'Prosecution Summary - Case #2009-047\n\nCharges:\n1. Tax Evasion (5 years, $250K fine)\n2. Bribery of Government Official (10 years, $500K fine)\n3. Securities Fraud (20 years, $5M fine)\n\nTotal Potential Sentence: 35 years\nTotal Potential Fines: $5.75M\n\nEvidence Strength: VERY STRONG\nConviction Probability: 95%\n\nKey Evidence:\n- Financial records (irrefutable)\n- Email communications (authenticated)\n- Surveillance photos (timestamped)\n- Transaction logs (verified)', 3, 'rw-r--r--'),

                -- System directories
                (19, '10.25.35.45', '/var/log', 'log', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/var/log/evidence.log', 'evidence.log', 0, 'EVIDENCE LOG - Case #EXT-2009-047\nChain of Custody Record\nHash: SHA256:a8f5f167f44f4964e6c998dee827110c\nChecksum: MD5:3e25960a79dbc69b674cd4ec67a72c62\n\nDate: 2008-12-10\nTransaction: Wire transfer $2.5M offshore\nEvidence: Tax evasion\n\nDate: 2009-01-22\nTransaction: Cash payment $500K\nEvidence: Bribery of government official\n\nDate: 2009-02-05\nTransaction: Securities fraud $1.8M\nEvidence: Insider trading\n\nStatus: VERIFIED - Evidence admissible\nCourt Date: 2009-06-15', 4, 'rw-r-----'),
                (19, '10.25.35.45', '/var/log/auth.log', 'auth.log', 0, 'Apr 15 09:30:00 evidence-server sshd[2345]: Accepted password for criminal from 198.18.5.100\nApr 15 09:30:30 evidence-server sshd[2345]: pam_unix(sshd:session): session opened for user criminal\nApr 15 10:45:00 evidence-server sshd[2345]: pam_unix(sshd:session): session closed for user criminal', 1, 'rw-r-----'),
                (19, '10.25.35.45', '/var/log/system.log', 'system.log', 0, 'Apr 15 08:00:00 evidence-server systemd[1]: System started\nApr 15 08:05:00 evidence-server network[123]: Network interfaces up\nApr 15 09:00:00 evidence-server cron[456]: Evidence backup started\nApr 15 09:15:00 evidence-server cron[456]: Evidence backup completed', 1, 'rw-r-----'),
                (19, '10.25.35.45', '/var/log/forensics.log', 'forensics.log', 0, 'Digital Forensics Activity Log\n\nMar 15 10:00:00: Evidence collection started\nMar 15 10:30:00: Hard drive imaging completed\nMar 15 11:00:00: File system analysis completed\nMar 15 12:00:00: Evidence cataloging completed\nMar 15 13:00:00: Cryptographic hashes generated\nMar 15 14:00:00: Chain of custody documentation completed\n\nTotal Evidence Files: 156\nTotal Size: 4.7 GB\nIntegrity: VERIFIED', 2, 'rw-r-----'),
                (19, '10.25.35.45', '/opt/forensics_tools', 'forensics_tools', 1, NULL, 0, 'drwxr-xr-x'),
                (19, '10.25.35.45', '/opt/forensics_tools/hash_verifier.sh', 'hash_verifier.sh', 0, '#!/bin/bash\n# Evidence Hash Verification Tool\n# Verifies SHA256 hashes for all evidence files\n\necho \"Starting hash verification...\"\nfind /home/criminal/case_files -type f -exec sha256sum {} \\;\necho \"Verification complete\"', 1, 'rwxr-xr-x'),
                (19, '10.25.35.45', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\ncriminal:x:1000:1000:Criminal:/home/criminal:/bin/bash\nforensics:x:1001:1001:Forensics User:/home/forensics:/bin/bash', 1, 'rw-r--r--'),
                (19, '10.25.35.45', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n10.25.35.45 evidence-server\n198.18.5.100 forensics-lab', 1, 'rw-r--r--'),
                (19, '10.25.35.45', '/etc/ssh/sshd_config', 'sshd_config', 0, 'Port 22\nProtocol 2\nPermitRootLogin no\nPasswordAuthentication yes\nMaxAuthTries 3\nClientAliveInterval 300', 1, 'rw-r--r--')
            "); $this->query("
                INSERT INTO mission_filesystem (mission_id, target_ip, path, name, is_directory, content, size, permissions) VALUES
                -- Single Server: 203.0.113.150 (FDA - SSH Required)
                (20, '203.0.113.150', '/', 'root', 1, NULL, 0, 'drwxr-xr-x'),
                (20, '203.0.113.150', '/home', 'home', 1, NULL, 0, 'drwxr-xr-x'),
                (20, '203.0.113.150', '/var', 'var', 1, NULL, 0, 'drwxr-xr-x'),
                (20, '203.0.113.150', '/etc', 'etc', 1, NULL, 0, 'drwxr-xr-x'),
                (20, '203.0.113.150', '/opt', 'opt', 1, NULL, 0, 'drwxr-xr-x'),
                (20, '203.0.113.150', '/tmp', 'tmp', 1, NULL, 0, 'drwxrwxrwt'),

                -- FDA Admin home
                (20, '203.0.113.150', '/home/fda_admin', 'fda_admin', 1, NULL, 0, 'drwxr-xr-x'),
                (20, '203.0.113.150', '/home/fda_admin/Desktop', 'Desktop', 1, NULL, 0, 'drwxr-xr-x'),
                (20, '203.0.113.150', '/home/fda_admin/Documents', 'Documents', 1, NULL, 0, 'drwxr-xr-x'),
                (20, '203.0.113.150', '/home/fda_admin/approvals', 'approvals', 1, NULL, 0, 'drwxr-xr-x'),
                (20, '203.0.113.150', '/home/fda_admin/pending_reviews', 'pending_reviews', 1, NULL, 0, 'drwxr-xr-x'),
                (20, '203.0.113.150', '/home/fda_admin/.bash_history', '.bash_history', 0, 'ls -la\ncd approvals\ncat approval_letter.pdf\ncd ../pending_reviews\nls\nexit', 1, 'rw-------'),
                (20, '203.0.113.150', '/home/fda_admin/approvals/approval_letter.pdf', 'approval_letter.pdf', 0, 'FDA APPROVAL LETTER\n\nDr. Robert Chen\nPharmaTech Corporation\n\nRe: NDA 022847 - OncoZero\n\nCongratulations! Your application has been APPROVED.\n\nEffective Date: November 1, 2009\n\nAPPROVED INDICATIONS:\n- Advanced lung cancer\n- Metastatic breast cancer  \n- Colorectal cancer\n\nRESULTS:\n- 47% survival improvement\n- p<0.001 statistical significance\n- Acceptable safety profile\n\nYou may begin commercial distribution immediately.\n\nDr. Margaret Thompson\nFDA Director', 6, 'rw-------'),
                (20, '203.0.113.150', '/home/fda_admin/approvals/approval_summary.txt', 'approval_summary.txt', 0, 'FDA Drug Approval Summary - October 2009\n\nDrug: OncoZero\nCompany: PharmaTech Corporation\nApplication: NDA 022847\n\nTrial Results:\n- Participants: 2,000 patients\n- Duration: 24 months\n- Primary Endpoint: Survival rate improvement\n- Result: 47% improvement (EXCELLENT)\n- Statistical Significance: p<0.001 (HIGHLY SIGNIFICANT)\n- Safety: Acceptable adverse event profile\n\nRecommendation: APPROVE\nApproval Date: November 1, 2009\n\nEstimated Market Value: $8 Billion annually\nPatient Population: 500,000+ annually', 3, 'rw-r--r--'),
                (20, '203.0.113.150', '/home/fda_admin/approvals/clinical_trial_data.txt', 'clinical_trial_data.txt', 0, 'OncoZero Clinical Trial Data\n\nPhase III Results:\n\nSurvival Rate:\n- OncoZero Group: 68% (5-year survival)\n- Standard Treatment: 21% (5-year survival)\n- Improvement: 47% (REMARKABLE)\n\nStatistical Analysis:\n- P-value: <0.001 (Highly significant)\n- Confidence Interval: 95%\n- Effect Size: Large\n\nAdverse Events:\n- Serious: 8% (acceptable)\n- Mild: 32%\n- Treatment discontinuation: 5%\n\nQuality of Life:\n- Significant improvement\n- Reduced pain scores\n- Improved daily function\n\nConclusion: Drug demonstrates exceptional efficacy', 4, 'rw-r--r--'),
                (20, '203.0.113.150', '/home/fda_admin/pending_reviews/competitor_drug_analysis.txt', 'competitor_drug_analysis.txt', 0, 'Competitor Drug Analysis\n\nGenericMeds Corporation - CancerCure\nStatus: Under Review\nEfficacy: 28% improvement\nP-value: 0.03 (marginally significant)\n\nNote: OncoZero significantly outperforms CancerCure\nMarket Impact: If OncoZero approved, CancerCure loses $5B market opportunity', 2, 'rw-r--r--'),
                (20, '203.0.113.150', '/home/fda_admin/pending_reviews/genericmeds_nda.pdf', 'genericmeds_nda.pdf', 0, 'GenericMeds Corporation - New Drug Application\n\nDrug: CancerCure\nApplication: NDA 022901\n\nStatus: PENDING REVIEW\nSubmitted: September 2009\nReview Deadline: March 2010\n\nPreliminary Assessment:\n- Efficacy: Moderate (28% improvement)\n- Safety: Acceptable\n- Manufacturing: Adequate\n\nNote: Significantly inferior to OncoZero\nLikely Outcome: Approval but limited market share', 3, 'rw-r--r--'),
                (20, '203.0.113.150', '/home/fda_admin/Desktop/schedule.txt', 'schedule.txt', 0, 'FDA Schedule - October 2009\n\nMonday: Review OncoZero final data\nTuesday: Meeting with PharmaTech representatives\nWednesday: Final approval decision\nThursday: Press release preparation\nFriday: Approval letter distribution\n\nNext Week: GenericMeds CancerCure review', 1, 'rw-r--r--'),
                (20, '203.0.113.150', '/home/fda_admin/Documents/fda_guidelines.pdf', 'fda_guidelines.pdf', 0, 'FDA Drug Approval Guidelines\n\nApproval Criteria:\n1. Safety: Acceptable risk/benefit ratio\n2. Efficacy: Statistically significant improvement (p<0.05)\n3. Manufacturing: GMP compliance\n4. Labeling: Clear and accurate\n\nStatistical Significance:\n- Primary endpoint: p<0.05 required\n- Effect size: Clinically meaningful\n- Sample size: Adequate power\n\nApproval Timeline:\n- Standard review: 10 months\n- Priority review: 6 months', 3, 'rw-r--r--'),
                (20, '203.0.113.150', '/home/fda_admin/Documents/recent_approvals.txt', 'recent_approvals.txt', 0, 'Recent FDA Drug Approvals - 2009\n\nCardioVax (Cardiovascular) - Approved March 2009\nNeuroFix (Neurological) - Approved May 2009\nDiabetesAway (Endocrine) - Approved July 2009\nOncoZero (Oncology) - Approved October 2009\n\nTotal Approvals: 24 drugs in 2009\nRejections: 8 drugs\nApproval Rate: 75%', 2, 'rw-r--r--'),
                (20, '203.0.113.150', '/var/log/auth.log', 'auth.log', 0, 'Oct 28 09:00:00 fda-server sshd[1234]: Accepted password for fda_admin\nOct 28 09:05:00 fda-server sshd[1234]: pam_unix(sshd:session): session opened\nOct 28 17:00:00 fda-server sshd[1234]: pam_unix(sshd:session): session closed', 1, 'rw-r-----'),
                (20, '203.0.113.150', '/var/log/system.log', 'system.log', 0, 'Oct 28 08:00:00 fda-server systemd[1]: System started\nOct 28 08:05:00 fda-server network[123]: Network interfaces up\nOct 28 09:00:00 fda-server sshd[456]: SSH service started', 1, 'rw-r-----'),
                (20, '203.0.113.150', '/etc/passwd', 'passwd', 0, 'root:x:0:0:root:/root:/bin/bash\nfda_admin:x:1000:1000:FDA Administrator:/home/fda_admin:/bin/bash', 1, 'rw-r--r--'),
                (20, '203.0.113.150', '/etc/hosts', 'hosts', 0, '127.0.0.1 localhost\n203.0.113.150 fda-server', 1, 'rw-r--r--')
            "); } $result = $this->query("SELECT COUNT(*) as count FROM breaking_news")->fetch(); if ($result['count'] == 0) { $this->query("
                INSERT INTO breaking_news (threshold, title, content, ticker, severity, is_game_over) VALUES
                (10, '" . t_sql('game.breaking_news.news_items.low.title') . "', '" . t_sql('game.breaking_news.news_items.low.content') . "', '" . t_sql('game.breaking_news.news_items.low.ticker') . "', 'low', 0),
                (30, '" . t_sql('game.breaking_news.news_items.medium1.title') . "', '" . t_sql('game.breaking_news.news_items.medium1.content') . "', '" . t_sql('game.breaking_news.news_items.medium1.ticker') . "', 'medium', 0),
                (50, '" . t_sql('game.breaking_news.news_items.medium2.title') . "', '" . t_sql('game.breaking_news.news_items.medium2.content') . "', '" . t_sql('game.breaking_news.news_items.medium2.ticker') . "', 'medium', 0),
                (80, '" . t_sql('game.breaking_news.news_items.high.title') . "', '" . t_sql('game.breaking_news.news_items.high.content') . "', '" . t_sql('game.breaking_news.news_items.high.ticker') . "', 'high', 0),
                (100, '" . t_sql('game.breaking_news.news_items.critical.title') . "', '" . t_sql('game.breaking_news.news_items.critical.content') . "', '" . t_sql('game.breaking_news.news_items.critical.ticker') . "', 'critical', 1)
            "); } $result = $this->query("SELECT COUNT(*) as count FROM tutorials")->fetch(); if ($result['count'] == 0) { $this->query("
                INSERT INTO tutorials (type, step, completed) VALUES
                ('BASIC', 1, 0),
                ('NODE', 1, 0)
            "); } $result = $this->query("SELECT COUNT(*) as count FROM crypto_wallet")->fetch(); if ($result['count'] == 0) { $this->query("INSERT INTO crypto_wallet (tsx_balance, total_earned, total_spent) VALUES (0.0, 0.0, 0.0)"); } $result = $this->query("SELECT COUNT(*) as count FROM tsx_price_history")->fetch(); if ($result['count'] == 0) { $this->query("
                INSERT INTO tsx_price_history (price, game_year, game_month, game_day, change_percent, volume)
                VALUES (1.0, 2000, 1, 1, 0.0, 0.0)
            "); } try { $columns = $this->query("PRAGMA table_info(mission_filesystem)")->fetchAll(); $columnNames = array_column($columns, 'name'); if (!in_array('ssh_required', $columnNames)) { $this->pdo->exec("ALTER TABLE mission_filesystem ADD COLUMN ssh_required INTEGER DEFAULT 0"); } if (!in_array('ssh_username', $columnNames)) { $this->pdo->exec("ALTER TABLE mission_filesystem ADD COLUMN ssh_username TEXT"); } if (!in_array('ssh_password', $columnNames)) { $this->pdo->exec("ALTER TABLE mission_filesystem ADD COLUMN ssh_password TEXT"); } $progressColumns = $this->query("PRAGMA table_info(mission_progress)")->fetchAll(); $progressColumnNames = array_column($progressColumns, 'name'); if (!in_array('copied_files', $progressColumnNames)) { $this->pdo->exec("ALTER TABLE mission_progress ADD COLUMN copied_files TEXT DEFAULT ''"); } $this->query("
                UPDATE mission_filesystem
                SET ssh_required = 1,
                    ssh_username = 'hr_admin',
                    ssh_password = 'TechHR2006!'
                WHERE mission_id = 13
                AND target_ip = '10.15.20.30'
                AND path = '/'
            "); $this->query("
                UPDATE mission_filesystem
                SET ssh_required = 1,
                    ssh_username = 'emailadmin',
                    ssh_password = 'MediaSecure2007!'
                WHERE mission_id = 15
                AND target_ip = '172.16.45.122'
                AND path = '/'
            "); $this->query("
                UPDATE mission_filesystem
                SET ssh_required = 1,
                    ssh_username = 'ceo',
                    ssh_password = 'FinanceCEO2007'
                WHERE mission_id = 16
                AND target_ip = '172.16.0.100'
                AND path = '/'
            "); $this->query("
                UPDATE mission_filesystem
                SET ssh_required = 1,
                    ssh_username = 'vaultkeeper',
                    ssh_password = 'DarkVault2008#Secure'
                WHERE mission_id = 17
                AND target_ip = '198.18.0.50'
                AND path = '/'
            "); $this->query("
                UPDATE mission_filesystem
                SET ssh_required = 1,
                    ssh_username = 'eu_manager',
                    ssh_password = 'EuroTech2008!'
                WHERE mission_id = 18
                AND target_ip = '10.50.60.70'
                AND path = '/'
            "); $this->query("
                UPDATE mission_filesystem
                SET ssh_required = 1,
                    ssh_username = 'asia_manager',
                    ssh_password = 'AsiaTech2008!'
                WHERE mission_id = 18
                AND target_ip = '172.20.30.40'
                AND path = '/'
            "); $this->query("
                UPDATE mission_filesystem
                SET ssh_required = 1,
                    ssh_username = 'latam_manager',
                    ssh_password = 'LatamTech2008!'
                WHERE mission_id = 18
                AND target_ip = '192.168.100.50'
                AND path = '/'
            "); $this->query("
                UPDATE mission_filesystem
                SET ssh_required = 1,
                    ssh_username = 'criminal',
                    ssh_password = 'CriminalPass2009'
                WHERE mission_id = 19
                AND target_ip = '10.25.35.45'
                AND path = '/'
            "); $this->query("
                UPDATE mission_filesystem
                SET ssh_required = 1,
                    ssh_username = 'fdafda',
                    ssh_password = 'fda6fda'
                WHERE mission_id = 20
                AND target_ip = '203.0.113.150'
                AND path = '/'
            "); $this->query("
                UPDATE mission_filesystem
                SET ssh_required = 1,
                    ssh_username = 'admin',
                    ssh_password = 'B\$Pass2000'
                WHERE mission_id = 2
                AND target_ip = '10.0.5.22'
                AND path = '/'
            "); $this->query("
                UPDATE mission_filesystem
                SET ssh_required = 1,
                    ssh_username = 'backup_admin',
                    ssh_password = 'BackupSecure2002'
                WHERE mission_id = 6
                AND target_ip = '10.10.0.5'
                AND path = '/'
            "); } catch (Exception $e) { error_log("SSH columns migration error: " . $e->getMessage()); } } public function query($sql, $params = []) { try { $stmt = $this->pdo->prepare($sql); $stmt->execute($params); return $stmt; } catch(PDOException $e) { throw new Exception("Query failed: " . $e->getMessage()); } } public function lastInsertId() { return $this->pdo->lastInsertId(); } public function exec($sql) { try { return $this->pdo->exec($sql); } catch (PDOException $e) { error_log("Error executing SQL: " . $e->getMessage()); throw $e; } } public function __sleep() { return ['dbPath']; } public function __wakeup() { $this->connect(); } public static function closeConnection() { if (self::$instance !== null) { self::$instance->pdo = null; self::$instance = null; } } } 